/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

public class Export
extends AbstractAlgorithm {
    private static final long serialVersionUID = 2371128340113896073L;
    public static final String DESCRIPTION = "export a matrix to a file";
    public static final String FILE = "Filename";
    public static final String FORMAT = "Format";

    public Export(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey(FILE);
        this.addVariableKey(FORMAT);
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel(FILE, FILE);
        this.setEdgeLabel(FORMAT, FORMAT);
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(FILE, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection(FORMAT, Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        try {
            String file = null;
            HashMap<String, Object> result = new HashMap<String, Object>();
            Matrix matrix = MathUtil.getMatrix(input.get("Source"));
            Object o1 = input.get(FILE);
            file = o1 != null ? StringUtil.format(o1) : File.createTempFile("jdmp_matrix", ".CSV").getAbsolutePath();
            matrix.exportTo().file(new File(file)).asDenseCSV();
            result.put("Target", matrix);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

