/*
 * Decompiled with CFR 0.152.
 */
package org.jdmp.core.algorithm.basic;

import java.util.HashMap;
import java.util.Map;
import org.jdmp.core.algorithm.AbstractAlgorithm;
import org.jdmp.core.algorithm.Algorithm;
import org.jdmp.core.variable.Variable;
import org.ujmp.core.util.StringUtil;

public class Exec
extends AbstractAlgorithm {
    private static final long serialVersionUID = -47358904261935093L;
    public static final String DESCRIPTION = "executes a System command";

    public Exec(Variable ... variables) {
        this.setDescription(DESCRIPTION);
        this.addVariableKey("Source");
        this.addVariableKey("Target");
        this.setEdgeLabel("Source", "Source");
        this.setEdgeLabel("Target", "Target");
        this.setEdgeDirection("Source", Algorithm.EdgeDirection.Incoming);
        this.setEdgeDirection("Target", Algorithm.EdgeDirection.Outgoing);
        this.setVariables(variables);
    }

    @Override
    public Map<String, Object> calculateObjects(Map<String, Object> input) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            String command = StringUtil.convert(input.get("Source"));
            Process p = Runtime.getRuntime().exec(command);
            int ret = p.waitFor();
            result.put("Target", ret);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

