/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.EXCEPINFO;
import org.eclipse.swt.internal.ole.win32.FUNCDESC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.ITypeInfo;
import org.eclipse.swt.internal.ole.win32.TYPEATTR;
import org.eclipse.swt.internal.ole.win32.VARDESC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleParameterDescription;
import org.eclipse.swt.ole.win32.OlePropertyDescription;
import org.eclipse.swt.ole.win32.Variant;

public final class OleAutomation {
    private IDispatch objIDispatch;
    private String exceptionDescription;
    private ITypeInfo objITypeInfo;

    OleAutomation(IDispatch iDispatch) {
        if (iDispatch == null) {
            OLE.error(1011);
        }
        this.objIDispatch = iDispatch;
        this.objIDispatch.AddRef();
        int[] nArray = new int[1];
        int n = this.objIDispatch.GetTypeInfo(0, 2048, nArray);
        if (n == 0) {
            this.objITypeInfo = new ITypeInfo(nArray[0]);
            this.objITypeInfo.AddRef();
        }
    }

    public OleAutomation(OleClientSite oleClientSite) {
        if (oleClientSite == null) {
            OLE.error(1011);
        }
        this.objIDispatch = oleClientSite.getAutomationObject();
        int[] nArray = new int[1];
        int n = this.objIDispatch.GetTypeInfo(0, 2048, nArray);
        if (n == 0) {
            this.objITypeInfo = new ITypeInfo(nArray[0]);
            this.objITypeInfo.AddRef();
        }
    }

    public void dispose() {
        if (this.objIDispatch != null) {
            this.objIDispatch.Release();
        }
        this.objIDispatch = null;
        if (this.objITypeInfo != null) {
            this.objITypeInfo.Release();
        }
        this.objITypeInfo = null;
    }

    int getAddress() {
        return this.objIDispatch.getAddress();
    }

    public String getHelpFile(int n) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] stringArray = new String[1];
        int n2 = this.objITypeInfo.GetDocumentation(n, null, null, null, stringArray);
        if (n2 == 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getDocumentation(int n) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] stringArray = new String[1];
        int n2 = this.objITypeInfo.GetDocumentation(n, null, stringArray, null, null);
        if (n2 == 0) {
            return stringArray[0];
        }
        return null;
    }

    public OlePropertyDescription getPropertyDescription(int n) {
        if (this.objITypeInfo == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n2 = this.objITypeInfo.GetVarDesc(n, nArray);
        if (n2 != 0) {
            return null;
        }
        VARDESC vARDESC = new VARDESC();
        COM.MoveMemory(vARDESC, nArray[0], VARDESC.sizeof);
        OlePropertyDescription olePropertyDescription = new OlePropertyDescription();
        olePropertyDescription.id = vARDESC.memid;
        olePropertyDescription.name = this.getName(vARDESC.memid);
        olePropertyDescription.type = vARDESC.elemdescVar_tdesc_vt;
        if (olePropertyDescription.type == 26) {
            short[] sArray = new short[1];
            COM.MoveMemory(sArray, vARDESC.elemdescVar_tdesc_union + 4, 2);
            olePropertyDescription.type = sArray[0];
        }
        olePropertyDescription.flags = vARDESC.wVarFlags;
        olePropertyDescription.kind = vARDESC.varkind;
        olePropertyDescription.description = this.getDocumentation(vARDESC.memid);
        olePropertyDescription.helpFile = this.getHelpFile(vARDESC.memid);
        this.objITypeInfo.ReleaseVarDesc(nArray[0]);
        return olePropertyDescription;
    }

    public OleFunctionDescription getFunctionDescription(int n) {
        if (this.objITypeInfo == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n2 = this.objITypeInfo.GetFuncDesc(n, nArray);
        if (n2 != 0) {
            return null;
        }
        FUNCDESC fUNCDESC = new FUNCDESC();
        COM.MoveMemory(fUNCDESC, nArray[0], FUNCDESC.sizeof);
        OleFunctionDescription oleFunctionDescription = new OleFunctionDescription();
        oleFunctionDescription.id = fUNCDESC.memid;
        oleFunctionDescription.optionalArgCount = fUNCDESC.cParamsOpt;
        oleFunctionDescription.invokeKind = fUNCDESC.invkind;
        oleFunctionDescription.funcKind = fUNCDESC.funckind;
        oleFunctionDescription.flags = fUNCDESC.wFuncFlags;
        oleFunctionDescription.callingConvention = fUNCDESC.callconv;
        oleFunctionDescription.documentation = this.getDocumentation(fUNCDESC.memid);
        oleFunctionDescription.helpFile = this.getHelpFile(fUNCDESC.memid);
        String[] stringArray = this.getNames(fUNCDESC.memid, fUNCDESC.cParams + 1);
        if (stringArray.length > 0) {
            oleFunctionDescription.name = stringArray[0];
        }
        oleFunctionDescription.args = new OleParameterDescription[fUNCDESC.cParams];
        int n3 = 0;
        while (n3 < oleFunctionDescription.args.length) {
            Object[] objectArray;
            oleFunctionDescription.args[n3] = new OleParameterDescription();
            if (stringArray.length > n3 + 1) {
                oleFunctionDescription.args[n3].name = stringArray[n3 + 1];
            }
            short[] sArray = new short[1];
            COM.MoveMemory(sArray, fUNCDESC.lprgelemdescParam + n3 * 16 + 4, 2);
            if (sArray[0] == 26) {
                objectArray = new int[1];
                COM.MoveMemory(objectArray, fUNCDESC.lprgelemdescParam + n3 * 16, 4);
                short[] sArray2 = new short[1];
                COM.MoveMemory(sArray2, objectArray[0] + 4, 2);
                sArray[0] = (short)(sArray2[0] | 0x4000);
            }
            oleFunctionDescription.args[n3].type = sArray[0];
            objectArray = new short[1];
            COM.MoveMemory((short[])objectArray, fUNCDESC.lprgelemdescParam + n3 * 16 + 12, 2);
            oleFunctionDescription.args[n3].flags = (short)objectArray[0];
            ++n3;
        }
        oleFunctionDescription.returnType = fUNCDESC.elemdescFunc_tdesc_vt;
        if (oleFunctionDescription.returnType == 26) {
            short[] sArray = new short[1];
            COM.MoveMemory(sArray, fUNCDESC.elemdescFunc_tdesc_union + 4, 2);
            oleFunctionDescription.returnType = sArray[0];
        }
        this.objITypeInfo.ReleaseFuncDesc(nArray[0]);
        return oleFunctionDescription;
    }

    public TYPEATTR getTypeInfoAttributes() {
        if (this.objITypeInfo == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n = this.objITypeInfo.GetTypeAttr(nArray);
        if (n != 0) {
            return null;
        }
        TYPEATTR tYPEATTR = new TYPEATTR();
        COM.MoveMemory(tYPEATTR, nArray[0], TYPEATTR.sizeof);
        this.objITypeInfo.ReleaseTypeAttr(nArray[0]);
        return tYPEATTR;
    }

    public String getName(int n) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] stringArray = new String[1];
        int n2 = this.objITypeInfo.GetDocumentation(n, stringArray, null, null, null);
        if (n2 == 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getNames(int n, int n2) {
        if (this.objITypeInfo == null) {
            return new String[0];
        }
        String[] stringArray = new String[n2];
        int[] nArray = new int[1];
        int n3 = this.objITypeInfo.GetNames(n, stringArray, n2, nArray);
        if (n3 == 0) {
            String[] stringArray2 = new String[nArray[0]];
            System.arraycopy(stringArray, 0, stringArray2, 0, nArray[0]);
            return stringArray2;
        }
        return new String[0];
    }

    public int[] getIDsOfNames(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = this.objIDispatch.GetIDsOfNames(new GUID(), stringArray, stringArray.length, 2048, nArray);
        if (n != 0) {
            return null;
        }
        return nArray;
    }

    public String getLastError() {
        return this.exceptionDescription;
    }

    public Variant getProperty(int n) {
        Variant variant = new Variant();
        int n2 = this.invoke(n, 2, null, null, variant);
        return n2 == 0 ? variant : null;
    }

    public Variant getProperty(int n, Variant[] variantArray) {
        Variant variant = new Variant();
        int n2 = this.invoke(n, 2, variantArray, null, variant);
        return n2 == 0 ? variant : null;
    }

    public Variant getProperty(int n, Variant[] variantArray, int[] nArray) {
        Variant variant = new Variant();
        int n2 = this.invoke(n, 2, variantArray, nArray, variant);
        return n2 == 0 ? variant : null;
    }

    public Variant invoke(int n) {
        Variant variant = new Variant();
        int n2 = this.invoke(n, 1, null, null, variant);
        return n2 == 0 ? variant : null;
    }

    public Variant invoke(int n, Variant[] variantArray) {
        Variant variant = new Variant();
        int n2 = this.invoke(n, 1, variantArray, null, variant);
        return n2 == 0 ? variant : null;
    }

    public Variant invoke(int n, Variant[] variantArray, int[] nArray) {
        Variant variant = new Variant();
        int n2 = this.invoke(n, 1, variantArray, nArray, variant);
        return n2 == 0 ? variant : null;
    }

    private int invoke(int n, int n2, Variant[] variantArray, int[] nArray, Variant variant) {
        int n3;
        int n4;
        if (this.objIDispatch == null) {
            return -2147467259;
        }
        DISPPARAMS dISPPARAMS = new DISPPARAMS();
        if (variantArray != null && variantArray.length > 0) {
            dISPPARAMS.cArgs = variantArray.length;
            dISPPARAMS.rgvarg = OS.GlobalAlloc(64, 16 * variantArray.length);
            n4 = 0;
            n3 = variantArray.length - 1;
            while (n3 >= 0) {
                variantArray[n3].getData(dISPPARAMS.rgvarg + n4);
                n4 += 16;
                --n3;
            }
        }
        if (nArray != null && nArray.length > 0) {
            dISPPARAMS.cNamedArgs = nArray.length;
            dISPPARAMS.rgdispidNamedArgs = OS.GlobalAlloc(64, 4 * nArray.length);
            n4 = 0;
            n3 = nArray.length;
            while (n3 > 0) {
                COM.MoveMemory(dISPPARAMS.rgdispidNamedArgs + n4, new int[]{nArray[n3 - 1]}, 4);
                n4 += 4;
                --n3;
            }
        }
        EXCEPINFO eXCEPINFO = new EXCEPINFO();
        int[] nArray2 = new int[1];
        int n5 = 0;
        if (variant != null) {
            n5 = OS.GlobalAlloc(64, 16);
        }
        int n6 = this.objIDispatch.Invoke(n, new GUID(), 2048, n2, dISPPARAMS, n5, eXCEPINFO, nArray2);
        if (n5 != 0) {
            variant.setData(n5);
            COM.VariantClear(n5);
            OS.GlobalFree(n5);
        }
        if (dISPPARAMS.rgdispidNamedArgs != 0) {
            OS.GlobalFree(dISPPARAMS.rgdispidNamedArgs);
        }
        if (dISPPARAMS.rgvarg != 0) {
            int n7 = 0;
            int n8 = 0;
            int n9 = variantArray.length;
            while (n8 < n9) {
                COM.VariantClear(dISPPARAMS.rgvarg + n7);
                n7 += 16;
                ++n8;
            }
            OS.GlobalFree(dISPPARAMS.rgvarg);
        }
        this.manageExcepinfo(n6, eXCEPINFO);
        return n6;
    }

    public void invokeNoReply(int n) {
        int n2 = this.invoke(n, 1, null, null, null);
        if (n2 != 0) {
            OLE.error(1014, n2);
        }
    }

    public void invokeNoReply(int n, Variant[] variantArray) {
        int n2 = this.invoke(n, 1, variantArray, null, null);
        if (n2 != 0) {
            OLE.error(1014, n2);
        }
    }

    public void invokeNoReply(int n, Variant[] variantArray, int[] nArray) {
        int n2 = this.invoke(n, 1, variantArray, nArray, null);
        if (n2 != 0) {
            OLE.error(1014, n2);
        }
    }

    private void manageExcepinfo(int n, EXCEPINFO eXCEPINFO) {
        if (n == 0) {
            this.exceptionDescription = "No Error";
            return;
        }
        if (n == -2147352567) {
            if (eXCEPINFO.bstrDescription != 0) {
                int n2 = COM.SysStringByteLen(eXCEPINFO.bstrDescription);
                char[] cArray = new char[(n2 + 1) / 2];
                COM.MoveMemory(cArray, eXCEPINFO.bstrDescription, n2);
                this.exceptionDescription = new String(cArray);
            } else {
                this.exceptionDescription = "OLE Automation Error Exception ";
                if (eXCEPINFO.wCode != 0) {
                    this.exceptionDescription = String.valueOf(this.exceptionDescription) + "code = " + eXCEPINFO.wCode;
                } else if (eXCEPINFO.scode != 0) {
                    this.exceptionDescription = String.valueOf(this.exceptionDescription) + "code = " + eXCEPINFO.scode;
                }
            }
        } else {
            this.exceptionDescription = "OLE Automation Error HResult : " + n;
        }
        if (eXCEPINFO.bstrDescription != 0) {
            COM.SysFreeString(eXCEPINFO.bstrDescription);
        }
        if (eXCEPINFO.bstrHelpFile != 0) {
            COM.SysFreeString(eXCEPINFO.bstrHelpFile);
        }
        if (eXCEPINFO.bstrSource != 0) {
            COM.SysFreeString(eXCEPINFO.bstrSource);
        }
    }

    public boolean setProperty(int n, Variant variant) {
        Variant variant2;
        int n2;
        Variant[] variantArray = new Variant[]{variant};
        int[] nArray = new int[]{-3};
        int n3 = 4;
        if ((variant.getType() & 0x4000) == 16384) {
            n3 = 8;
        }
        return (n2 = this.invoke(n, n3, variantArray, nArray, variant2 = new Variant())) == 0;
    }

    public boolean setProperty(int n, Variant[] variantArray) {
        int[] nArray = new int[]{-3};
        int n2 = 4;
        int n3 = 0;
        while (n3 < variantArray.length) {
            if ((variantArray[n3].getType() & 0x4000) == 16384) {
                n2 = 8;
            }
            ++n3;
        }
        Variant variant = new Variant();
        int n4 = this.invoke(n, n2, variantArray, nArray, variant);
        return n4 == 0;
    }
}

