/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import functionplotter.exception.AppException;
import functionplotter.exception.ExceptionUtilities;
import java.io.File;
import java.net.URL;

public class XmlParseException
extends AppException {
    private static final int MAX_PATHNAME_LENGTH = 160;
    private static final String NAME_STR = "Name: ";
    private static final String VALUE_STR = "Value: ";
    private File file;
    private URL url;
    private String name;
    private String value;

    public XmlParseException(AppException.Id id, String string) {
        super(id);
        this.name = string;
    }

    public XmlParseException(AppException.Id id, String string, String[] stringArray) {
        super(id, stringArray);
        this.name = string;
    }

    public XmlParseException(AppException.Id id, String string, String string2) {
        this(id, string);
        this.value = string2;
    }

    public XmlParseException(AppException.Id id, String string, String string2, String[] stringArray) {
        this(id, string, stringArray);
        this.value = string2;
    }

    public XmlParseException(AppException.Id id, File file, String string) {
        this(id, string);
        this.file = file;
    }

    public XmlParseException(AppException.Id id, URL uRL, String string) {
        this(id, string);
        this.url = uRL;
    }

    public XmlParseException(AppException.Id id, File file, String string, String string2) {
        this(id, file, string);
        this.value = string2;
    }

    public XmlParseException(AppException.Id id, URL uRL, String string, String string2) {
        this(id, uRL, string);
        this.value = string2;
    }

    public XmlParseException(AppException.Id id, File file, String[] stringArray) {
        super(id, stringArray);
        this.file = file;
    }

    public XmlParseException(AppException.Id id, URL uRL, String[] stringArray) {
        super(id, stringArray);
        this.url = uRL;
    }

    public XmlParseException(AppException.Id id, File file, String string, String[] stringArray) {
        this(id, file, stringArray);
        this.name = string;
    }

    public XmlParseException(AppException.Id id, URL uRL, String string, String[] stringArray) {
        this(id, uRL, stringArray);
        this.name = string;
    }

    public XmlParseException(AppException.Id id, File file, String string, String string2, String[] stringArray) {
        this(id, file, string, stringArray);
        this.value = string2;
    }

    public XmlParseException(AppException.Id id, URL uRL, String string, String string2, String[] stringArray) {
        this(id, uRL, string, stringArray);
        this.value = string2;
    }

    public XmlParseException(XmlParseException xmlParseException, File file) {
        this(xmlParseException.getId(), file, xmlParseException.name, xmlParseException.value, xmlParseException.getSubstitutionStrings());
    }

    public XmlParseException(XmlParseException xmlParseException, URL uRL) {
        this(xmlParseException.getId(), uRL, xmlParseException.name, xmlParseException.value, xmlParseException.getSubstitutionStrings());
    }

    protected static String getPathname(File file) {
        return ExceptionUtilities.getLimitedPathname(file, 160);
    }

    @Override
    public String getPrefix() {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.file != null) {
            stringBuilder.append(XmlParseException.getPathname(this.file));
            stringBuilder.append('\n');
        }
        if (this.url != null) {
            stringBuilder.append(this.url);
            stringBuilder.append('\n');
        }
        if (this.name != null) {
            stringBuilder.append(NAME_STR);
            stringBuilder.append(this.name);
            stringBuilder.append('\n');
        }
        if (this.value != null) {
            stringBuilder.append(VALUE_STR);
            stringBuilder.append(this.value);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

