/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.List;

public class StringUtilities {
    public static final String CHARSET_NAME_UTF8 = "UTF-8";
    public static final String SUBSTITUTION_PLACEHOLDER_PREFIX = "%";
    private static final int MIN_SUBSTITUTION_INDEX = 1;

    private StringUtilities() {
    }

    public static boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static char[] createCharArray(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return cArray;
    }

    public static String createCharString(char c, int n) {
        return new String(StringUtilities.createCharArray(c, n));
    }

    public static String firstCharToLowerCase(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String firstCharsToLowerCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = true;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (bl) {
                stringBuilder.setCharAt(i, Character.toLowerCase(c));
            }
            bl = c == ' ' || c == '-';
        }
        return stringBuilder.toString();
    }

    public static String firstCharToUpperCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String firstCharsToUpperCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = true;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (bl) {
                stringBuilder.setCharAt(i, Character.toUpperCase(c));
            }
            bl = c == ' ' || c == '-';
        }
        return stringBuilder.toString();
    }

    public static int getMaximumLength(List<? extends CharSequence> list) {
        int n = 0;
        for (CharSequence charSequence : list) {
            int n2 = charSequence.length();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public static int getMaximumLength(String[] stringArray) {
        return StringUtilities.getMaximumLength(Arrays.asList(stringArray));
    }

    public static String stripBefore(CharSequence charSequence) {
        int n;
        for (n = 0; n < charSequence.length() && Character.isWhitespace(charSequence.charAt(n)); ++n) {
        }
        return charSequence.subSequence(n, charSequence.length()).toString();
    }

    public static String stripAfter(CharSequence charSequence) {
        int n;
        for (n = charSequence.length() - 1; n >= 0 && Character.isWhitespace(charSequence.charAt(n)); --n) {
        }
        return charSequence.subSequence(0, n + 1).toString();
    }

    public static String padBefore(CharSequence charSequence, int n, char c) {
        int n2 = n - charSequence.length();
        return n2 > 0 ? new String(StringUtilities.createCharArray(c, n2)) + charSequence.toString() : charSequence.toString();
    }

    public static String padAfter(CharSequence charSequence, int n, char c) {
        int n2 = n - charSequence.length();
        return n2 > 0 ? charSequence.toString() + new String(StringUtilities.createCharArray(c, n2)) : charSequence.toString();
    }

    public static String concatenate(List<? extends CharSequence> list, CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (int i = 0; i < list.size(); ++i) {
            if (charSequence != null && i > 0) {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(list.get(i));
        }
        return stringBuilder.toString();
    }

    public static String concatenate(String[] stringArray, CharSequence charSequence) {
        return StringUtilities.concatenate(Arrays.asList(stringArray), charSequence);
    }

    public static String substitute(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return StringUtilities.substitute(string, stringArray);
    }

    public static String substitute(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 0;
        while (n < stringBuilder.length()) {
            int n2;
            if ((n = stringBuilder.indexOf(SUBSTITUTION_PLACEHOLDER_PREFIX, n)) < 0) {
                n = stringBuilder.length();
            }
            int n3 = ++n;
            while (n < stringBuilder.length() && (n2 = stringBuilder.charAt(n)) >= 48 && n2 <= 57) {
                ++n;
            }
            if (n <= n3 || (n2 = Integer.parseInt(stringBuilder.substring(n3, n)) - 1) < 0 || n2 >= stringArray.length) continue;
            String string2 = stringArray[n2];
            if (string2 == null) {
                string2 = new String();
            }
            stringBuilder.replace(--n3, n, string2);
            n = n3 + string2.length();
        }
        return stringBuilder.toString();
    }

    public static String substituteInteger(String string, int n) {
        return StringUtilities.substitute(string, Integer.toString(n));
    }

    public static String applyPrefix(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string2;
        }
        return string + (string.endsWith("_") ? string2 : StringUtilities.firstCharToUpperCase(string2));
    }

    public static String utf8ToString(byte[] byArray) throws IllegalArgumentException, UnsupportedCharsetException {
        return StringUtilities.utf8ToString(byArray, 0, byArray.length);
    }

    public static String utf8ToString(byte[] byArray, int n, int n2) throws IllegalArgumentException, UnsupportedCharsetException {
        try {
            CharsetDecoder charsetDecoder = Charset.forName(CHARSET_NAME_UTF8).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            return charsetDecoder.decode(ByteBuffer.wrap(byArray, n, n2)).toString();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw unsupportedCharsetException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public static byte[] stringToUtf8(String string) throws UnsupportedCharsetException {
        try {
            return string.getBytes(CHARSET_NAME_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(CHARSET_NAME_UTF8);
        }
    }
}

