/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.util.ColourUtilities;
import functionplotter.util.DoubleRange;
import functionplotter.util.IntegerRange;
import functionplotter.util.NoYes;
import functionplotter.util.Numeric;
import functionplotter.util.StringKeyed;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

public abstract class Property
implements StringKeyed {
    public static final int NUM_INDEX_DIGITS = 3;
    public static final int DEFAULT_MAX_NUM_LIST_ELEMENTS = 1000;
    public static final String KEY_SEPARATOR = ".";
    public static final String APP_PREFIX = "app.";
    public static final String FIELD_PREFIX = "cp";
    private static SystemSource systemSource;
    protected String key;
    protected boolean changed;

    protected Property(String string) {
        this.key = string;
    }

    public static Source getSystemSource() {
        if (systemSource == null) {
            systemSource = new SystemSource();
        }
        return systemSource;
    }

    public static String indexToKey(int n) {
        return Numeric.uIntToDecString(n, 3, '0');
    }

    public static String keyToName(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n = i;
            if ((i = string.indexOf(KEY_SEPARATOR, i)) < 0) {
                i = string.length();
            }
            if (i <= n) continue;
            char c = string.charAt(n);
            stringBuilder.append(n > 0 || bl ? Character.toUpperCase(c) : c);
            stringBuilder.append(string.substring(n + 1, i));
        }
        return stringBuilder.toString();
    }

    public abstract void get(Source[] var1) throws AppException;

    public abstract boolean put(Target var1);

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    private static class SystemSource
    implements Source {
        private static final String SYSTEM_PROPERTY_STR = "System property";

        private SystemSource() {
        }

        @Override
        public String getSourceName() {
            return SYSTEM_PROPERTY_STR;
        }

        @Override
        public String getProperty(String string) {
            return System.getProperty(Property.APP_PREFIX + string);
        }
    }

    protected static class InputException
    extends AppException {
        private static final String KEY_STR = "Key: ";
        private static final String VALUE_STR = "Value: ";
        private String prefix;

        public InputException(AppException.Id id, Input input) {
            super(id);
            this.prefix = "[ " + input.source.getSourceName() + " ]\n" + KEY_STR + input.key + "\n" + VALUE_STR + input.value + "\n";
        }

        public InputException(AppException appException, Input input) {
            this(appException.getId(), input);
        }

        @Override
        protected String getPrefix() {
            return this.prefix;
        }
    }

    public static class ListIndexOutOfOrderException
    extends InputException {
        public ListIndexOutOfOrderException(Input input) {
            super((AppException.Id)ErrorId.LIST_INDEX_OUT_OF_ORDER, input);
        }
    }

    public static class ListIndexOutOfBoundsException
    extends InputException {
        public ListIndexOutOfBoundsException(Input input) {
            super((AppException.Id)ErrorId.LIST_INDEX_OUT_OF_BOUNDS, input);
        }
    }

    public static class ValuesOutOfOrderException
    extends InputException {
        public ValuesOutOfOrderException(Input input) {
            super((AppException.Id)ErrorId.VALUES_OUT_OF_ORDER, input);
        }
    }

    public static class ValueOutOfBoundsException
    extends InputException {
        public ValueOutOfBoundsException(Input input) {
            super((AppException.Id)ErrorId.VALUE_OUT_OF_BOUNDS, input);
        }
    }

    public static class IllegalValueException
    extends InputException {
        public IllegalValueException(Input input) {
            super((AppException.Id)ErrorId.ILLEGAL_VALUE, input);
        }
    }

    public static class IllegalKeyException
    extends InputException {
        public IllegalKeyException(Input input) {
            super((AppException.Id)ErrorId.ILLEGAL_KEY, input);
        }
    }

    public static class Input {
        private Source source;
        private String key;
        private String value;

        public Input(Source source, String string, String string2) {
            this.source = source;
            this.key = string;
            this.value = string2;
        }

        public static Input create(Source[] sourceArray, String string) {
            Input input = null;
            for (Source source : sourceArray) {
                String string2 = source.getProperty(string);
                if (string2 == null) continue;
                input = new Input(source, string, string2);
                break;
            }
            return input;
        }

        public Source getSource() {
            return this.source;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean parseBoolean() throws AppException {
            NoYes noYes = NoYes.get(this.value);
            if (noYes == null) {
                throw new IllegalValueException(this);
            }
            return new Boolean(noYes.toBoolean());
        }

        public Integer parseInteger(IntegerRange integerRange) throws AppException {
            return this.parseInteger(integerRange, 10);
        }

        public Integer parseInteger(IntegerRange integerRange, int n) throws AppException {
            try {
                Integer n2 = Integer.parseInt(this.value, n);
                if (integerRange != null && !integerRange.contains(n2)) {
                    throw new ValueOutOfBoundsException(this);
                }
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalValueException(this);
            }
        }

        public int[] parseIntegers(int n, IntegerRange[] integerRangeArray) throws AppException {
            return this.parseIntegers(n, integerRangeArray, null, 10);
        }

        public int[] parseIntegers(int n, IntegerRange[] integerRangeArray, int n2) throws AppException {
            return this.parseIntegers(n, integerRangeArray, null, n2);
        }

        public int[] parseIntegers(int n, IntegerRange[] integerRangeArray, Order order) throws AppException {
            return this.parseIntegers(n, integerRangeArray, order, 10);
        }

        public int[] parseIntegers(int n, IntegerRange[] integerRangeArray, Order order, int n2) throws AppException {
            String[] stringArray = this.value.split(" *, *", -1);
            if (stringArray.length != n) {
                throw new IllegalValueException(this);
            }
            try {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i], n2);
                    if (integerRangeArray != null && integerRangeArray[i] != null && !integerRangeArray[i].contains(nArray[i])) {
                        throw new ValueOutOfBoundsException(this);
                    }
                    if (order == null || i <= 0) continue;
                    boolean bl = false;
                    switch (order) {
                        case LESS_THAN: {
                            bl = nArray[i] < nArray[i - 1];
                            break;
                        }
                        case LESS_THAN_OR_EQUAL_TO: {
                            bl = nArray[i] <= nArray[i - 1];
                            break;
                        }
                        case GREATER_THAN: {
                            bl = nArray[i] > nArray[i - 1];
                            break;
                        }
                        case GREATER_THAN_OR_EQUAL_TO: {
                            boolean bl2 = bl = nArray[i] >= nArray[i - 1];
                        }
                    }
                    if (bl) continue;
                    throw new ValuesOutOfOrderException(this);
                }
                return nArray;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalValueException(this);
            }
        }

        public Double parseDouble(DoubleRange doubleRange) throws AppException {
            try {
                Double d = new Double(this.value);
                if (doubleRange != null && !doubleRange.contains(d)) {
                    throw new ValueOutOfBoundsException(this);
                }
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalValueException(this);
            }
        }

        public double[] parseDoubles(int n, DoubleRange[] doubleRangeArray) throws AppException {
            return this.parseDoubles(n, doubleRangeArray, null);
        }

        public double[] parseDoubles(int n, DoubleRange[] doubleRangeArray, Order order) throws AppException {
            String[] stringArray = this.value.split(" *, *", -1);
            if (stringArray.length != n) {
                throw new IllegalValueException(this);
            }
            try {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                    if (doubleRangeArray != null && doubleRangeArray[i] != null && !doubleRangeArray[i].contains(dArray[i])) {
                        throw new ValueOutOfBoundsException(this);
                    }
                    if (order == null || i <= 0) continue;
                    boolean bl = false;
                    switch (order) {
                        case LESS_THAN: {
                            bl = dArray[i] < dArray[i - 1];
                            break;
                        }
                        case LESS_THAN_OR_EQUAL_TO: {
                            bl = dArray[i] <= dArray[i - 1];
                            break;
                        }
                        case GREATER_THAN: {
                            bl = dArray[i] > dArray[i - 1];
                            break;
                        }
                        case GREATER_THAN_OR_EQUAL_TO: {
                            boolean bl2 = bl = dArray[i] >= dArray[i - 1];
                        }
                    }
                    if (bl) continue;
                    throw new ValuesOutOfOrderException(this);
                }
                return dArray;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalValueException(this);
            }
        }

        public Color parseColour() throws AppException {
            try {
                return ColourUtilities.parseColour(this.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalValueException(this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ValueOutOfBoundsException(this);
            }
        }
    }

    public static abstract class PropertyMapMap<E1 extends Enum<E1>, E2 extends Enum<E2>, T>
    extends Property {
        protected Class<E1> map1KeyClass;
        protected Class<E2> map2KeyClass;
        protected EnumMap<E1, EnumMap<E2, T>> values;

        public PropertyMapMap(String string, Class<E1> clazz, Class<E2> clazz2) {
            super(string);
            this.map1KeyClass = clazz;
            this.map2KeyClass = clazz2;
            this.values = new EnumMap(clazz);
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                this.values.put(enum_, new EnumMap(clazz2));
            }
        }

        protected abstract void parse(Input var1, E1 var2, E2 var3) throws AppException;

        protected abstract String toString(E1 var1, E2 var2);

        @Override
        public void get(Source[] sourceArray) throws AppException {
            for (Enum enum_ : (Enum[])this.map1KeyClass.getEnumConstants()) {
                for (Enum enum_2 : (Enum[])this.map2KeyClass.getEnumConstants()) {
                    this.getEntry(sourceArray, enum_, enum_2);
                }
            }
        }

        @Override
        public boolean put(Target target) {
            boolean bl = true;
            for (Enum enum_ : (Enum[])this.map1KeyClass.getEnumConstants()) {
                for (Enum enum_2 : (Enum[])this.map2KeyClass.getEnumConstants()) {
                    if (this.putEntry(target, enum_, enum_2)) continue;
                    bl = false;
                }
            }
            return bl;
        }

        public EnumMap<E2, T> getValues(E1 E1) {
            return this.values.get(E1);
        }

        public T getValue(E1 E1, E2 E2) {
            return this.values.get(E1).get(E2);
        }

        public boolean isEqualValue(E1 E1, E2 E2, Object object) {
            T t = this.getValue(E1, E2);
            return t == null ? object == null : t.equals(object);
        }

        public void setValues(E1 E1, EnumMap<E2, T> enumMap) {
            for (Enum enum_ : (Enum[])this.map2KeyClass.getEnumConstants()) {
                this.setValue(E1, enum_, enumMap.get(enum_));
            }
        }

        public void setValues(E1 E1, List<T> list) {
            for (Enum enum_ : (Enum[])this.map2KeyClass.getEnumConstants()) {
                int n = enum_.ordinal();
                if (n >= list.size()) continue;
                this.setValue(E1, enum_, list.get(n));
            }
        }

        public void setValue(E1 E1, E2 E2, T t) {
            if (!this.isEqualValue(E1, E2, t)) {
                this.values.get(E1).put(E2, t);
                this.changed = true;
            }
        }

        protected void getEntry(Source[] sourceArray, E1 E1, E2 E2) throws AppException {
            Input input = Input.create(sourceArray, this.getKey(E1, E2));
            if (input != null) {
                this.parse(input, E1, E2);
            }
        }

        protected boolean putEntry(Target target, E1 E1, E2 E2) {
            target.putProperty(this.getKey(E1, E2), this.toString(E1, E2));
            return true;
        }

        protected String getKey(E1 E1, E2 E2) {
            return this.key + Property.KEY_SEPARATOR + ((StringKeyed)E1).getKey() + Property.KEY_SEPARATOR + ((StringKeyed)E2).getKey();
        }
    }

    public static abstract class PropertyListMap<E extends Enum<E>, T>
    extends Property {
        protected String listKey;
        protected Class<E> mapKeyClass;
        protected int maxNumValues;
        protected EnumMap<E, List<T>> values;

        public PropertyListMap(String string, String string2, Class<E> clazz, int n) {
            super(string);
            this.listKey = string2;
            this.mapKeyClass = clazz;
            this.maxNumValues = n;
            this.values = new EnumMap(clazz);
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                this.values.put(enum_, new ArrayList());
            }
        }

        protected abstract void parse(Input var1, E var2, int var3) throws AppException;

        protected abstract String toString(E var1, int var2);

        @Override
        public void get(Source[] sourceArray) throws AppException {
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                for (int i = 0; i < this.maxNumValues; ++i) {
                    this.getElement(sourceArray, enum_, i);
                }
            }
        }

        @Override
        public boolean put(Target target) {
            boolean bl = true;
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                List<T> list = this.values.get(enum_);
                for (int i = 0; i < list.size(); ++i) {
                    if (this.putElement(target, enum_, i)) continue;
                    bl = false;
                }
            }
            return bl;
        }

        public Collection<List<T>> getValues() {
            return this.values.values();
        }

        public List<T> getValues(E e) {
            return this.values.get(e);
        }

        public T getValue(E e, int n) {
            return this.values.get(e).get(n);
        }

        public boolean isEqualValue(E e, int n, Object object) {
            T t = this.getValue(e, n);
            return t == null ? object == null : t.equals(object);
        }

        public void setValues(List<List<T>> list) {
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                int n = enum_.ordinal();
                if (n >= list.size()) continue;
                this.setValues(enum_, list.get(n));
            }
        }

        public void setValues(E e, List<T> list) {
            List<T> list2 = this.values.get(e);
            for (int i = 0; i < list.size(); ++i) {
                T t = list.get(i);
                if (i < list2.size()) {
                    this.setValue(e, i, t);
                    continue;
                }
                list2.add(t);
                this.changed = true;
            }
            while (list2.size() > list.size()) {
                list2.remove(list2.size() - 1);
            }
        }

        public void setValue(E e, int n, T t) {
            if (!this.isEqualValue(e, n, t)) {
                this.values.get(e).set(n, t);
                this.changed = true;
            }
        }

        protected void getElement(Source[] sourceArray, E e, int n) throws AppException {
            Input input = Input.create(sourceArray, this.getKey(e, n));
            if (input != null) {
                this.parse(input, e, n);
            }
        }

        protected boolean putElement(Target target, E e, int n) {
            return target.putProperty(this.getKey(e, n), this.toString(e, n));
        }

        protected String getKey(E e, int n) {
            return this.key + Property.KEY_SEPARATOR + ((StringKeyed)e).getKey() + Property.KEY_SEPARATOR + this.listKey + Property.KEY_SEPARATOR + PropertyListMap.indexToKey(n);
        }
    }

    public static abstract class PropertyMap<E extends Enum<E>, T>
    extends Property {
        protected Class<E> mapKeyClass;
        protected EnumMap<E, T> values;

        public PropertyMap(String string, Class<E> clazz) {
            super(string);
            this.mapKeyClass = clazz;
            this.values = new EnumMap(clazz);
        }

        protected abstract void parse(Input var1, E var2) throws AppException;

        protected abstract String toString(E var1);

        @Override
        public void get(Source[] sourceArray) throws AppException {
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                this.getEntry(sourceArray, enum_);
            }
        }

        @Override
        public boolean put(Target target) {
            boolean bl = true;
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                if (this.putEntry(target, enum_)) continue;
                bl = false;
            }
            return bl;
        }

        public Collection<T> getValues() {
            return this.values.values();
        }

        public T getValue(E e) {
            return this.values.get(e);
        }

        public boolean isEqualValue(E e, Object object) {
            T t = this.getValue(e);
            return t == null ? object == null : t.equals(object);
        }

        public void setValues(EnumMap<E, T> enumMap) {
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                this.setValue(enum_, enumMap.get(enum_));
            }
        }

        public void setValues(List<T> list) {
            for (Enum enum_ : (Enum[])this.mapKeyClass.getEnumConstants()) {
                int n = enum_.ordinal();
                if (n >= list.size()) continue;
                this.setValue(enum_, list.get(n));
            }
        }

        public void setValue(E e, T t) {
            if (!this.isEqualValue(e, t)) {
                this.values.put(e, t);
                this.changed = true;
            }
        }

        protected void getEntry(Source[] sourceArray, E e) throws AppException {
            Input input = Input.create(sourceArray, this.getKey(e));
            if (input != null) {
                this.parse(input, e);
            }
        }

        protected boolean putEntry(Target target, E e) {
            return target.putProperty(this.getKey(e), this.toString(e));
        }

        protected String getKey(E e) {
            return this.key + Property.KEY_SEPARATOR + ((StringKeyed)e).getKey();
        }
    }

    public static abstract class PropertyList<T>
    extends Property {
        protected int maxNumValues;
        protected List<T> values;

        public PropertyList(String string) {
            super(string);
            this.maxNumValues = 1000;
            this.values = new ArrayList<T>();
        }

        public PropertyList(String string, int n) {
            super(string);
            this.maxNumValues = n;
            this.values = new ArrayList<T>();
        }

        protected abstract void parse(Input var1, int var2) throws AppException;

        protected abstract String toString(int var1);

        @Override
        public void get(Source[] sourceArray) throws AppException {
            for (int i = 0; i < this.maxNumValues; ++i) {
                this.getElement(sourceArray, i);
            }
        }

        @Override
        public boolean put(Target target) {
            boolean bl = true;
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.putElement(target, i)) continue;
                bl = false;
            }
            return bl;
        }

        public List<T> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public List<T> getNonNullValues() {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (T t : this.values) {
                if (t == null) continue;
                arrayList.add(t);
            }
            return arrayList;
        }

        public T getValue(int n) {
            return this.values.get(n);
        }

        public void clear() {
            this.values.clear();
        }

        public boolean isEqualValue(int n, Object object) {
            T t = this.getValue(n);
            return t == null ? object == null : t.equals(object);
        }

        public void setValues(List<T> list) {
            if (this.values.size() != list.size()) {
                this.changed = true;
            }
            for (int i = 0; i < list.size(); ++i) {
                T t = list.get(i);
                if (i < this.values.size()) {
                    this.setValue(i, t);
                    continue;
                }
                this.values.add(t);
                this.changed = true;
            }
            while (this.values.size() > list.size()) {
                this.values.remove(this.values.size() - 1);
            }
        }

        public void setValue(int n, T t) {
            if (!this.isEqualValue(n, t)) {
                this.values.set(n, t);
                this.changed = true;
            }
        }

        protected void getElement(Source[] sourceArray, int n) throws AppException {
            Input input = Input.create(sourceArray, this.getKey(n));
            if (input != null) {
                this.parse(input, n);
            }
        }

        protected boolean putElement(Target target, int n) {
            return target.putProperty(this.getKey(n), this.toString(n));
        }

        protected String getKey(int n) {
            return this.key + Property.KEY_SEPARATOR + PropertyList.indexToKey(n);
        }

        protected void nullFill() {
            this.values.clear();
            for (int i = 0; i < this.maxNumValues; ++i) {
                this.values.add(null);
            }
        }
    }

    public static abstract class ColourProperty
    extends SimpleProperty<Color> {
        public ColourProperty(String string) {
            super(string);
        }

        @Override
        public void parse(Input input) throws AppException {
            this.value = input.parseColour();
        }

        @Override
        public String toString() {
            return ColourUtilities.colourToRgbString((Color)this.value);
        }
    }

    public static abstract class DoubleProperty
    extends SimpleProperty<Double> {
        protected double lowerBound;
        protected double upperBound;
        protected NumberFormat format;

        public DoubleProperty(String string, double d, double d2) {
            super(string);
            this.lowerBound = d;
            this.upperBound = d2;
        }

        public DoubleProperty(String string, double d, double d2, NumberFormat numberFormat) {
            this(string, d, d2);
            this.format = numberFormat;
        }

        @Override
        public void parse(Input input) throws AppException {
            this.value = input.parseDouble(new DoubleRange(this.lowerBound, this.upperBound));
        }

        @Override
        public String toString() {
            return this.format == null ? ((Double)this.value).toString() : this.format.format((Double)this.value);
        }
    }

    public static abstract class IntegerProperty
    extends SimpleProperty<Integer> {
        protected int lowerBound;
        protected int upperBound;

        public IntegerProperty(String string, int n, int n2) {
            super(string);
            this.lowerBound = n;
            this.upperBound = n2;
        }

        @Override
        public void parse(Input input) throws AppException {
            this.value = input.parseInteger(new IntegerRange(this.lowerBound, this.upperBound));
        }

        @Override
        public String toString() {
            return ((Integer)this.value).toString();
        }
    }

    public static abstract class BooleanProperty
    extends SimpleProperty<Boolean> {
        public BooleanProperty(String string) {
            super(string);
        }

        @Override
        public void parse(Input input) throws AppException {
            this.value = input.parseBoolean();
        }

        @Override
        public String toString() {
            return NoYes.getKey((Boolean)this.value);
        }
    }

    public static abstract class StringProperty
    extends SimpleProperty<String> {
        public StringProperty(String string) {
            super(string);
        }

        @Override
        public void parse(Input input) {
            this.value = input.getValue();
        }

        @Override
        public String toString() {
            return (String)this.value;
        }
    }

    public static abstract class EnumProperty<E extends Enum<E>>
    extends SimpleProperty<E> {
        protected Class<E> cls;

        public EnumProperty(String string, Class<E> clazz) {
            super(string);
            this.cls = clazz;
        }

        @Override
        public void parse(Input input) throws AppException {
            for (Enum enum_ : (Enum[])this.cls.getEnumConstants()) {
                if (!((StringKeyed)((Object)enum_)).getKey().equals(input.value)) continue;
                this.value = enum_;
                return;
            }
            throw new IllegalValueException(input);
        }

        @Override
        public String toString() {
            return ((StringKeyed)((Object)((Enum)this.value))).getKey();
        }
    }

    public static abstract class SimpleProperty<T>
    extends Property {
        protected T value;

        public SimpleProperty(String string) {
            super(string);
        }

        public abstract void parse(Input var1) throws AppException;

        public abstract String toString();

        @Override
        public void get(Source[] sourceArray) throws AppException {
            Input input = Input.create(sourceArray, this.key);
            if (input != null) {
                this.parse(input);
            }
        }

        @Override
        public boolean put(Target target) {
            return target.putProperty(this.key, this.toString());
        }

        public T getValue() {
            return this.value;
        }

        public boolean isEqualValue(Object object) {
            return this.value == null ? object == null : this.value.equals(object);
        }

        public void setValue(T t) {
            if (!this.isEqualValue(t)) {
                this.value = t;
                this.changed = true;
            }
        }
    }

    public static interface Set {
        public static final String FIELD_PREFIX = "cs";

        public void getProperties(Source ... var1);

        public void putProperties(Target var1);

        public boolean isChanged();

        public void resetChanged();
    }

    public static interface Target {
        public boolean putProperty(String var1, String var2);
    }

    public static interface Source {
        public String getSourceName();

        public String getProperty(String var1);
    }

    public static enum ErrorId implements AppException.Id
    {
        ILLEGAL_KEY("The key is illegal."),
        ILLEGAL_VALUE("The value is illegal."),
        VALUE_OUT_OF_BOUNDS("The value is out of bounds."),
        VALUES_OUT_OF_ORDER("The component values are out of order."),
        LIST_INDEX_OUT_OF_BOUNDS("The list index is out of bounds."),
        LIST_INDEX_OUT_OF_ORDER("The list index is out of order.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static enum Order {
        LESS_THAN,
        LESS_THAN_OR_EQUAL_TO,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL_TO;

    }
}

