/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

public class IntegerRange
implements Cloneable {
    public int lowerLimit;
    public int upperLimit;

    public IntegerRange() {
    }

    public IntegerRange(int n, int n2) {
        this.lowerLimit = n;
        this.upperLimit = n2;
    }

    public IntegerRange(IntegerRange integerRange) {
        this.lowerLimit = integerRange.lowerLimit;
        this.upperLimit = integerRange.upperLimit;
    }

    public IntegerRange(String string) throws IllegalArgumentException, NumberFormatException {
        String[] stringArray = string.split(" *, *", -1);
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        this.lowerLimit = Integer.parseInt(stringArray[0]);
        this.upperLimit = Integer.parseInt(stringArray[1]);
    }

    public IntegerRange clone() {
        try {
            return (IntegerRange)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)object;
            return this.lowerLimit == integerRange.lowerLimit && this.upperLimit == integerRange.upperLimit;
        }
        return false;
    }

    public int hashCode() {
        int n = this.lowerLimit + this.upperLimit;
        return n * (n + 1) / 2 + this.lowerLimit;
    }

    public String toString() {
        return new String(this.lowerLimit + ", " + this.upperLimit);
    }

    public int getInterval() {
        return this.upperLimit - this.lowerLimit + 1;
    }

    public int getValue(double d) {
        return this.lowerLimit + (int)Math.round((double)(this.upperLimit - this.lowerLimit) * d);
    }

    public boolean contains(int n) {
        return n >= this.lowerLimit && n <= this.upperLimit;
    }

    public int nearestValueWithin(int n) {
        return Math.min(Math.max(this.lowerLimit, n), this.upperLimit);
    }
}

