/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileAttributeUtilities {
    private static final int MAX_PERMISSIONS_VALUE = 511;
    private static final String[] SET_ARGUMENTS = new String[]{"", "--quiet"};
    private static final String[] COPY_ARGUMENTS = new String[]{"", "--quiet", "--reference"};

    private FileAttributeUtilities() {
    }

    public static void setAttributes(File file, int n, String string, String string2) throws AttributesException, IllegalArgumentException {
        if (n > 511) {
            throw new IllegalArgumentException();
        }
        try {
            if (!file.exists()) {
                throw new AttributesException((AppException.Id)ErrorId.FILE_OR_DIRECTORY_DOES_NOT_EXIST, file);
            }
        }
        catch (SecurityException securityException) {
            throw new AttributesException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, SET_ARGUMENTS);
        int n2 = arrayList.size();
        arrayList.add("");
        arrayList.add(FileAttributeUtilities.getPathname(file));
        try {
            if (n >= 0) {
                char[] cArray = new char[3];
                int n3 = 7;
                for (int i = cArray.length - 1; i >= 0; --i) {
                    cArray[i] = (char)(48 + (n & n3));
                    n >>>= 3;
                }
                arrayList.set(n2, new String(cArray));
                FileAttributeUtilities.execProcess(arrayList, "permissions", "chmod");
            }
            if (string.isEmpty()) {
                if (!string2.isEmpty()) {
                    arrayList.set(n2, string2);
                    FileAttributeUtilities.execProcess(arrayList, "group", "chgrp");
                }
            } else {
                arrayList.set(n2, string2.isEmpty() ? string : string + ":" + string2);
                FileAttributeUtilities.execProcess(arrayList, "owner", "chown");
            }
        }
        catch (AppException appException) {
            throw new AttributesException(appException, file);
        }
    }

    public static void copyAttributes(File file, File file2) throws AttributesException {
        try {
            if (!file.exists()) {
                throw new AttributesException((AppException.Id)ErrorId.SOURCE_FILE_DOES_NOT_EXIST, file);
            }
            if (!file.isFile()) {
                throw new AttributesException((AppException.Id)ErrorId.NOT_A_FILE, file);
            }
        }
        catch (SecurityException securityException) {
            throw new AttributesException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file);
        }
        try {
            if (!file2.exists()) {
                throw new AttributesException((AppException.Id)ErrorId.DESTINATION_FILE_DOES_NOT_EXIST, file2);
            }
            if (!file2.isFile()) {
                throw new AttributesException((AppException.Id)ErrorId.NOT_A_FILE, file2);
            }
        }
        catch (SecurityException securityException) {
            throw new AttributesException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, COPY_ARGUMENTS);
        arrayList.add(FileAttributeUtilities.getPathname(file));
        arrayList.add(FileAttributeUtilities.getPathname(file2));
        try {
            FileAttributeUtilities.execProcess(arrayList, "permissions", "chmod");
            FileAttributeUtilities.execProcess(arrayList, "owner", "chown");
        }
        catch (AppException appException) {
            throw new AttributesException(appException, file);
        }
    }

    private static String getPathname(File file) {
        String string = null;
        try {
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                FileAttributeUtilities.writeError(exception);
                string = file.getAbsolutePath();
            }
        }
        catch (SecurityException securityException) {
            FileAttributeUtilities.writeError(securityException);
            string = file.getPath();
        }
        return string;
    }

    private static void writeError(Exception exception) {
        System.err.println(exception);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            System.err.println(stackTraceElementArray[0]);
        }
    }

    private static void execProcess(List<String> list, String string, String string2) throws AppException {
        Object object;
        Process process = null;
        try {
            list.set(0, string2);
            object = new ProcessBuilder(list);
            ((ProcessBuilder)object).redirectErrorStream(true);
            process = ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            throw new AppException((AppException.Id)ErrorId.FAILED_TO_EXECUTE_COMMAND, (Throwable)iOException, string2);
        }
        object = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            while (true) {
                try {
                    while (((BufferedReader)object).ready()) {
                        System.out.println(((BufferedReader)object).readLine());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Thread.yield();
                try {
                    int n = process.exitValue();
                    if (n != 0) {
                        throw new AppException((AppException.Id)ErrorId.FAILED_TO_SET_ATTRIBUTE, string);
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    continue;
                }
                break;
            }
        }
        catch (AppException appException) {
            throw appException;
        }
        finally {
            try {
                while (((BufferedReader)object).ready()) {
                    System.out.println(((BufferedReader)object).readLine());
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static class AttributesException
    extends FileException {
        private AttributesException(AppException.Id id, File file) {
            super(id, file);
        }

        private AttributesException(AppException appException, File file) {
            super(appException, file);
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        FILE_OR_DIRECTORY_DOES_NOT_EXIST("The file or directory does not exist."),
        SOURCE_FILE_DOES_NOT_EXIST("The source file does not exist."),
        DESTINATION_FILE_DOES_NOT_EXIST("The destination file does not exist."),
        NOT_A_FILE("The pathname does not specify a file."),
        FILE_ACCESS_NOT_PERMITTED("Access to the file was not permitted."),
        FAILED_TO_EXECUTE_COMMAND("Failed to execute the command %1."),
        FAILED_TO_SET_ATTRIBUTE("Failed to set the file %1.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface AttrCommand {
        public static final String GROUP = "chgrp";
        public static final String OWNER = "chown";
        public static final String PERMISSIONS = "chmod";
    }

    private static interface AttrName {
        public static final String GROUP = "group";
        public static final String OWNER = "owner";
        public static final String PERMISSIONS = "permissions";
    }
}

