/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class DataImporter {
    private static final String FILE_SCHEME_STR = "file";
    private static final String URI_LIST_MIME_TYPE_STR = "text/uri-list;class=java.lang.String";
    private static final DataFlavor URI_LIST_FLAVOUR = DataImporter.getUriListFlavour();

    private DataImporter() {
    }

    public static boolean isString(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileList(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.isFlavorJavaFileListType() && !dataFlavor.equals(URI_LIST_FLAVOUR)) continue;
            return true;
        }
        return false;
    }

    public static File[] getFiles(Transferable transferable) throws IOException, UnsupportedFlavorException {
        return DataImporter.getFiles(transferable, false);
    }

    public static File[] getFiles(Transferable transferable, boolean bl) throws IOException, UnsupportedFlavorException {
        ArrayList<File> arrayList;
        block5: {
            String[] stringArray;
            block6: {
                arrayList = new ArrayList<File>();
                if (!DataImporter.isFileList(transferable.getTransferDataFlavors())) break block5;
                if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) break block6;
                Object object = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (!(object instanceof List)) break block5;
                for (Object e : (List)object) {
                    if (!(e instanceof File)) continue;
                    arrayList.add((File)e);
                }
                break block5;
            }
            for (String string : stringArray = ((String)transferable.getTransferData(URI_LIST_FLAVOUR)).split("[\\r\\n]+")) {
                try {
                    URI uRI = new URI(string);
                    if (FILE_SCHEME_STR.equals(uRI.getScheme())) {
                        arrayList.add(new File(uRI));
                        continue;
                    }
                    if (!bl) continue;
                    arrayList.add(new File(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    System.err.println(uRISyntaxException);
                }
            }
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new File[arrayList.size()]);
    }

    private static DataFlavor getUriListFlavour() {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(URI_LIST_MIME_TYPE_STR);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return dataFlavor;
    }
}

