/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import functionplotter.util.Numeric;
import java.awt.Color;

public class ColourUtilities {
    public static final int MIN_RGB_COMPONENT_VALUE = 0;
    public static final int MAX_RGB_COMPONENT_VALUE = 255;
    public static final String HEX_FORM_PREFIX = "#";

    private ColourUtilities() {
    }

    public static String colourToRgbString(Color color) {
        return new String(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
    }

    public static String colourToHexString(Color color) {
        Numeric.setHexUpper();
        return new String(HEX_FORM_PREFIX + Numeric.byteToHexString(color.getRed()) + Numeric.byteToHexString(color.getGreen()) + Numeric.byteToHexString(color.getBlue()));
    }

    public static Color parseColour(String string) throws IllegalArgumentException, IndexOutOfBoundsException {
        Color color = null;
        if (string.startsWith(HEX_FORM_PREFIX)) {
            int n;
            int n2;
            if ((string = string.substring(1)).length() == 3) {
                char[] cArray = new char[6];
                for (n2 = 0; n2 < 3; ++n2) {
                    cArray[2 * n2] = n = string.charAt(n2);
                    cArray[2 * n2 + 1] = n;
                }
                string = new String(cArray);
            } else if (string.length() != 6) {
                throw new IllegalArgumentException();
            }
            int n3 = Integer.parseInt(string.substring(0, 2), 16);
            n2 = Integer.parseInt(string.substring(2, 4), 16);
            n = Integer.parseInt(string.substring(4, 6), 16);
            color = new Color(n3, n2, n);
        } else {
            String[] stringArray = string.split(" *, *", -1);
            if (stringArray.length != 3) {
                throw new IllegalArgumentException();
            }
            int n = Integer.parseInt(stringArray[0]);
            if (n < 0 || n > 255) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = Integer.parseInt(stringArray[1]);
            if (n4 < 0 || n4 > 255) {
                throw new IndexOutOfBoundsException();
            }
            int n5 = Integer.parseInt(stringArray[2]);
            if (n5 < 0 || n5 > 255) {
                throw new IndexOutOfBoundsException();
            }
            color = new Color(n, n4, n5);
        }
        return color;
    }
}

