/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.textfield;

import java.awt.Color;
import javax.swing.JTextField;

public abstract class AbstractTextField
extends JTextField {
    private static final Color DEFAULT_INVALID_BACKGROUND_COLOUR = new Color(240, 192, 192);
    private boolean invalid;
    private Color disabledBackgroundColour;
    private Color invalidBackgroundColour = DEFAULT_INVALID_BACKGROUND_COLOUR;

    protected AbstractTextField() {
    }

    protected AbstractTextField(int n) {
        super(n);
    }

    @Override
    public Color getBackground() {
        return this.invalid ? this.invalidBackgroundColour : (this.isEnabled() || this.disabledBackgroundColour == null ? super.getBackground() : this.disabledBackgroundColour);
    }

    @Override
    public void setText(String string) {
        this.invalid = false;
        super.setText(string);
    }

    public boolean isEmpty() {
        try {
            return this.getText().isEmpty();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public Color setDisabledBackgroundColour() {
        return this.disabledBackgroundColour;
    }

    public Color getInvalidBackgroundColour() {
        return this.invalidBackgroundColour;
    }

    public void setInvalid(boolean bl) {
        if (this.invalid != bl) {
            this.invalid = bl;
            this.repaint();
        }
    }

    public void setDisabledBackgroundColour(Color color) {
        if (this.disabledBackgroundColour == null && color != null || this.disabledBackgroundColour != null && !this.disabledBackgroundColour.equals(color)) {
            this.disabledBackgroundColour = color;
            this.repaint();
        }
    }

    public void setInvalidBackgroundColour(Color color) {
        if (!this.invalidBackgroundColour.equals(color)) {
            this.invalidBackgroundColour = color;
            this.repaint();
        }
    }
}

