/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.ArrowButton;
import functionplotter.gui.Colours;
import functionplotter.gui.FMenuItem;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.SelectionIndicatorList;
import functionplotter.gui.TextRendering;
import functionplotter.util.KeyAction;
import functionplotter.util.TextUtilities;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPanel
extends JComponent
implements ActionListener,
ComponentListener,
PropertyChangeListener {
    private static final int SCROLL_INTERVAL = 400;
    private static final int BORDER_TOP = 1;
    private static final int BORDER_BOTTOM = 1;
    private static final int BORDER_LEFT = 1;
    private static final int BORDER_RIGHT = 1;
    private static final int TOP_MARGIN = 1;
    private static final int HEADER_BUTTON_TOP_MARGIN = 1;
    private static final int HEADER_BUTTON_BOTTOM_MARGIN = 1;
    private static final int SCROLL_BUTTON_LEADING_MARGIN = 2;
    private static final int SCROLL_BUTTON_TRAILING_MARGIN = 2;
    private static final int LIST_BUTTON_TRAILING_MARGIN = 2;
    private static final int ARROW_SIZE = 5;
    private static final int SCROLL_BUTTON_WIDTH = 15;
    private static final int LIST_BUTTON_WIDTH = 17;
    private static final int HEADER_BUTTON_HEIGHT = 15;
    private static final int MIN_HEADER_WIDTH = 53;
    private static final Color TAB_BACKGROUND_COLOUR = new Color(208, 208, 200);
    private static final Color TAB_BORDER_COLOUR = Colours.LINE_BORDER;
    private static final Color SELECTED_TAB_BACKGROUND_COLOUR = new Color(244, 208, 128);
    private static final Color SELECTED_TAB_BORDER_COLOUR = new Color(224, 144, 88);
    private static final Color TEXT_COLOUR = Colours.FOREGROUND;
    private static final Color BORDER_COLOUR = Colours.LINE_BORDER;
    private static final Color BUTTON_BORDER_COLOUR = new Color(128, 128, 160);
    private static final Color BUTTON_BACKGROUND_COLOUR = new Color(248, 224, 144);
    private static final byte[] CROSS_ICON_DATA = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 8, 0, 0, 0, 7, 8, 6, 0, 0, 0, 53, 89, 12, 94, 0, 0, 0, 42, 73, 68, 65, 84, 120, -38, 99, 96, 96, 96, -8, 15, -62, 64, -64, -128, -116, 97, -30, 40, 28, 116, 73, 48, 27, 67, 7, -70, 98, 108, -58, -94, -120, 17, 101, 2, 94, 55, 16, -14, 5, 0, 43, -105, 115, -115, 59, -54, -51, 13, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final byte[] ACTIVE_CROSS_ICON_DATA = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 8, 0, 0, 0, 7, 8, 6, 0, 0, 0, 53, 89, 12, 94, 0, 0, 0, 43, 73, 68, 65, 84, 120, -38, 99, -8, -1, -94, -31, 63, 24, -1, -1, -49, -128, -126, -95, -30, 40, 28, 116, 73, 16, 27, 67, 7, -70, 98, -84, -58, 34, -117, 17, 105, 2, 94, 55, 16, -16, 5, 0, -121, -103, -78, 3, 30, 53, -67, 92, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final byte[] CORNER_L_ICON_DATA = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 4, 0, 0, 0, 4, 8, 6, 0, 0, 0, -87, -15, -98, 126, 0, 0, 0, 56, 73, 68, 65, 84, 120, -38, 99, -40, -79, 99, 7, -61, -52, -103, 51, 89, 23, 47, 94, 92, -65, 104, -47, -94, -5, 48, -50, -123, 53, 107, 86, 127, 61, 118, 108, -1, 127, 6, -112, 12, -120, 115, -31, -62, -119, -1, 32, -52, 0, 82, 6, -110, -127, 9, 0, 0, 117, -21, 44, -4, 22, 75, 14, -72, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final byte[] CORNER_R_ICON_DATA = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 4, 0, 0, 0, 4, 8, 6, 0, 0, 0, -87, -15, -98, 126, 0, 0, 0, 57, 73, 68, 65, 84, 120, -38, 99, 88, -76, 104, -47, -3, -59, -117, 23, -41, -49, -100, 57, -109, 117, -57, -114, 29, 12, 12, -57, -114, -19, -1, -65, 102, -51, -22, -81, 64, -63, 11, 32, 65, -122, 11, 23, 78, -4, 7, 97, -88, 96, 61, 92, 0, -92, 18, -92, 29, 0, -88, 23, 44, -4, 23, 52, 66, -85, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final byte[] CORNER_LS_ICON_DATA = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 4, 0, 0, 0, 4, 8, 6, 0, 0, 0, -87, -15, -98, 126, 0, 0, 0, 58, 73, 68, 65, 84, 120, -38, 99, -40, -79, 99, 7, -61, -103, -103, 105, -84, 15, 39, 71, -43, 63, -100, 18, 117, 31, -52, 121, 52, 37, -6, -62, -45, 5, 73, 95, 63, 28, 42, -1, -49, 0, -110, 1, 113, -66, 92, 104, -8, 15, -62, 12, 32, 101, 32, 25, -104, 0, 0, 83, -123, 43, 116, -17, 79, -115, 96, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final byte[] CORNER_RS_ICON_DATA = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 4, 0, 0, 0, 4, 8, 6, 0, 0, 0, -87, -15, -98, 126, 0, 0, 0, 59, 73, 68, 65, 84, 120, -38, 99, 120, 56, 37, -22, -2, -61, -55, 81, -11, 103, 102, -90, -79, -18, -40, -79, -125, -127, -31, -61, -95, -14, -1, 79, 23, 36, 125, 125, 52, 37, -6, 2, 72, -112, -31, -53, -123, -122, -1, 32, 12, 18, 4, -87, -124, 11, -128, 84, -126, -76, 3, 0, -127, 89, 43, 116, -110, -72, 31, 18, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    private static final ImageIcon CROSS_ICON = new ImageIcon(CROSS_ICON_DATA);
    private static final ImageIcon ACTIVE_CROSS_ICON = new ImageIcon(ACTIVE_CROSS_ICON_DATA);
    private static final ImageIcon CORNER_L_ICON = new ImageIcon(CORNER_L_ICON_DATA);
    private static final ImageIcon CORNER_R_ICON = new ImageIcon(CORNER_R_ICON_DATA);
    private static final ImageIcon CORNER_LS_ICON = new ImageIcon(CORNER_LS_ICON_DATA);
    private static final ImageIcon CORNER_RS_ICON = new ImageIcon(CORNER_RS_ICON_DATA);
    private static final KeyAction.CommandMap[] KEY_COMMANDS = new KeyAction.CommandMap[]{new KeyAction.CommandMap(KeyStroke.getKeyStroke(9, 128), "selectNextTab"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(9, 192), "selectPreviousTab")};
    private ScrollButton previousTabButton;
    private ScrollButton nextTabButton;
    private ListButton listButton;
    private List<Element> elements = new ArrayList<Element>();
    private List<Element> recentElements = new ArrayList<Element>();
    private int startIndex;
    private int selectedIndex = -1;
    private int numViewableTabs;
    private int headerHeight;
    private boolean ignoreCase;
    private ElementComparator elementComparator = new ElementComparator();
    private Timer scrollTimer = new Timer(400, this);
    private ScrollDirection scrollDirection;
    private KeySelectionListWindow keySelectionListWindow;
    private MouseSelectionListWindow mouseSelectionListWindow;
    private List<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private JPopupMenu popUpMenu;

    public TabbedPanel() {
        this.scrollTimer.setActionCommand("scroll");
        this.changeListeners = new ArrayList<ChangeListener>();
        this.headerHeight = Math.max(17, this.createTab((String)new String(), null).getPreferredSize().height);
        this.setLayout(null);
        this.setOpaque(true);
        this.setFocusable(false);
        this.previousTabButton = new ScrollButton(ScrollDirection.BACKWARD);
        this.nextTabButton = new ScrollButton(ScrollDirection.FORWARD);
        this.listButton = new ListButton();
        this.updateButtons();
        this.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke(9, 0)));
        this.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke(9, 64)));
        this.addComponentListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        KeyAction.create((JComponent)this, 1, KEY_COMMANDS, (ActionListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("scroll")) {
            this.doScroll();
        } else if (string.equals("selectPreviousTab")) {
            this.doSelectPreviousTab();
        } else if (string.equals("selectNextTab")) {
            this.doSelectNextTab();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (!this.elements.isEmpty()) {
            this.updateStartIndex(true);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Component component = (Component)propertyChangeEvent.getNewValue();
        if (this.isAncestorOf(component)) {
            for (Element element : this.elements) {
                if (!SwingUtilities.isDescendingFrom(component, element.component)) continue;
                element.focusOwner = component;
                break;
            }
        } else {
            this.destroyKeySelectionList();
            this.destroyMouseSelectionList();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        int n = 0;
        int n2 = 0;
        for (Element element : this.elements) {
            Dimension dimension = element.component.getMinimumSize();
            if (n < dimension.width) {
                n = dimension.width;
            }
            if (n2 >= dimension.height) continue;
            n2 = dimension.height;
        }
        return new Dimension(1 + Math.max(53, n) + 1, 2 + this.headerHeight + n2 + 1);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int n = 0;
        int n2 = 0;
        for (Element element : this.elements) {
            Dimension dimension = element.component.getPreferredSize();
            if (n < dimension.width) {
                n = dimension.width;
            }
            if (n2 >= dimension.height) continue;
            n2 = dimension.height;
        }
        return new Dimension(1 + n + 1, 2 + this.headerHeight + n2 + 1);
    }

    @Override
    public void doLayout() {
        Component component = null;
        if (this.elements.isEmpty()) {
            component = this.getWindow();
        } else {
            int n;
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n2 = this.getWidth();
            int n3 = this.getMaxTotalTabWidth();
            int n4 = 1;
            for (n = 0; n < this.getComponentCount(); ++n) {
                Component component2 = this.getComponent(n);
                if (!(component2 instanceof Tab)) continue;
                int n5 = component2.getPreferredSize().height;
                int n6 = Math.min(component2.getPreferredSize().width, n3 - n4);
                component2.setBounds(bl ? n4 : n2 - n4 - n6, 2 + this.headerHeight - n5, n6, n5);
                n4 += n6;
            }
            n4 = n2 - 1 - 30 - 2 - 17 - 2;
            n = 1 + (1 + this.headerHeight - 15) / 2;
            int n7 = 15;
            this.previousTabButton.setBounds(bl ? n4 : n2 - n4 - n7, n, n7, 15);
            this.nextTabButton.setBounds(bl ? n4 : n2 - (n4 += 15) - n7, n, n7, 15);
            n7 = 17;
            this.listButton.setBounds(bl ? n4 : n2 - (n4 += 17) - n7, n, n7, 15);
            n4 = 1;
            n = 2 + this.headerHeight;
            Element element = this.elements.get(this.selectedIndex);
            Dimension dimension = element.component.getMinimumSize();
            Dimension dimension2 = element.component.getMaximumSize();
            int n8 = Math.min(Math.max(dimension.width, n2 - n4 - 1), dimension2.width);
            int n9 = Math.min(Math.max(dimension.height, this.getHeight() - n - 1), dimension2.height);
            element.component.setBounds(n4, n, n8, n9);
            component = element.focusOwner;
        }
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(BORDER_COLOUR);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (!this.elements.isEmpty()) {
            graphics.setColor(SELECTED_TAB_BORDER_COLOUR);
            int n = 2 + this.headerHeight - 1;
            graphics.drawLine(1, n, this.getWidth() - 1 - 1, n);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (this.keySelectionListWindow != null && keyEvent.getKeyCode() == 17 && !bl) {
            this.keySelectionListWindow.doSelection();
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public int getNumTabs() {
        return this.elements.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Component getSelectedComponent() {
        return this.selectedIndex < 0 ? null : this.elements.get(this.selectedIndex).component;
    }

    public Dimension getFrameSize() {
        return new Dimension(2, 2 + this.headerHeight + 1);
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setTitle(int n, String string) {
        this.elements.get(n).tab.setTitle(string);
    }

    public void setToolTipText(int n, String string) {
        this.elements.get(n).tab.setToolTipText(string);
    }

    public void setComponent(int n, Component component) {
        this.elements.get(n).component = component;
        if (n == this.selectedIndex) {
            this.updateComponents();
        }
    }

    public void addComponent(String string, Action action, Component component) {
        this.destroyKeySelectionList();
        this.destroyMouseSelectionList();
        this.elements.add(new Element(this.createTab(string, action), component));
        int n = this.elements.size() - 1;
        this.recentElements.add(0, this.elements.get(n));
        this.setSelectedIndex(n);
        component.requestFocusInWindow();
    }

    public void removeComponent(int n) throws IndexOutOfBoundsException {
        int n2;
        if (n < 0 || n >= this.elements.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.destroyKeySelectionList();
        this.destroyMouseSelectionList();
        this.recentElements.remove(this.elements.get(n));
        this.elements.remove(n);
        if (this.selectedIndex < this.elements.size()) {
            n2 = this.selectedIndex;
            this.selectedIndex = -1;
            this.setSelectedIndex(n2);
        } else if (this.selectedIndex > 0) {
            this.setSelectedIndex(this.selectedIndex - 1);
        } else {
            this.selectedIndex = -1;
            this.fireStateChanged();
        }
        n2 = this.getMaximumStartIndex();
        if (this.startIndex > n2) {
            this.startIndex = n2;
        }
        this.updateButtons();
        this.updateComponents();
    }

    public void setSelectedIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.elements.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.selectedIndex != n) {
            int n2;
            this.selectedIndex = n;
            for (n2 = 0; n2 < this.elements.size(); ++n2) {
                this.elements.get(n2).tab.setSelected(n2 == this.selectedIndex);
            }
            n2 = this.recentElements.indexOf(this.elements.get(this.selectedIndex));
            if (n2 > 0) {
                this.recentElements.add(0, this.recentElements.remove(n2));
            }
            this.updateComponents();
            this.updateStartIndex(false);
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    protected void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    private Window getWindow() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private int getMaxTotalTabWidth() {
        return Math.max(0, this.getWidth() - 55);
    }

    private int getMaximumStartIndex() {
        Tab tab;
        int n = this.getMaxTotalTabWidth();
        int n2 = 0;
        int n3 = this.elements.size();
        while (--n3 >= 0 && n2 + Math.min((tab = this.elements.get(n3).tab).getPreferredWidth(), n) <= n) {
            n2 += tab.getPreferredWidth();
        }
        return Math.max(0, Math.min(++n3, this.elements.size() - 1));
    }

    private void updateStartIndex(boolean bl) {
        int n = this.startIndex;
        if (bl || this.selectedIndex >= this.startIndex + this.numViewableTabs - 1) {
            Tab tab;
            this.startIndex = this.selectedIndex;
            int n2 = 0;
            int n3 = this.getMaxTotalTabWidth();
            while (this.startIndex >= 0 && n2 + Math.min((tab = this.elements.get(this.startIndex).tab).getPreferredWidth(), n3) <= n3) {
                n2 += tab.getPreferredWidth();
                --this.startIndex;
            }
            ++this.startIndex;
        }
        if (this.startIndex > this.selectedIndex) {
            this.startIndex = this.selectedIndex;
        }
        if (this.startIndex != n) {
            this.updateTabs();
            this.updateButtons();
        }
    }

    private void updateTabs() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof Tab)) continue;
            this.remove(i--);
            --this.numViewableTabs;
        }
        this.addTabs();
        this.revalidate();
        this.repaint(0, 2, this.getWidth(), this.headerHeight);
    }

    private void updateButtons() {
        this.previousTabButton.setEnabled(this.startIndex > 0);
        this.nextTabButton.setEnabled(this.startIndex < this.getMaximumStartIndex());
    }

    private void updateComponents() {
        this.removeAll();
        this.numViewableTabs = 0;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        this.previousTabButton.setDirection(bl);
        this.nextTabButton.setDirection(bl);
        if (!this.elements.isEmpty()) {
            this.addTabs();
            this.add(this.previousTabButton);
            this.add(this.nextTabButton);
            this.add(this.listButton);
            this.add(this.elements.get(this.selectedIndex).component);
        }
        this.revalidate();
        this.repaint();
    }

    private void addTabs() {
        int n = this.getMaxTotalTabWidth();
        int n2 = 0;
        for (int i = this.startIndex; i < this.elements.size(); ++i) {
            Tab tab = this.elements.get(i).tab;
            if (n2 + 6 > n) break;
            this.add((Component)tab, i - this.startIndex);
            ++this.numViewableTabs;
            n2 += tab.getPreferredWidth();
        }
    }

    private void showTab(int n) {
        if (n == this.selectedIndex) {
            this.updateStartIndex(false);
        } else {
            this.setSelectedIndex(n);
        }
    }

    private void selectTab(Element element) {
        int n;
        if (element != null && (n = this.elements.indexOf(element)) >= 0) {
            this.showTab(n);
        }
    }

    private Tab createTab(String string, Action action) {
        Tab tab = new Tab(string, action);
        tab.applyComponentOrientation(this.getComponentOrientation());
        return tab;
    }

    private void createKeySelectionList(boolean bl) {
        if (this.elements.size() > 1) {
            this.keySelectionListWindow = new KeySelectionListWindow(this.getWindow(), bl);
        }
    }

    private void destroyKeySelectionList() {
        if (this.keySelectionListWindow != null) {
            this.keySelectionListWindow.setVisible(false);
            this.keySelectionListWindow.dispose();
            this.keySelectionListWindow = null;
        }
    }

    private void createMouseSelectionList() {
        this.mouseSelectionListWindow = new MouseSelectionListWindow(this.getWindow());
    }

    private void destroyMouseSelectionList() {
        if (this.mouseSelectionListWindow != null) {
            this.mouseSelectionListWindow.getToolkit().removeAWTEventListener(this.mouseSelectionListWindow);
            this.mouseSelectionListWindow.setVisible(false);
            this.mouseSelectionListWindow.dispose();
            this.mouseSelectionListWindow = null;
        }
    }

    private void startScrolling(ScrollDirection scrollDirection) {
        this.scrollDirection = scrollDirection;
        this.scrollTimer.start();
        this.doScroll();
    }

    private void stopScrolling() {
        this.scrollTimer.stop();
        this.scrollDirection = null;
    }

    private void doScroll() {
        switch (this.scrollDirection) {
            case BACKWARD: {
                if (this.startIndex <= 0) break;
                if (--this.startIndex == 0) {
                    this.stopScrolling();
                }
                this.updateTabs();
                this.updateButtons();
                break;
            }
            case FORWARD: {
                int n = this.getMaximumStartIndex();
                if (this.startIndex >= n) break;
                if (++this.startIndex == n) {
                    this.stopScrolling();
                }
                this.updateTabs();
                this.updateButtons();
                break;
            }
        }
    }

    private void doSelectPreviousTab() {
        if (this.keySelectionListWindow == null) {
            this.createKeySelectionList(true);
        } else {
            this.keySelectionListWindow.decrementSelection();
        }
    }

    private void doSelectNextTab() {
        if (this.keySelectionListWindow == null) {
            this.createKeySelectionList(false);
        } else {
            this.keySelectionListWindow.incrementSelection();
        }
    }

    private class ElementComparator
    implements Comparator<Element> {
        private ElementComparator() {
        }

        @Override
        public int compare(Element element, Element element2) {
            return TabbedPanel.this.ignoreCase ? element.toString().compareToIgnoreCase(element2.toString()) : element.toString().compareTo(element2.toString());
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ElementComparator;
        }
    }

    private class MouseSelectionListWindow
    extends JWindow
    implements AWTEventListener,
    MouseListener,
    MouseMotionListener {
        private SelectionIndicatorList<Element> list;

        private MouseSelectionListWindow(Window window) {
            super(window);
            this.setFocusableWindowState(false);
            ArrayList arrayList = new ArrayList(TabbedPanel.this.elements);
            Collections.sort(arrayList, TabbedPanel.this.elementComparator);
            this.list = new SelectionIndicatorList<Object>((List<Object>)arrayList, (TabbedPanel.this.selectedIndex < 0 ? null : (Element)TabbedPanel.this.elements.get(TabbedPanel.this.selectedIndex)));
            this.getToolkit().addAWTEventListener(this, 16L);
            this.list.addMouseListener(this);
            this.list.addMouseMotionListener(this);
            this.setContentPane(this.list);
            this.applyComponentOrientation(window.getComponentOrientation());
            this.pack();
            int n = this.getComponentOrientation().isLeftToRight() ? TabbedPanel.this.listButton.getWidth() - this.list.getPreferredSize().width : 0;
            Point point = new Point(n, TabbedPanel.this.listButton.getHeight());
            SwingUtilities.convertPointToScreen(point, TabbedPanel.this.listButton);
            this.setLocation(GuiUtilities.getComponentLocation(this.list, point));
            this.setVisible(true);
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 501) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getComponent() != this.list) {
                    TabbedPanel.this.destroyMouseSelectionList();
                }
                if (mouseEvent.getComponent() == TabbedPanel.this.listButton) {
                    mouseEvent.consume();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateSelection(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateSelection(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updateSelection(mouseEvent);
            this.doSelection();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.updateSelection(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateSelection(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateSelection(mouseEvent);
        }

        private void updateSelection(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.list);
            this.list.setSelectedIndex(this.list.pointToIndex(point));
        }

        private void doSelection() {
            TabbedPanel.this.destroyMouseSelectionList();
            TabbedPanel.this.selectTab(this.list.getSelectedItem());
        }
    }

    private class KeySelectionListWindow
    extends JWindow {
        private SelectionIndicatorList<Element> list;

        private KeySelectionListWindow(Window window, boolean bl) {
            super(window);
            this.setFocusableWindowState(false);
            this.list = new SelectionIndicatorList(TabbedPanel.this.recentElements, -1);
            this.list.setSelectedIndex(bl ? TabbedPanel.this.recentElements.size() - 1 : 1);
            this.setContentPane(this.list);
            this.applyComponentOrientation(window.getComponentOrientation());
            this.pack();
            this.setLocation(GuiUtilities.getComponentLocation(this.list, window));
            this.setVisible(true);
        }

        private void decrementSelection() {
            int n = this.list.getNumItems();
            int n2 = this.list.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            n2 = n2 == 0 ? n - 1 : n2 - 1;
            this.list.setSelectedIndex(n2);
        }

        private void incrementSelection() {
            int n = this.list.getNumItems();
            int n2 = this.list.getSelectedIndex();
            if (n2 < 0) {
                n2 = 0;
            }
            n2 = n2 == n - 1 ? 0 : n2 + 1;
            this.list.setSelectedIndex(n2);
        }

        private void doSelection() {
            TabbedPanel.this.destroyKeySelectionList();
            TabbedPanel.this.selectTab(this.list.getSelectedItem());
        }
    }

    private class Tab
    extends JComponent
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        private static final int TOP_MARGIN = 2;
        private static final int BOTTOM_MARGIN = 3;
        private static final int TEXT_LEADING_MARGIN = 6;
        private static final int TEXT_TRAILING_MARGIN = 6;
        private static final int BUTTON_TRAILING_MARGIN = 1;
        private static final int CORNER_WIDTH = 4;
        private static final int CORNER_HEIGHT = 4;
        private static final int BUTTON_ICON_WIDTH = 8;
        private static final int BUTTON_ICON_HEIGHT = 7;
        private static final int BUTTON_WIDTH = 14;
        private static final int BUTTON_HEIGHT = 13;
        private static final int MIN_WIDTH = 6;
        private String title;
        private Action closeAction;
        private int preferredWidth;
        private int height;
        private boolean selected;
        private boolean closeButtonPressed;
        private ButtonState closeButtonState;

        private Tab(String string, Action action) {
            this.title = string;
            this.closeAction = action;
            this.closeButtonState = ButtonState.NOT_OVER;
            GuiUtilities.setFont("MAIN", this);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.preferredWidth = 6 + fontMetrics.stringWidth(string) + 6 + 14 + 1;
            this.height = 2 + Math.max(fontMetrics.getAscent() + fontMetrics.getDescent(), 13) + 3;
            this.setOpaque(true);
            this.setFocusable(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.close(actionEvent.getModifiers());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setCloseButtonState(this.inCloseButton(mouseEvent.getPoint()) ? ButtonState.OVER : ButtonState.NOT_OVER);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setCloseButtonState(ButtonState.NOT_OVER);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setCloseButtonState(this.inCloseButton(mouseEvent.getPoint()) ? ButtonState.PRESSED : ButtonState.NOT_OVER);
            if (this.closeButtonState == ButtonState.PRESSED) {
                this.closeButtonPressed = true;
            } else {
                TabbedPanel.this.showTab(this.getIndex());
            }
            this.showPopUpMenu(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setCloseButtonState(this.inCloseButton(mouseEvent.getPoint()) ? ButtonState.OVER : ButtonState.NOT_OVER);
            if (this.closeButtonState == ButtonState.OVER && this.closeButtonPressed) {
                this.close(mouseEvent.getModifiersEx());
            }
            this.closeButtonPressed = false;
            this.showPopUpMenu(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.setCloseButtonState(this.inCloseButton(mouseEvent.getPoint()) ? ButtonState.PRESSED : ButtonState.NOT_OVER);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.setCloseButtonState(this.inCloseButton(mouseEvent.getPoint()) ? ButtonState.OVER : ButtonState.NOT_OVER);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.height);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            graphics = graphics.create();
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.selected ? SELECTED_TAB_BACKGROUND_COLOUR : TAB_BACKGROUND_COLOUR);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            boolean bl = n2 == this.preferredWidth;
            boolean bl2 = this.getComponentOrientation().isLeftToRight();
            graphics.setColor(this.getBackground());
            if (bl) {
                graphics.fillRect(0, 0, 4, 4);
                graphics.drawImage(this.selected ? CORNER_LS_ICON.getImage() : CORNER_L_ICON.getImage(), 0, 0, null);
                graphics.fillRect(n2 - 4, 0, 4, 4);
                graphics.drawImage(this.selected ? CORNER_RS_ICON.getImage() : CORNER_R_ICON.getImage(), n2 - 4, 0, null);
            } else if (bl2) {
                graphics.fillRect(0, 0, 4, 4);
                graphics.drawImage(this.selected ? CORNER_LS_ICON.getImage() : CORNER_L_ICON.getImage(), 0, 0, null);
            } else {
                graphics.fillRect(n2 - 4, 0, 4, 4);
                graphics.drawImage(this.selected ? CORNER_RS_ICON.getImage() : CORNER_R_ICON.getImage(), n2 - 4, 0, null);
            }
            TextRendering.setHints((Graphics2D)graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.title;
            if (!bl) {
                n = n2 - 6 - 6;
                String string2 = string = n < fontMetrics.stringWidth("...") ? null : TextUtilities.getLimitedWidthString(string, fontMetrics, n, false);
            }
            if (string != null) {
                graphics.setColor(TEXT_COLOUR);
                graphics.drawString(string, bl2 ? 6 : n2 - 6 - fontMetrics.stringWidth(string), GuiUtilities.getBaselineOffset(n3, fontMetrics));
            }
            if (bl) {
                n = bl2 ? n2 - 14 - 1 : 1;
                int n4 = (n3 - 13 + 1) / 2;
                if (this.closeButtonState != ButtonState.NOT_OVER) {
                    graphics.setColor(BUTTON_BORDER_COLOUR);
                    if (this.closeButtonState == ButtonState.PRESSED) {
                        graphics.fillRect(n, n4, 14, 13);
                    } else {
                        graphics.drawRect(n, n4, 13, 12);
                        graphics.setColor(BUTTON_BACKGROUND_COLOUR);
                        graphics.fillRect(n + 1, n4 + 1, 12, 11);
                    }
                }
                graphics.drawImage(this.closeButtonState == ButtonState.PRESSED ? ACTIVE_CROSS_ICON.getImage() : CROSS_ICON.getImage(), n + 3, n4 + 3, null);
            }
            graphics.setColor(this.selected ? SELECTED_TAB_BORDER_COLOUR : TAB_BORDER_COLOUR);
            if (bl) {
                graphics.drawLine(0, 4, 0, n3 - 1);
                graphics.drawLine(4, 0, n2 - 5, 0);
                graphics.drawLine(n2 - 1, 4, n2 - 1, n3 - 1);
            } else if (bl2) {
                graphics.drawLine(0, 4, 0, n3 - 1);
                graphics.drawLine(4, 0, n2 - 1, 0);
            } else {
                graphics.drawLine(0, 0, n2 - 5, 0);
                graphics.drawLine(n2 - 1, 4, n2 - 1, n3 - 1);
            }
            if (!this.selected) {
                graphics.setColor(SELECTED_TAB_BORDER_COLOUR);
                graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
            }
        }

        private String getTitle() {
            return this.title;
        }

        private void setSelected(boolean bl) {
            if (this.selected != bl) {
                this.selected = bl;
                this.repaint();
            }
        }

        private void setTitle(String string) {
            if (!this.title.equals(string)) {
                this.title = string;
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n = 6 + fontMetrics.stringWidth(string) + 6 + 14 + 1;
                if (this.preferredWidth != n) {
                    this.preferredWidth = n;
                    TabbedPanel.this.updateTabs();
                } else {
                    this.repaint();
                }
            }
        }

        private boolean inCloseButton(Point point) {
            int n = this.getWidth();
            if (n < this.preferredWidth) {
                return false;
            }
            int n2 = 0;
            int n3 = 0;
            if (this.getComponentOrientation().isLeftToRight()) {
                n3 = n - 1;
                n2 = n3 - 14;
            } else {
                n2 = 1;
                n3 = n2 + 14;
            }
            int n4 = (this.getHeight() - 13) / 2;
            int n5 = n4 + 13;
            return point.x >= n2 && point.x < n3 && point.y >= n4 && point.y < n5;
        }

        private void setCloseButtonState(ButtonState buttonState) {
            if (this.closeButtonState != buttonState) {
                this.closeButtonState = buttonState;
                this.repaint();
            }
        }

        private int getIndex() {
            for (int i = 0; i < TabbedPanel.this.elements.size(); ++i) {
                if (((Element)TabbedPanel.this.elements.get(i)).tab != this) continue;
                return i;
            }
            return -1;
        }

        private int getPreferredWidth() {
            return this.preferredWidth;
        }

        private void showPopUpMenu(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (TabbedPanel.this.popUpMenu == null) {
                    TabbedPanel.this.popUpMenu = new JPopupMenu();
                    TabbedPanel.this.popUpMenu.applyComponentOrientation(this.getComponentOrientation());
                } else {
                    TabbedPanel.this.popUpMenu.removeAll();
                }
                TabbedPanel.this.popUpMenu.add(new FMenuItem(new TabAction("close", "Close")));
                int n = mouseEvent.getX();
                if (!this.getComponentOrientation().isLeftToRight()) {
                    n -= ((TabbedPanel)TabbedPanel.this).popUpMenu.getPreferredSize().width;
                }
                TabbedPanel.this.popUpMenu.show(mouseEvent.getComponent(), n, mouseEvent.getY());
            }
        }

        private void close(int n) {
            if (this.closeAction != null) {
                String string = this.closeAction.getValue("ActionCommandKey").toString() + Integer.toString(this.getIndex());
                this.closeAction.actionPerformed(new ActionEvent(this, 1001, string, n));
            }
        }

        protected class TabAction
        extends AbstractAction {
            protected TabAction(String string, String string2) {
                super(string2);
                this.putValue("ActionCommandKey", string);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tab.this.actionPerformed(actionEvent);
            }
        }
    }

    private class ListButton
    extends ArrowButton
    implements MouseListener,
    MouseMotionListener {
        private static final int CLICK_INTERVAL = 500;
        private long pressTime;

        private ListButton() {
            super(17, 15, 5, ArrowButton.Direction.DOWN);
            this.setActive(ArrowButton.Active.PRESSED);
            this.setFocusable(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TabbedPanel.this.mouseSelectionListWindow == null) {
                this.pressTime = mouseEvent.getWhen();
                TabbedPanel.this.createMouseSelectionList();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TabbedPanel.this.mouseSelectionListWindow != null && mouseEvent.getWhen() > this.pressTime + 500L) {
                TabbedPanel.this.mouseSelectionListWindow.updateSelection(mouseEvent);
                TabbedPanel.this.mouseSelectionListWindow.doSelection();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (TabbedPanel.this.mouseSelectionListWindow != null) {
                TabbedPanel.this.mouseSelectionListWindow.updateSelection(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class ScrollButton
    extends ArrowButton
    implements MouseListener {
        private ScrollDirection scrollDirection;

        private ScrollButton(ScrollDirection scrollDirection) {
            super(15, 15, 5);
            this.scrollDirection = scrollDirection;
            this.setActive(ArrowButton.Active.PRESSED);
            this.setFocusable(false);
            this.setDirection(true);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                TabbedPanel.this.startScrolling(this.scrollDirection);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isEnabled()) {
                TabbedPanel.this.stopScrolling();
            }
        }

        public void setDirection(boolean bl) {
            this.setDirection(bl ? (this.scrollDirection == ScrollDirection.BACKWARD ? ArrowButton.Direction.LEFT : ArrowButton.Direction.RIGHT) : (this.scrollDirection == ScrollDirection.BACKWARD ? ArrowButton.Direction.RIGHT : ArrowButton.Direction.LEFT));
        }
    }

    private static class Element {
        private Tab tab;
        private Component component;
        private Component focusOwner;

        private Element(Tab tab, Component component) {
            this.tab = tab;
            this.component = component;
        }

        public String toString() {
            return this.tab.getTitle();
        }
    }

    private static interface Command {
        public static final String CLOSE = "close";
        public static final String SCROLL = "scroll";
        public static final String SELECT_PREVIOUS_TAB = "selectPreviousTab";
        public static final String SELECT_NEXT_TAB = "selectNextTab";
    }

    private static enum ScrollDirection {
        BACKWARD,
        FORWARD;

    }

    private static enum ButtonState {
        NOT_OVER,
        OVER,
        PRESSED;

    }
}

