/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.Colours;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.TextRendering;
import functionplotter.util.TextUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class SelectionIndicatorList<E>
extends JComponent {
    private static final int BORDER_TOP = 1;
    private static final int BORDER_BOTTOM = 1;
    private static final int BORDER_LEFT = 1;
    private static final int BORDER_RIGHT = 1;
    private static final int ICON_LEADING_MARGIN = 6;
    private static final int ICON_WIDTH = 5;
    private static final int ICON_HEIGHT = 5;
    private static final int TEXT_TOP_MARGIN = 1;
    private static final int TEXT_BOTTOM_MARGIN = 1;
    private static final int TEXT_LEADING_MARGIN = 6;
    private static final int TEXT_TRAILING_MARGIN = 6;
    private static final Color BORDER_COLOUR = Color.DARK_GRAY;
    private int columnWidth;
    private int rowHeight;
    private int maxTextWidth;
    private List<E> items;
    private int currentIndex;
    private int selectedIndex;

    public SelectionIndicatorList(List<E> list, E e) {
        this(list, e, 0, 0);
    }

    public SelectionIndicatorList(List<E> list, E e, int n, int n2) throws IllegalArgumentException {
        this(list, e == null ? -1 : list.indexOf(e), n, n2);
    }

    public SelectionIndicatorList(List<E> list, int n) {
        this(list, n, 0, 0);
    }

    public SelectionIndicatorList(List<E> list, int n, int n2, int n3) throws IllegalArgumentException {
        Serializable serializable;
        if (list == null || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0 || n3 == 0) {
            serializable = GuiUtilities.getVirtualScreenBounds();
            if (n2 == 0) {
                n2 = ((Rectangle)serializable).width;
            }
            if (n3 == 0) {
                n3 = ((Rectangle)serializable).height;
            }
        }
        this.items = new ArrayList();
        this.selectedIndex = -1;
        GuiUtilities.setFont("MAIN", this);
        serializable = this.getFontMetrics(this.getFont());
        this.rowHeight = 1 + ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getDescent() + 1;
        int n4 = Math.min((n3 - 1 - 1) / this.rowHeight, list.size());
        this.currentIndex = n < 0 || n >= n4 ? -1 : n;
        this.maxTextWidth = n2 - 1 - 6 - 6 - 1;
        if (this.currentIndex >= 0) {
            this.maxTextWidth -= 11;
        }
        for (int i = 0; i < n4; ++i) {
            E e = list.get(i);
            this.items.add(e);
            String string = TextUtilities.getLimitedWidthString(e.toString(), (FontMetrics)serializable, this.maxTextWidth, false);
            int n5 = ((FontMetrics)serializable).stringWidth(string);
            if (this.columnWidth >= n5) continue;
            this.columnWidth = n5;
        }
        this.columnWidth += 12;
        if (this.currentIndex >= 0) {
            this.columnWidth += 11;
        }
        this.setOpaque(true);
        this.setFocusable(false);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1 + this.columnWidth + 1, 1 + this.items.size() * this.rowHeight + 1);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics = graphics.create();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Colours.List.BACKGROUND.getColour());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n4 = Math.max(0, rectangle.y / this.rowHeight);
        int n5 = Math.min(Math.max(0, (rectangle.y + rectangle.height + this.rowHeight - 1) / this.rowHeight), this.items.size() - 1);
        if (this.selectedIndex >= n4 && this.selectedIndex <= n5) {
            graphics.setColor(Colours.List.FOCUSED_SELECTION_BACKGROUND.getColour());
            graphics.fillRect(rectangle.x, 1 + this.selectedIndex * this.rowHeight, rectangle.width, this.rowHeight);
        }
        boolean bl = this.getComponentOrientation().isLeftToRight();
        int n6 = this.getWidth();
        if (this.currentIndex >= 0) {
            int n7 = bl ? 7 : n6 - 1 - 6 - 5;
            n3 = 1 + this.currentIndex * this.rowHeight + (this.rowHeight - 5 + 1) / 2;
            graphics.setColor(this.currentIndex == this.selectedIndex ? Colours.List.FOCUSED_SELECTION_FOREGROUND.getColour() : Colours.List.FOREGROUND.getColour());
            for (n2 = 0; n2 < 5; ++n2) {
                int n8 = n7;
                n = n7 + 5 - 1;
                if (n2 == 0 || n2 == 4) {
                    ++n8;
                    --n;
                }
                graphics.drawLine(n8, n3, n, n3);
                ++n3;
            }
        }
        TextRendering.setHints((Graphics2D)graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n3 = 1 + n4 * this.rowHeight + 1 + fontMetrics.getAscent();
        for (n2 = n4; n2 <= n5; ++n2) {
            String string = TextUtilities.getLimitedWidthString(this.items.get(n2).toString(), fontMetrics, this.maxTextWidth, false);
            int n9 = n = bl ? 7 : n6 - 1 - 6 - fontMetrics.stringWidth(string);
            if (this.currentIndex >= 0) {
                n = bl ? (n += 11) : (n -= 11);
            }
            graphics.setColor(n2 == this.selectedIndex ? Colours.List.FOCUSED_SELECTION_FOREGROUND.getColour() : Colours.List.FOREGROUND.getColour());
            graphics.drawString(string, n, n3);
            n3 += this.rowHeight;
        }
        graphics.setColor(BORDER_COLOUR);
        graphics.drawRect(0, 0, n6 - 1, this.getHeight() - 1);
    }

    public int getNumItems() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public E getSelectedItem() {
        return this.selectedIndex < 0 ? null : (E)this.items.get(this.selectedIndex);
    }

    public void setSelectedIndex(int n) {
        if (this.selectedIndex != n) {
            this.selectedIndex = n;
            this.repaint();
        }
    }

    public void setSelectedItem(E e) {
        this.setSelectedIndex(this.items.indexOf(e));
    }

    public int pointToIndex(Point point) {
        int n = -1;
        if (point.x >= 1 && point.x < this.getWidth() - 1 && point.y >= 1 && point.y < this.getHeight() - 1 && (n = (point.y - 1) / this.rowHeight) >= this.items.size()) {
            n = -1;
        }
        return n;
    }
}

