/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.gui.AbstractIntegerSpinner;
import functionplotter.gui.GuiUtilities;
import functionplotter.textfield.IntegerValueField;
import java.awt.Font;

public class IntegerSpinner
extends AbstractIntegerSpinner {
    public IntegerSpinner(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, false);
    }

    public IntegerSpinner(int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, new Editor(n4, bl));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.editor != null) {
            this.editor.setFont(font);
        }
    }

    @Override
    protected boolean isEditorInvalid() {
        return ((Editor)this.editor).isInvalid();
    }

    public void setSigned(boolean bl) {
        ((Editor)this.editor).setSigned(bl);
    }

    private static class Editor
    extends IntegerValueField {
        private static final String VALID_CHARS = "-0123456789";
        private boolean signed;

        private Editor(int n, boolean bl) {
            super(n);
            this.signed = bl;
        }

        @Override
        public int getValue() throws NumberFormatException {
            try {
                if (this.signed) {
                    return Integer.parseInt(this.getText());
                }
                long l = Long.parseLong(this.getText());
                if (l > 0xFFFFFFFFL) {
                    throw new NumberFormatException();
                }
                return (int)l;
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalid(true);
                throw numberFormatException;
            }
        }

        @Override
        public void setValue(int n) {
            this.setText(this.signed ? Integer.toString(n) : Long.toString((long)n & 0xFFFFFFFFL));
        }

        @Override
        protected boolean acceptCharacter(char c, int n) {
            int n2 = VALID_CHARS.indexOf(c);
            return n2 > 0 || this.signed && n2 == 0;
        }

        @Override
        protected int getColumnWidth() {
            return GuiUtilities.getCharWidth(48, this.getFontMetrics(this.getFont())) + 1;
        }

        public void setSigned(boolean bl) {
            this.signed = bl;
        }
    }
}

