/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.exception;

import functionplotter.exception.AppException;
import functionplotter.exception.ExceptionUtilities;
import java.io.File;

public class FileException
extends AppException {
    private static final int MAX_PATHNAME_LENGTH = 160;
    private File file;

    public FileException(AppException.Id id, File file) {
        super(id);
        this.file = file;
    }

    public FileException(AppException.Id id, File file, Throwable throwable) {
        super(id, throwable);
        this.file = file;
    }

    public FileException(AppException.Id id, File file, String string) {
        super(id, string);
        this.file = file;
    }

    public FileException(AppException.Id id, File file, String[] stringArray) {
        super(id, stringArray);
        this.file = file;
    }

    public FileException(AppException.Id id, File file, Throwable throwable, String string) {
        super(id, throwable, string);
        this.file = file;
    }

    public FileException(AppException.Id id, File file, Throwable throwable, String[] stringArray) {
        super(id, throwable, stringArray);
        this.file = file;
    }

    public FileException(AppException appException, File file) {
        this(appException.getId(), file, appException.getCause(), appException.getSubstitutionStrings());
    }

    protected static String getPathname(File file) {
        return ExceptionUtilities.getLimitedPathname(file, 160);
    }

    @Override
    public String getPrefix() {
        return this.file == null ? null : this.getPathname() + "\n";
    }

    public File getFile() {
        return this.file;
    }

    public String getPathname() {
        return FileException.getPathname(this.file);
    }
}

