/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.exception;

import java.io.File;
import java.util.ArrayList;

public class ExceptionUtilities {
    private static final String ELLIPSIS_STR = "...";
    private static final String USER_HOME_PREFIX = "~";
    private static boolean unixStyle;

    private ExceptionUtilities() {
    }

    public static boolean isUnixStyle() {
        return unixStyle;
    }

    public static void setUnixStyle(boolean bl) {
        unixStyle = bl;
    }

    public static String getPathname(File file) {
        String string = null;
        try {
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                string = file.getAbsolutePath();
            }
        }
        catch (SecurityException securityException) {
            ExceptionUtilities.writeError(securityException);
            string = file.getPath();
        }
        return string;
    }

    public static String getLimitedPathname(File file, int n) {
        String string = ExceptionUtilities.getPathname(file);
        if (unixStyle && string != null) {
            try {
                String string2 = System.getProperty("user.home");
                if (string2 != null && string.startsWith(string2)) {
                    string = USER_HOME_PREFIX + string.substring(string2.length());
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string = string.replace(File.separatorChar, '/');
        }
        return ExceptionUtilities.getLimitedPathname(string, n);
    }

    public static String getLimitedPathname(String string, int n) {
        int n2;
        if (string == null) {
            return null;
        }
        char c = unixStyle ? (char)'/' : (char)File.separatorChar;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            int n3 = i;
            if ((i = string.indexOf(c, i)) < 0) {
                i = string.length();
            }
            if (i <= n3) continue;
            arrayList.add(string.substring(n3, i));
        }
        if (arrayList.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(ELLIPSIS_STR);
        int n4 = 0;
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            stringBuilder.append(c);
            stringBuilder.append((String)arrayList.get(n2));
            if (stringBuilder.length() > n) break;
            ++n4;
        }
        if (n4 == 0) {
            String string2 = (String)arrayList.get(arrayList.size() - 1);
            return ELLIPSIS_STR + string2.substring(Math.max(0, string2.length() - n + ELLIPSIS_STR.length()));
        }
        if (n4 == arrayList.size()) {
            return string;
        }
        stringBuilder = new StringBuilder(ELLIPSIS_STR);
        for (n2 = arrayList.size() - n4; n2 < arrayList.size(); ++n2) {
            stringBuilder.append(c);
            stringBuilder.append((String)arrayList.get(n2));
        }
        return stringBuilder.toString();
    }

    private static void writeError(Exception exception) {
        System.err.println(exception);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            System.err.println(stackTraceElementArray[0]);
        }
    }
}

