/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;

class Util {
    private static final String USER_HOME_PREFIX = "~";
    private static final String FAILED_TO_GET_PATHNAME_STR = "Failed to get the canonical pathname for the file or directory.";

    private Util() {
    }

    public static int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static String mapString(String[] stringArray, String string) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        String string2 = string;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            string2 = stringArray[i + 1];
            break;
        }
        return string2;
    }

    public static int changeLineSeparators(char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n + n2;
        while (n3 < n5) {
            int n6;
            if ((n6 = cArray[n3++]) == 13) {
                if (n3 < n5 && cArray[n3] == '\n') {
                    ++n3;
                }
                n6 = 10;
            }
            cArray[n4++] = n6;
        }
        return n4;
    }

    public static void moveFocus(Window window) {
        Component component;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (window != null && window == keyboardFocusManager.getFocusedWindow() && (component = keyboardFocusManager.getFocusOwner()) != null && !component.isEnabled()) {
            Component component2 = null;
            while (component2 != component) {
                keyboardFocusManager.focusNextComponent();
                component2 = keyboardFocusManager.getFocusOwner();
                if (component2 == null || !component2.isEnabled()) continue;
                break;
            }
        }
    }

    public static String getPathname(File file, boolean bl) {
        String string = null;
        if (file != null) {
            try {
                try {
                    string = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    System.err.println(file.getPath());
                    System.err.println(FAILED_TO_GET_PATHNAME_STR);
                    System.err.println("(" + exception + ")");
                    string = file.getAbsolutePath();
                }
            }
            catch (SecurityException securityException) {
                System.err.println(securityException);
                string = file.getPath();
            }
            if (bl) {
                try {
                    String string2 = System.getProperty("user.home");
                    if (string2 != null && string.startsWith(string2)) {
                        string = USER_HOME_PREFIX + string.substring(string2.length());
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                string = string.replace(File.separatorChar, '/');
            }
        }
        return string;
    }

    public static boolean isSameFile(File file, File file2) {
        try {
            if (file == null) {
                return file2 == null;
            }
            return file2 != null && file.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static File appendSuffix(File file, String string) {
        String string2 = file.getName();
        if (!string2.isEmpty() && string2.indexOf(46) < 0) {
            file = new File(file.getParentFile(), string2 + string);
        }
        return file;
    }
}

