/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.Util;
import functionplotter.gui.FButton;
import functionplotter.gui.FLabel;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.SelectionList;
import functionplotter.util.KeyAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ListSelectionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final int LIST_NUM_ROWS = 16;
    private static final int LIST_NUM_COLUMNS = 72;
    private static final String SELECT_ALL_STR = "Select All";
    private static final String DESELECT_ALL_STR = "Deselect All";
    private static final String SELECT_ALL_TOOLTIP_STR = "Select all items (Ctrl+A)";
    private static final String DESELECT_ALL_TOOLTIP_STR = "Deselect all items (Ctrl+D)";
    private static final KeyAction.CommandMap[] KEY_COMMANDS = new KeyAction.CommandMap[]{new KeyAction.CommandMap(KeyStroke.getKeyStroke(65, 128), "selectAll"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(68, 128), "deselectAll"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(27, 0), "close")};
    private static Point location;
    private boolean accepted;
    private SelectionList list;
    private JButton selectAllButton;
    private JButton deselectAllButton;
    private JButton okButton;

    private ListSelectionDialog(Window window, String string, String string2, String[] stringArray) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.setIconImages(window.getIconImages());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        int n = 0;
        FLabel fLabel = new FLabel(string2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel.add(fLabel);
        this.list = new SelectionList(stringArray, 72, 16);
        this.list.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.list, 20, 30);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 8, 0));
        this.selectAllButton = new FButton(SELECT_ALL_STR);
        this.selectAllButton.setToolTipText(SELECT_ALL_TOOLTIP_STR);
        this.selectAllButton.setActionCommand("selectAll");
        this.selectAllButton.addActionListener(this);
        jPanel2.add(this.selectAllButton);
        this.deselectAllButton = new FButton(DESELECT_ALL_STR);
        this.deselectAllButton.setToolTipText(DESELECT_ALL_TOOLTIP_STR);
        this.deselectAllButton.setActionCommand("deselectAll");
        this.deselectAllButton.addActionListener(this);
        jPanel2.add(this.deselectAllButton);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0, 8, 0));
        this.okButton = new FButton("OK");
        this.okButton.setActionCommand("accept");
        this.okButton.addActionListener(this);
        jPanel3.add(this.okButton);
        FButton fButton = new FButton("Cancel");
        fButton.setActionCommand("close");
        fButton.addActionListener(this);
        jPanel3.add(fButton);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 24, 3, 24));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel4.add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel5.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel5.add(jPanel4);
        KeyAction.create((JComponent)jPanel5, 1, KEY_COMMANDS, (ActionListener)this);
        this.setContentPane(jPanel5);
        this.updateComponents();
        App.applyOrientationByLocale(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            location = GuiUtilities.getComponentLocation((Component)this, window);
        }
        this.setLocation(location);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public static int[] showDialog(Component component, String string, String string2, String[] stringArray) {
        return new ListSelectionDialog(GuiUtilities.getWindow(component), string, string2, stringArray).getSelections();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("selectAll")) {
            this.doSelectAll();
        } else if (string.equals("deselectAll")) {
            this.doDeselectAll();
        } else if (string.equals("accept")) {
            this.doAccept();
        } else if (string.equals("close")) {
            this.doClose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateComponents();
        }
    }

    private int[] getSelections() {
        return this.accepted ? this.list.getSelectedIndices() : null;
    }

    private void updateComponents() {
        boolean bl = this.list.getSelectedIndices().length < this.list.getModel().getSize();
        this.selectAllButton.setEnabled(bl);
        bl = !this.list.isSelectionEmpty();
        this.deselectAllButton.setEnabled(bl);
        this.okButton.setEnabled(bl);
        Util.moveFocus(this);
    }

    private void doSelectAll() {
        this.list.setSelectionInterval(0, this.list.getModel().getSize() - 1);
    }

    private void doDeselectAll() {
        this.list.clearSelection();
    }

    private void doAccept() {
        this.accepted = true;
        this.doClose();
    }

    private void doClose() {
        location = this.getLocation();
        this.setVisible(false);
        this.dispose();
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ListSelectionDialog.this.doClose();
        }
    }

    private static interface Command {
        public static final String SELECT_ALL = "selectAll";
        public static final String DESELECT_ALL = "deselectAll";
        public static final String ACCEPT = "accept";
        public static final String CLOSE = "close";
    }
}

