/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.exception.AppException;
import functionplotter.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;

class Expression {
    private static final String VARIABLE_STR = "x";
    private String str;
    private List<Token> tokens;
    private Node tree;

    public Expression(String string) throws Exception {
        this.str = string;
        this.parse(string);
    }

    private static boolean isWhitespace(char c) {
        return " \t\n\r".indexOf(c) >= 0;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isSymbol(char c) {
        return Symbol.get(c) != null;
    }

    private static LexState getLexState(char c) {
        if (c == '\u0000') {
            return LexState.EOL;
        }
        if (Expression.isWhitespace(c)) {
            return LexState.WHITESPACE;
        }
        if (Expression.isNumber(c)) {
            return LexState.NUMBER;
        }
        if (Expression.isAlpha(c)) {
            return LexState.ALPHA;
        }
        if (Expression.isSymbol(c)) {
            return LexState.SYMBOL;
        }
        return LexState.INVALID;
    }

    private static Token numberToToken(String string, int n) throws Exception {
        try {
            return new Token.NumberToken(n, Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception(ErrorId.INVALID_NUMBER, string, n);
        }
    }

    private static Token alphaToToken(String string, int n) throws Exception {
        if (string.equals(VARIABLE_STR)) {
            return new Token.VariableToken(n);
        }
        Keyword keyword = Keyword.get(string);
        if (keyword == null) {
            throw new Exception(ErrorId.UNRECOGNISED_TOKEN, string, n);
        }
        return new Token.KeywordToken(n, keyword);
    }

    private static Token symbolToToken(String string, int n) throws Exception {
        if (string.length() > 1) {
            throw new Exception(ErrorId.UNRECOGNISED_TOKEN, string, n);
        }
        return new Token.SymbolToken(n, Symbol.get(string.charAt(0)));
    }

    private static List<Token> toTokens(String string) throws Exception {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        NumericState numericState = NumericState.SIGNIFICAND;
        LexState lexState = LexState.WHITESPACE;
        while (lexState != LexState.DONE) {
            char c = n >= string.length() ? (char)'\u0000' : string.charAt(n);
            switch (lexState) {
                case WHITESPACE: {
                    if (Expression.isWhitespace(c)) {
                        ++n;
                        break;
                    }
                    lexState = Expression.getLexState(c);
                    if (lexState == LexState.INVALID) break;
                    n2 = n;
                    break;
                }
                case NUMBER: {
                    boolean bl = false;
                    switch (numericState) {
                        case SIGNIFICAND: {
                            if (Expression.isNumber(c)) {
                                bl = true;
                                break;
                            }
                            if (c != 'E' && c != 'e') break;
                            bl = true;
                            numericState = NumericState.EXP_INDICATOR;
                            break;
                        }
                        case EXP_INDICATOR: {
                            if (Expression.isNumber(c) || c == '+' || c == '-') {
                                bl = true;
                            }
                            numericState = NumericState.EXPONENT;
                            break;
                        }
                        case EXPONENT: {
                            if (!Expression.isNumber(c)) break;
                            bl = true;
                        }
                    }
                    if (bl) {
                        stringBuilder.append(c);
                        ++n;
                        break;
                    }
                    numericState = NumericState.SIGNIFICAND;
                    lexState = Expression.getLexState(c);
                    if (lexState == LexState.INVALID) break;
                    arrayList.add(Expression.numberToToken(stringBuilder.toString(), n2));
                    stringBuilder.setLength(0);
                    n2 = n;
                    break;
                }
                case ALPHA: {
                    if (Expression.isAlpha(c)) {
                        stringBuilder.append(c);
                        ++n;
                        break;
                    }
                    lexState = Expression.getLexState(c);
                    if (lexState == LexState.INVALID) break;
                    arrayList.add(Expression.alphaToToken(stringBuilder.toString(), n2));
                    stringBuilder.setLength(0);
                    n2 = n;
                    break;
                }
                case SYMBOL: {
                    if (Expression.isSymbol(c)) {
                        if (stringBuilder.length() > 0) {
                            arrayList.add(Expression.symbolToToken(stringBuilder.toString(), n2));
                            stringBuilder.setLength(0);
                            n2 = n;
                        }
                        stringBuilder.append(c);
                        ++n;
                        break;
                    }
                    lexState = Expression.getLexState(c);
                    if (lexState == LexState.INVALID) break;
                    arrayList.add(Expression.symbolToToken(stringBuilder.toString(), n2));
                    stringBuilder.setLength(0);
                    n2 = n;
                    break;
                }
                case EOL: {
                    arrayList.add(new Token.EofToken(n2));
                    lexState = LexState.DONE;
                    break;
                }
                case INVALID: {
                    throw new Exception(ErrorId.CHARACTER_NOT_ALLOWED, Character.toString(c), n);
                }
            }
        }
        return arrayList;
    }

    private static Node parse(List<Token> list) throws Exception {
        Node node = new Node();
        Expression.createAbstractSyntaxTree(list, 0, node, false);
        return node.lChild;
    }

    private static int createAbstractSyntaxTree(List<Token> list, int n, Node node, boolean bl) throws Exception {
        Object object = node;
        ParseState parseState = ParseState.OPERAND;
        while (parseState != ParseState.DONE) {
            Token token = list.get(n++);
            switch (parseState) {
                case OPERAND: {
                    Object object2;
                    Object object3;
                    if (((Node)object).isTerminal()) {
                        throw new ParserError(1, token.offset);
                    }
                    if (token instanceof Token.NumberToken) {
                        object3 = new Node.ConstantNode((Node)object, ((Token.NumberToken)token).value);
                        if (!((Node)object).addChild((Node)object3)) {
                            throw new ParserError(2, token.offset);
                        }
                        object = object3;
                        parseState = ParseState.OPERATOR;
                        break;
                    }
                    if (token instanceof Token.VariableToken) {
                        object3 = new Node.VariableNode((Node)object);
                        if (!((Node)object).addChild((Node)object3)) {
                            throw new ParserError(3, token.offset);
                        }
                        object = object3;
                        parseState = ParseState.OPERATOR;
                        break;
                    }
                    if (token instanceof Token.KeywordToken) {
                        object3 = ((Token.KeywordToken)token).keyword;
                        object2 = ((Keyword)((Object)object3)).getOperator();
                        if (object2 == null) {
                            double d = 0.0;
                            if (object3 == Keyword.E) {
                                d = Math.E;
                            } else if (object3 == Keyword.PI) {
                                d = Math.PI;
                            }
                            Node.ConstantNode constantNode = new Node.ConstantNode((Node)object, d);
                            if (!((Node)object).addChild(constantNode)) {
                                throw new ParserError(4, token.offset);
                            }
                            object = constantNode;
                            parseState = ParseState.OPERATOR;
                            break;
                        }
                        Node.UnaryOpNode unaryOpNode = new Node.UnaryOpNode((Node)object, (UnaryOp)((Object)object2));
                        if (!((Node)object).addChild(unaryOpNode)) {
                            throw new ParserError(5, token.offset);
                        }
                        object = unaryOpNode;
                        break;
                    }
                    if (token instanceof Token.SymbolToken) {
                        object3 = ((Token.SymbolToken)token).symbol;
                        if (object3 == Symbol.OPENING_PARENTHESIS) {
                            object2 = new Node();
                            n = Expression.createAbstractSyntaxTree(list, n, (Node)object2, true);
                            if (((Node)object2).isEmpty()) {
                                throw new SyntaxError(ErrorId.OPERAND_EXPECTED, token.offset);
                            }
                            object2 = ((Node)object2).lChild;
                            if (!((Node)object).addChild((Node)object2)) {
                                throw new ParserError(6, token.offset);
                            }
                            ((Node)object2).parent = object;
                            object = object2;
                            parseState = ParseState.OPERATOR;
                            break;
                        }
                        object2 = ((Symbol)((Object)object3)).getUnaryOperator();
                        if (object2 == null) {
                            throw new SyntaxError(ErrorId.OPERAND_EXPECTED, token.offset);
                        }
                        Node.UnaryOpNode unaryOpNode = new Node.UnaryOpNode((Node)object, (UnaryOp)((Object)object2));
                        if (!((Node)object).addChild(unaryOpNode)) {
                            throw new ParserError(7, token.offset);
                        }
                        object = unaryOpNode;
                        break;
                    }
                    if (!(token instanceof Token.EofToken)) break;
                    throw new SyntaxError(ErrorId.OPERAND_EXPECTED, token.offset);
                }
                case OPERATOR: {
                    Object object2;
                    Object object3;
                    if (token instanceof Token.NumberToken || token instanceof Token.VariableToken || token instanceof Token.KeywordToken) {
                        throw new SyntaxError(ErrorId.BINARY_OPERATOR_EXPECTED, token.offset);
                    }
                    if (token instanceof Token.SymbolToken) {
                        object3 = ((Token.SymbolToken)token).symbol;
                        if (object3 == Symbol.OPENING_PARENTHESIS) {
                            throw new SyntaxError(ErrorId.BINARY_OPERATOR_EXPECTED, token.offset);
                        }
                        if (object3 == Symbol.CLOSING_PARENTHESIS) {
                            if (!bl) {
                                throw new SyntaxError(ErrorId.UNEXPECTED_CLOSING_PARENTHESIS, token.offset);
                            }
                            parseState = ParseState.DONE;
                            break;
                        }
                        object2 = ((Symbol)((Object)object3)).getBinaryOperator();
                        if (object2 == null) {
                            throw new ParserError(8, token.offset);
                        }
                        object = ((Node)object).getBinaryOperatorAncestor(((BinaryOp)((Object)object2)).getPrecedence());
                        Node.BinaryOpNode binaryOpNode = new Node.BinaryOpNode((Node)object, (BinaryOp)((Object)object2));
                        if (((Node)object).parent == null) {
                            binaryOpNode.lChild = ((Node)object).lChild;
                            ((Node)object).lChild = binaryOpNode;
                        } else {
                            binaryOpNode.lChild = ((Node)object).rChild;
                            ((Node)object).rChild = binaryOpNode;
                        }
                        binaryOpNode.lChild.parent = binaryOpNode;
                        object = binaryOpNode;
                        parseState = ParseState.OPERAND;
                        break;
                    }
                    if (!(token instanceof Token.EofToken)) break;
                    if (bl) {
                        throw new SyntaxError(ErrorId.CLOSING_PARENTHESIS_EXPECTED, token.offset);
                    }
                    parseState = ParseState.DONE;
                }
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof Expression && this.tree.equals(((Expression)object).tree);
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    public String toString() {
        return this.str;
    }

    public double evaluate(double d) {
        return this.tree.evaluate(d);
    }

    public String toCanonicalString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.tokens != null) {
            Token token;
            for (int i = 0; i < this.tokens.size() && !((token = this.tokens.get(i)) instanceof Token.EofToken); ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(token);
            }
        }
        return stringBuilder.toString();
    }

    private void parse(String string) throws Exception {
        this.tokens = Expression.toTokens(string);
        this.tree = Expression.parse(this.tokens);
    }

    private static class ParserError
    extends Exception {
        private static final String PARSER_ERROR_STR = "Parser error";

        private ParserError(int n, int n2) {
            super("Parser error " + n, n2);
        }
    }

    private static class SyntaxError
    extends Exception {
        private static final String SYNTAX_ERROR_STR = "Syntax error";

        private SyntaxError(ErrorId errorId, int n) {
            super("Syntax error: " + AppException.getString(errorId), n);
        }
    }

    private static class Node {
        protected Node parent;
        protected Node lChild;
        protected Node rChild;

        private Node() {
        }

        private Node(Node node) {
            this.parent = node;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            Node node = (Node)object;
            if (this.lChild == null ? node.lChild != null : !this.lChild.equals(node.lChild)) {
                return false;
            }
            return !(this.rChild == null ? node.rChild != null : !this.rChild.equals(node.rChild));
        }

        public int hashCode() {
            int n = this.lChild == null ? 0 : this.lChild.hashCode();
            n = n * 31 + (this.rChild == null ? 0 : this.rChild.hashCode());
            return n;
        }

        public String toString() {
            return this.toNodeString(0);
        }

        public boolean isEmpty() {
            return this.lChild == null && this.rChild == null;
        }

        public boolean isTerminal() {
            return false;
        }

        public String getKindString() {
            return null;
        }

        public String getValueString() {
            return null;
        }

        public boolean addChild(Node node) {
            if (this.lChild == null) {
                this.lChild = node;
                return true;
            }
            if (this.rChild == null) {
                this.rChild = node;
                return true;
            }
            return false;
        }

        public double evaluate(double d) {
            return Double.NaN;
        }

        public Node getBinaryOperatorAncestor(int n) {
            Node node = this;
            while (!(node.parent == null || (node = node.parent) instanceof BinaryOpNode && ((BinaryOpNode)node).binaryOp.getPrecedence() < n)) {
            }
            return node;
        }

        private String toNodeString(int n) {
            String string = this.getKindString();
            string = string == null ? new String() : string + " : " + this.getValueString();
            String string2 = new String(StringUtilities.createCharArray(' ', n * 4));
            if (this.lChild != null) {
                string = string + "\n" + string2 + "<L> " + this.lChild.toNodeString(n + 1);
            }
            if (this.rChild != null) {
                string = string + "\n" + string2 + "<R> " + this.rChild.toNodeString(n + 1);
            }
            return string;
        }

        private static class BinaryOpNode
        extends Node {
            private static final String KIND_STR = "binaryOp";
            private BinaryOp binaryOp;

            private BinaryOpNode(Node node, BinaryOp binaryOp) {
                super(node);
                this.binaryOp = binaryOp;
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof BinaryOpNode)) {
                    return false;
                }
                if (this.binaryOp != ((BinaryOpNode)object).binaryOp) {
                    return false;
                }
                return super.equals(object);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.binaryOp.ordinal();
            }

            @Override
            public String getKindString() {
                return KIND_STR;
            }

            @Override
            public String getValueString() {
                return this.binaryOp.toString();
            }

            @Override
            public double evaluate(double d) {
                return this.binaryOp.evaluate(this.lChild.evaluate(d), this.rChild.evaluate(d));
            }
        }

        private static class UnaryOpNode
        extends Node {
            private static final String KIND_STR = "unaryOp";
            private UnaryOp unaryOp;

            private UnaryOpNode(Node node, UnaryOp unaryOp) {
                super(node);
                this.unaryOp = unaryOp;
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof UnaryOpNode)) {
                    return false;
                }
                if (this.unaryOp != ((UnaryOpNode)object).unaryOp) {
                    return false;
                }
                return super.equals(object);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.unaryOp.ordinal();
            }

            @Override
            public String getKindString() {
                return KIND_STR;
            }

            @Override
            public String getValueString() {
                return this.unaryOp.toString();
            }

            @Override
            public double evaluate(double d) {
                return this.unaryOp.evaluate(this.lChild.evaluate(d));
            }
        }

        private static class VariableNode
        extends Node {
            private static final String KIND_STR = "variable";

            private VariableNode(Node node) {
                super(node);
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof VariableNode)) {
                    return false;
                }
                return super.equals(object);
            }

            @Override
            public int hashCode() {
                return super.hashCode();
            }

            @Override
            public boolean isTerminal() {
                return true;
            }

            @Override
            public String getKindString() {
                return KIND_STR;
            }

            @Override
            public String getValueString() {
                return Expression.VARIABLE_STR;
            }

            @Override
            public double evaluate(double d) {
                return d;
            }
        }

        private static class ConstantNode
        extends Node {
            private static final String KIND_STR = "constant";
            private double value;

            private ConstantNode(Node node, double d) {
                super(node);
                this.value = d;
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof ConstantNode)) {
                    return false;
                }
                if (this.value != ((ConstantNode)object).value) {
                    return false;
                }
                return super.equals(object);
            }

            @Override
            public int hashCode() {
                long l = Double.doubleToRawLongBits(this.value);
                return super.hashCode() * 31 + ((int)l ^ (int)(l >> 32));
            }

            @Override
            public boolean isTerminal() {
                return true;
            }

            @Override
            public String getKindString() {
                return KIND_STR;
            }

            @Override
            public String getValueString() {
                return Double.toString(this.value);
            }

            @Override
            public double evaluate(double d) {
                return this.value;
            }
        }
    }

    private static class Token {
        private int offset;

        private Token(int n) {
            this.offset = n;
        }

        private static class EofToken
        extends Token {
            private static final String END_STR = "<end>";

            private EofToken(int n) {
                super(n);
            }

            public String toString() {
                return END_STR;
            }
        }

        private static class SymbolToken
        extends Token {
            private static final String INVALID_SYMBOL_STR = "<invalid symbol>";
            private Symbol symbol;

            private SymbolToken(int n, Symbol symbol) {
                super(n);
                this.symbol = symbol;
            }

            public String toString() {
                return this.symbol == null ? INVALID_SYMBOL_STR : Character.toString(this.symbol.getKey());
            }
        }

        private static class KeywordToken
        extends Token {
            private static final String INVALID_KEYWORD_STR = "<invalid keyword>";
            private Keyword keyword;

            private KeywordToken(int n, Keyword keyword) {
                super(n);
                this.keyword = keyword;
            }

            public String toString() {
                return this.keyword == null ? INVALID_KEYWORD_STR : this.keyword.getKey();
            }
        }

        private static class VariableToken
        extends Token {
            private VariableToken(int n) {
                super(n);
            }

            public String toString() {
                return Expression.VARIABLE_STR;
            }
        }

        private static class NumberToken
        extends Token {
            private double value;

            private NumberToken(int n, double d) {
                super(n);
                this.value = d;
            }

            public String toString() {
                return Double.toString(this.value);
            }
        }
    }

    public static class Exception
    extends AppException {
        private int pos;

        private Exception(ErrorId errorId, int n) {
            super(errorId);
            this.pos = n;
        }

        private Exception(ErrorId errorId, String string, int n) {
            super(errorId);
            this.setSubstitutionString(string);
            this.pos = n;
        }

        private Exception(String string, int n) {
            super(string);
            this.pos = n;
        }

        public int getPos() {
            return this.pos;
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        CHARACTER_NOT_ALLOWED("The character '%1' is not allowed in an expression."),
        INVALID_NUMBER("The string \"%1\" is not a valid number."),
        UNRECOGNISED_TOKEN("The token \"%1\" is not recognised."),
        OPERAND_EXPECTED("An operand was expected."),
        BINARY_OPERATOR_EXPECTED("A binary operator was expected."),
        UNEXPECTED_CLOSING_PARENTHESIS("An unexpected ')' was found."),
        CLOSING_PARENTHESIS_EXPECTED("A ')' was expected.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static enum Symbol {
        PLUS('+', UnaryOp.PLUS, BinaryOp.ADD),
        MINUS('-', UnaryOp.MINUS, BinaryOp.SUBTRACT),
        ASTERISK('*', null, BinaryOp.MULTIPLY),
        SLASH('/', null, BinaryOp.DIVIDE),
        PERCENT('%', null, BinaryOp.REMAINDER),
        BACKSLASH('\\', null, BinaryOp.IEEE_REMAINDER),
        CARET('^', null, BinaryOp.POWER),
        OPENING_PARENTHESIS('(', null, null),
        CLOSING_PARENTHESIS(')', null, null);

        private char key;
        private UnaryOp unaryOperator;
        private BinaryOp binaryOperator;

        private Symbol(char c, UnaryOp unaryOp, BinaryOp binaryOp) {
            this.key = c;
            this.unaryOperator = unaryOp;
            this.binaryOperator = binaryOp;
        }

        public static Symbol get(char c) {
            for (Symbol symbol : Symbol.values()) {
                if (symbol.key != c) continue;
                return symbol;
            }
            return null;
        }

        public char getKey() {
            return this.key;
        }

        public UnaryOp getUnaryOperator() {
            return this.unaryOperator;
        }

        public BinaryOp getBinaryOperator() {
            return this.binaryOperator;
        }
    }

    private static enum Keyword {
        ABS("abs", UnaryOp.ABS),
        ACOS("acos", UnaryOp.ACOS),
        ACOSH("acosh", UnaryOp.ACOSH),
        ACOT("acot", UnaryOp.ACOT),
        ACSC("acsc", UnaryOp.ACSC),
        ASEC("asec", UnaryOp.ASEC),
        ASIN("asin", UnaryOp.ASIN),
        ASINH("asinh", UnaryOp.ASINH),
        ATAN("atan", UnaryOp.ATAN),
        ATANH("atanh", UnaryOp.ATANH),
        CEIL("ceil", UnaryOp.CEIL),
        COS("cos", UnaryOp.COS),
        COSH("cosh", UnaryOp.COSH),
        COT("cot", UnaryOp.COT),
        CSC("csc", UnaryOp.CSC),
        EXP("exp", UnaryOp.EXP),
        FLOOR("floor", UnaryOp.FLOOR),
        LG("lg", UnaryOp.LG),
        LN("ln", UnaryOp.LN),
        ROUND("round", UnaryOp.ROUND),
        SEC("sec", UnaryOp.SEC),
        SIN("sin", UnaryOp.SIN),
        SINH("sinh", UnaryOp.SINH),
        SQRT("sqrt", UnaryOp.SQRT),
        TAN("tan", UnaryOp.TAN),
        TANH("tanh", UnaryOp.TANH),
        E("e", null),
        PI("pi", null);

        private String key;
        private UnaryOp operator;

        private Keyword(String string2, UnaryOp unaryOp) {
            this.key = string2;
            this.operator = unaryOp;
        }

        public static Keyword get(String string) {
            for (Keyword keyword : Keyword.values()) {
                if (!keyword.key.equals(string)) continue;
                return keyword;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }

        public UnaryOp getOperator() {
            return this.operator;
        }
    }

    private static enum BinaryOp {
        ADD("add", 0){

            @Override
            public double evaluate(double d, double d2) {
                return d + d2;
            }
        }
        ,
        SUBTRACT("subtract", 0){

            @Override
            public double evaluate(double d, double d2) {
                return d - d2;
            }
        }
        ,
        MULTIPLY("multiply", 1){

            @Override
            public double evaluate(double d, double d2) {
                return d * d2;
            }
        }
        ,
        DIVIDE("divide", 1){

            @Override
            public double evaluate(double d, double d2) {
                return d / d2;
            }
        }
        ,
        REMAINDER("remainder", 1){

            @Override
            public double evaluate(double d, double d2) {
                return d % d2;
            }
        }
        ,
        IEEE_REMAINDER("ieeeRemainder", 1){

            @Override
            public double evaluate(double d, double d2) {
                return Math.IEEEremainder(d, d2);
            }
        }
        ,
        POWER("power", 2){

            @Override
            public double evaluate(double d, double d2) {
                return Math.pow(d, d2);
            }
        };

        private String key;
        private int precedence;

        private BinaryOp(String string2, int n2) {
            this.key = string2;
            this.precedence = n2;
        }

        public abstract double evaluate(double var1, double var3);

        public String toString() {
            return this.key;
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }

    private static enum UnaryOp {
        ABS("abs"){

            @Override
            public double evaluate(double d) {
                return Math.abs(d);
            }
        }
        ,
        ACOS("acos"){

            @Override
            public double evaluate(double d) {
                return Math.acos(d);
            }
        }
        ,
        ACOSH("acosh"){

            @Override
            public double evaluate(double d) {
                return d < 1.0 ? Double.NaN : Math.log(d + Math.sqrt(d * d - 1.0));
            }
        }
        ,
        ACOT("acot"){

            @Override
            public double evaluate(double d) {
                return Math.atan(1.0 / d);
            }
        }
        ,
        ACSC("acsc"){

            @Override
            public double evaluate(double d) {
                return Math.asin(1.0 / d);
            }
        }
        ,
        ASEC("asec"){

            @Override
            public double evaluate(double d) {
                return Math.acos(1.0 / d);
            }
        }
        ,
        ASIN("asin"){

            @Override
            public double evaluate(double d) {
                return Math.asin(d);
            }
        }
        ,
        ASINH("asinh"){

            @Override
            public double evaluate(double d) {
                return Math.log(d + Math.sqrt(d * d + 1.0));
            }
        }
        ,
        ATAN("atan"){

            @Override
            public double evaluate(double d) {
                return Math.atan(d);
            }
        }
        ,
        ATANH("atanh"){

            @Override
            public double evaluate(double d) {
                return d >= -1.0 && d <= 1.0 ? 0.5 * Math.log((1.0 + d) / (1.0 - d)) : Double.NaN;
            }
        }
        ,
        CEIL("ceil"){

            @Override
            public double evaluate(double d) {
                return Math.ceil(d);
            }
        }
        ,
        COS("cos"){

            @Override
            public double evaluate(double d) {
                return Math.cos(d);
            }
        }
        ,
        COSH("cosh"){

            @Override
            public double evaluate(double d) {
                return 0.5 * (Math.exp(d) + Math.exp(-d));
            }
        }
        ,
        COT("cot"){

            @Override
            public double evaluate(double d) {
                return 1.0 / Math.tan(d);
            }
        }
        ,
        CSC("csc"){

            @Override
            public double evaluate(double d) {
                return 1.0 / Math.sin(d);
            }
        }
        ,
        EXP("exp"){

            @Override
            public double evaluate(double d) {
                return Math.exp(d);
            }
        }
        ,
        FLOOR("floor"){

            @Override
            public double evaluate(double d) {
                return Math.floor(d);
            }
        }
        ,
        LG("lg"){

            @Override
            public double evaluate(double d) {
                return Math.log10(d);
            }
        }
        ,
        LN("ln"){

            @Override
            public double evaluate(double d) {
                return Math.log(d);
            }
        }
        ,
        ROUND("round"){

            @Override
            public double evaluate(double d) {
                return Math.rint(d);
            }
        }
        ,
        SEC("sec"){

            @Override
            public double evaluate(double d) {
                return 1.0 / Math.cos(d);
            }
        }
        ,
        SIN("sin"){

            @Override
            public double evaluate(double d) {
                return Math.sin(d);
            }
        }
        ,
        SINH("sinh"){

            @Override
            public double evaluate(double d) {
                return 0.5 * (Math.exp(d) - Math.exp(-d));
            }
        }
        ,
        SQRT("sqrt"){

            @Override
            public double evaluate(double d) {
                return Math.sqrt(d);
            }
        }
        ,
        TAN("tan"){

            @Override
            public double evaluate(double d) {
                return Math.tan(d);
            }
        }
        ,
        TANH("tanh"){

            @Override
            public double evaluate(double d) {
                double d2 = Math.exp(2.0 * d);
                return (d2 - 1.0) / (d2 + 1.0);
            }
        }
        ,
        PLUS("plus"){

            @Override
            public double evaluate(double d) {
                return d;
            }
        }
        ,
        MINUS("minus"){

            @Override
            public double evaluate(double d) {
                return -d;
            }
        };

        private String key;

        private UnaryOp(String string2) {
            this.key = string2;
        }

        public abstract double evaluate(double var1);

        public String toString() {
            return this.key;
        }
    }

    private static enum ParseState {
        OPERAND,
        OPERATOR,
        DONE;

    }

    private static enum NumericState {
        SIGNIFICAND,
        EXP_INDICATOR,
        EXPONENT;

    }

    private static enum LexState {
        WHITESPACE,
        NUMBER,
        ALPHA,
        SYMBOL,
        EOL,
        DONE,
        INVALID;

    }
}

