/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.AppFont;
import functionplotter.FileKind;
import functionplotter.FuncPlotter;
import functionplotter.Operation;
import functionplotter.Util;
import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.exception.UrlException;
import functionplotter.exception.ValueOutOfBoundsException;
import functionplotter.gui.FontEx;
import functionplotter.gui.ProgressView;
import functionplotter.gui.TextRendering;
import functionplotter.util.ColourUtilities;
import functionplotter.util.FilenameSuffixFilter;
import functionplotter.util.IntegerRange;
import functionplotter.util.NoYesAsk;
import functionplotter.util.Property;
import functionplotter.util.PropertySet;
import functionplotter.util.PropertyString;
import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.UIManager;

class AppConfig {
    public static final int MIN_NUM_FRACTION_DIGITS = 1;
    public static final int MAX_NUM_FRACTION_DIGITS = 12;
    public static final int MIN_FIXED_POINT_EXPONENT_LIMIT = -12;
    public static final int MAX_FIXED_POINT_EXPONENT_LIMIT = 12;
    private static final int VERSION = 0;
    private static final int MIN_SUPPORTED_VERSION = 0;
    private static final int MAX_SUPPORTED_VERSION = 0;
    private static final Color DEFAULT_BACKGROUND_COLOUR = new Color(236, 236, 224);
    private static final int COLOUR_VALUE_A1 = 0;
    private static final int COLOUR_VALUE_A2 = 236;
    private static final int COLOUR_VALUE_A3 = 255;
    private static final int COLOUR_VALUE_B1 = 112;
    private static final int COLOUR_VALUE_B2 = 184;
    private static final int COLOUR_VALUE_B3 = 255;
    private static final Color[] DEFAULT_COLOURS = new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(236, 236, 0), new Color(236, 0, 236), new Color(0, 236, 236), new Color(0, 0, 0), new Color(255, 184, 112), new Color(184, 255, 112), new Color(255, 112, 184), new Color(112, 255, 184), new Color(184, 112, 255), new Color(112, 184, 255)};
    private static final String CONFIG_ERROR_STR = "Configuration Error";
    private static final String CONFIG_DIR_KEY = "app.configDir";
    private static final String FILENAME_BASE = "funcPlotter-config";
    private static final String CONFIG_FILENAME = "funcPlotter-config.functionplotter.xml";
    private static final String CONFIG_OLD_FILENAME = "funcPlotter-config-old.functionplotter.xml";
    private static final String SAVE_CONFIGURATION_FILE_STR = "Save Configuration File";
    private static final String WRITING_STR = "Writing";
    private CPDefaultFileKind cpDefaultFileKind = new CPDefaultFileKind();
    private CPNewDocumentOnStartup cpNewDocumentOnStartup = new CPNewDocumentOnStartup();
    private CPSaveFunctionColours cpSaveFunctionColours = new CPSaveFunctionColours();
    private CPShowUnixPathnames cpShowUnixPathnames = new CPShowUnixPathnames();
    private CPShowFullPathnames cpShowFullPathnames = new CPShowFullPathnames();
    private CPMainWindowLocation cpMainWindowLocation = new CPMainWindowLocation();
    private CPLookAndFeel cpLookAndFeel = new CPLookAndFeel();
    private CPOrientationByLocale cpOrientationByLocale = new CPOrientationByLocale();
    private CPTextAntialiasing cpTextAntialiasing = new CPTextAntialiasing();
    private CPBackgroundColour cpBackgroundColour = new CPBackgroundColour();
    private CPPlotSize cpPlotSize = new CPPlotSize();
    private CPShowGrid cpShowGrid = new CPShowGrid();
    private CPNumFractionDigits cpNumFractionDigits = new CPNumFractionDigits();
    private CPNumYScaleDigits cpNumYScaleDigits = new CPNumYScaleDigits();
    private CPFixedPointExponentRange cpFixedPointExponentRange = new CPFixedPointExponentRange();
    private CPNormaliseScientificNotation cpNormaliseScientificNotation = new CPNormaliseScientificNotation();
    private CPTruncateXScaleText cpTruncateXScaleText = new CPTruncateXScaleText();
    private CPPlotColourFocusedBorder cpPlotColourFocusedBorder = new CPPlotColourFocusedBorder();
    private CPPlotColourImageMargin cpPlotColourImageMargin = new CPPlotColourImageMargin();
    private CPPlotColourBackground cpPlotColourBackground = new CPPlotColourBackground();
    private CPPlotColourGrid cpPlotColourGrid = new CPPlotColourGrid();
    private CPPlotColourAxis cpPlotColourAxis = new CPPlotColourAxis();
    private CPPlotColourScale cpPlotColourScale = new CPPlotColourScale();
    private CPFunctionPathname cpFunctionPathname = new CPFunctionPathname();
    private CPFunctionListSize cpFunctionListSize = new CPFunctionListSize();
    private CPFunctionColours cpFunctionColours = new CPFunctionColours();
    private CPFonts cpFonts = new CPFonts();
    private static AppConfig instance;
    private File file;
    private boolean fileRead;
    private File selectedFile;
    private JFileChooser fileChooser;
    private boolean permissionAccessClipboard;

    public FileKind getDefaultFileKind() {
        return (FileKind)this.cpDefaultFileKind.getValue();
    }

    public void setDefaultFileKind(FileKind fileKind) {
        this.cpDefaultFileKind.setValue(fileKind);
    }

    public boolean isNewDocumentOnStartup() {
        return (Boolean)this.cpNewDocumentOnStartup.getValue();
    }

    public void setNewDocumentOnStartup(boolean bl) {
        this.cpNewDocumentOnStartup.setValue(new Boolean(bl));
    }

    public NoYesAsk getSaveFunctionColours() {
        return (NoYesAsk)this.cpSaveFunctionColours.getValue();
    }

    public void setSaveFunctionColours(NoYesAsk noYesAsk) {
        this.cpSaveFunctionColours.setValue(noYesAsk);
    }

    public boolean isShowUnixPathnames() {
        return (Boolean)this.cpShowUnixPathnames.getValue();
    }

    public void setShowUnixPathnames(boolean bl) {
        this.cpShowUnixPathnames.setValue(new Boolean(bl));
    }

    public boolean isShowFullPathnames() {
        return (Boolean)this.cpShowFullPathnames.getValue();
    }

    public void setShowFullPathnames(boolean bl) {
        this.cpShowFullPathnames.setValue(new Boolean(bl));
    }

    public boolean isMainWindowLocation() {
        return this.getMainWindowLocation() != null;
    }

    public Point getMainWindowLocation() {
        return (Point)this.cpMainWindowLocation.getValue();
    }

    public void setMainWindowLocation(Point point) {
        this.cpMainWindowLocation.setValue(point);
    }

    public String getLookAndFeel() {
        return (String)this.cpLookAndFeel.getValue();
    }

    public void setLookAndFeel(String string) {
        this.cpLookAndFeel.setValue(string);
    }

    public boolean isOrientationByLocale() {
        return (Boolean)this.cpOrientationByLocale.getValue();
    }

    public void setOrientationByLocale(boolean bl) {
        this.cpOrientationByLocale.setValue(new Boolean(bl));
    }

    public TextRendering.Antialiasing getTextAntialiasing() {
        return (TextRendering.Antialiasing)this.cpTextAntialiasing.getValue();
    }

    public void setTextAntialiasing(TextRendering.Antialiasing antialiasing) {
        this.cpTextAntialiasing.setValue(antialiasing);
    }

    public boolean isBackgroundColour() {
        return this.cpBackgroundColour.getValue() != null;
    }

    public Color getBackgroundColour() {
        return this.cpBackgroundColour.getColour();
    }

    public void setBackgroundColour(Color color) {
        this.cpBackgroundColour.setValue(color);
    }

    public Dimension getPlotSize() {
        return (Dimension)this.cpPlotSize.getValue();
    }

    public void setPlotSize(Dimension dimension) {
        this.cpPlotSize.setValue(dimension);
    }

    public boolean isShowGrid() {
        return (Boolean)this.cpShowGrid.getValue();
    }

    public void setShowGrid(boolean bl) {
        this.cpShowGrid.setValue(new Boolean(bl));
    }

    public int getNumFractionDigits() {
        return (Integer)this.cpNumFractionDigits.getValue();
    }

    public void setNumFractionDigits(int n) {
        this.cpNumFractionDigits.setValue(new Integer(n));
    }

    public int getNumYScaleDigits() {
        return (Integer)this.cpNumYScaleDigits.getValue();
    }

    public void setNumYScaleDigits(int n) {
        this.cpNumYScaleDigits.setValue(new Integer(n));
    }

    public IntegerRange getFixedPointExponentRange() {
        return (IntegerRange)this.cpFixedPointExponentRange.getValue();
    }

    public void setFixedPointExponentRange(IntegerRange integerRange) {
        this.cpFixedPointExponentRange.setValue(integerRange);
    }

    public boolean isNormaliseScientificNotation() {
        return (Boolean)this.cpNormaliseScientificNotation.getValue();
    }

    public void setNormaliseScientificNotation(boolean bl) {
        this.cpNormaliseScientificNotation.setValue(new Boolean(bl));
    }

    public boolean isTruncateXScaleText() {
        return (Boolean)this.cpTruncateXScaleText.getValue();
    }

    public void setTruncateXScaleText(boolean bl) {
        this.cpTruncateXScaleText.setValue(new Boolean(bl));
    }

    public Color getPlotColourFocusedBorder() {
        return (Color)this.cpPlotColourFocusedBorder.getValue();
    }

    public void setPlotColourFocusedBorder(Color color) {
        this.cpPlotColourFocusedBorder.setValue(color);
    }

    public Color getPlotColourImageMargin() {
        return (Color)this.cpPlotColourImageMargin.getValue();
    }

    public void setPlotColourImageMargin(Color color) {
        this.cpPlotColourImageMargin.setValue(color);
    }

    public Color getPlotColourBackground() {
        return (Color)this.cpPlotColourBackground.getValue();
    }

    public void setPlotColourBackground(Color color) {
        this.cpPlotColourBackground.setValue(color);
    }

    public Color getPlotColourGrid() {
        return (Color)this.cpPlotColourGrid.getValue();
    }

    public void setPlotColourGrid(Color color) {
        this.cpPlotColourGrid.setValue(color);
    }

    public Color getPlotColourAxis() {
        return (Color)this.cpPlotColourAxis.getValue();
    }

    public void setPlotColourAxis(Color color) {
        this.cpPlotColourAxis.setValue(color);
    }

    public Color getPlotColourScale() {
        return (Color)this.cpPlotColourScale.getValue();
    }

    public void setPlotColourScale(Color color) {
        this.cpPlotColourScale.setValue(color);
    }

    public String getFunctionPathname() {
        return (String)this.cpFunctionPathname.getValue();
    }

    public File getFunctionDirectory() {
        return new File(PropertyString.parsePathname(this.getFunctionPathname()));
    }

    public void setFunctionPathname(String string) {
        this.cpFunctionPathname.setValue(string);
    }

    public Dimension getFunctionListSize() {
        return (Dimension)this.cpFunctionListSize.getValue();
    }

    public void setFunctionListSize(Dimension dimension) {
        this.cpFunctionListSize.setValue(dimension);
    }

    public Color getFunctionColour(int n) {
        return (Color)this.cpFunctionColours.getValue(n);
    }

    public void setFunctionColour(int n, Color color) {
        this.cpFunctionColours.setValue(n, color);
    }

    public FontEx getFont(int n) {
        return (FontEx)this.cpFonts.getValue(AppFont.values()[n]);
    }

    public void setFont(int n, FontEx fontEx) {
        this.cpFonts.setValue(AppFont.values()[n], fontEx);
    }

    private AppConfig() {
    }

    public static AppConfig getInstance() {
        if (instance == null) {
            instance = new AppConfig();
        }
        return instance;
    }

    public static void showWarningMessage(AppException appException) {
        App.getInstance().showWarningMessage("FuncPlotter | Configuration Error", appException);
    }

    public static void showErrorMessage(AppException appException) {
        App.getInstance().showErrorMessage("FuncPlotter | Configuration Error", appException);
    }

    private static File getFile() throws AppException {
        File file = null;
        String string = System.getProperty(CONFIG_DIR_KEY);
        if (string == null) {
            file = new File(CONFIG_FILENAME);
            if (!file.isFile()) {
                file = null;
                string = App.getPropertiesPathname();
                if (string != null && !(file = new File(string, CONFIG_FILENAME)).isFile()) {
                    file = null;
                }
            }
        } else if (!string.isEmpty() && !(file = new File(PropertyString.parsePathname(string), CONFIG_FILENAME)).isFile()) {
            throw new FileException((AppException.Id)ErrorId.NO_CONFIGURATION_FILE, file);
        }
        return file;
    }

    private static URL getURL(JApplet jApplet) throws AppException {
        URL uRL = null;
        String string = jApplet.getParameter(CONFIG_DIR_KEY);
        if (string != null) {
            int n = string.length();
            if (n > 0 && string.charAt(n - 1) != '/') {
                string = string + '/';
            }
            try {
                uRL = new URL(jApplet.getCodeBase(), string + CONFIG_FILENAME);
                if (uRL.getProtocol().equals("file")) {
                    String string2 = uRL.getPath();
                    if (string2.equals("/~") || string2.startsWith("/~/")) {
                        string2 = string2.substring(1);
                    }
                    uRL = new URL(uRL.getProtocol(), uRL.getHost(), PropertyString.parsePathname(string2));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new AppException(ErrorId.MALFORMED_URL);
            }
        }
        return uRL;
    }

    public void getPermissions() {
        this.permissionAccessClipboard = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        try {
            securityManager.checkPermission(new AWTPermission("accessClipboard"));
        }
        catch (SecurityException securityException) {
            this.permissionAccessClipboard = false;
        }
    }

    public boolean hasPermissionAccessClipboard() {
        return this.permissionAccessClipboard;
    }

    public File chooseFile(Component component) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogTitle(SAVE_CONFIGURATION_FILE_STR);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.addChoosableFileFilter(new FilenameSuffixFilter(".functionplotter.xml", "XML Files (*.functionplotter.xml)"));
            App.applyOrientationByLocale(this.fileChooser);
            this.selectedFile = this.file;
        }
        this.fileChooser.setSelectedFile(this.selectedFile == null ? new File(CONFIG_FILENAME).getAbsoluteFile() : this.selectedFile.getAbsoluteFile());
        this.fileChooser.rescanCurrentDirectory();
        if (this.fileChooser.showSaveDialog(component) == 0) {
            this.selectedFile = Util.appendSuffix(this.fileChooser.getSelectedFile(), ".functionplotter.xml");
            return this.selectedFile;
        }
        return null;
    }

    public void read(FuncPlotter funcPlotter) {
        Object object;
        this.fileRead = false;
        ConfigFile configFile = null;
        try {
            if (funcPlotter == null) {
                this.file = AppConfig.getFile();
                if (this.file != null) {
                    configFile = new ConfigFile();
                    configFile.read(this.file);
                    this.fileRead = true;
                }
            } else {
                object = AppConfig.getURL(funcPlotter);
                if (object != null) {
                    configFile = new ConfigFile();
                    configFile.read((URL)object);
                    this.fileRead = true;
                }
            }
        }
        catch (AppException appException) {
            AppConfig.showErrorMessage(appException);
        }
        Object object2 = object = funcPlotter == null ? Property.getSystemSource() : funcPlotter;
        if (this.fileRead) {
            this.getProperties(new Property.Source[]{configFile, object});
        } else {
            this.getProperties(new Property.Source[]{object});
        }
        this.resetChanged();
    }

    public void write() {
        if (this.isChanged()) {
            try {
                if (this.file == null) {
                    String string;
                    if (System.getProperty(CONFIG_DIR_KEY) == null && (string = App.getPropertiesPathname()) != null) {
                        File file = new File(string);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        if (!file.isDirectory()) {
                            throw new FileException((AppException.Id)ErrorId.FAILED_TO_CREATE_DIRECTORY, file);
                        }
                        this.file = new File(file, CONFIG_FILENAME);
                    }
                } else if (!this.fileRead) {
                    this.file.renameTo(new File(this.file.getParentFile(), CONFIG_OLD_FILENAME));
                }
                if (this.file != null) {
                    this.write(this.file);
                    this.resetChanged();
                }
            }
            catch (AppException appException) {
                AppConfig.showErrorMessage(appException);
            }
        }
    }

    public void write(File file) throws AppException {
        ProgressView progressView = Operation.getProgressView();
        if (progressView != null) {
            progressView.setInfo(WRITING_STR, file);
            progressView.setProgress(0, -1.0);
        }
        ConfigFile configFile = new ConfigFile(Integer.toString(0));
        this.putProperties(configFile);
        configFile.write(file);
    }

    private void getProperties(Property.Source ... sourceArray) {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (!field.getName().startsWith("cp")) continue;
                try {
                    ((Property)field.get(this)).get(sourceArray);
                }
                catch (AppException appException) {
                    AppConfig.showWarningMessage(appException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private void putProperties(Property.Target target) {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (!field.getName().startsWith("cp")) continue;
                ((Property)field.get(this)).put(target);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private boolean isChanged() {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (!field.getName().startsWith("cp") || !((Property)field.get(this)).isChanged()) continue;
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return false;
    }

    private void resetChanged() {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (!field.getName().startsWith("cp")) continue;
                ((Property)field.get(this)).setChanged(false);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private class CPFonts
    extends Property.PropertyMap<AppFont, FontEx> {
        private static final int DEFAULT_PLOT_FONT_SIZE = 10;

        private CPFonts() {
            super("font", AppFont.class);
            for (AppFont appFont : AppFont.values()) {
                this.values.put(appFont, new FontEx());
            }
            ((FontEx)this.values.get(AppFont.PLOT)).setSize(10);
        }

        @Override
        public void parse(Property.Input input, AppFont appFont) {
            try {
                FontEx fontEx = new FontEx(input.getValue());
                appFont.setFontEx(fontEx);
                this.values.put(appFont, fontEx);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AppConfig.showWarningMessage(new Property.IllegalValueException(input));
            }
            catch (ValueOutOfBoundsException valueOutOfBoundsException) {
                AppConfig.showWarningMessage(new Property.ValueOutOfBoundsException(input));
            }
        }

        @Override
        public String toString(AppFont appFont) {
            return ((FontEx)this.getValue(appFont)).toString();
        }
    }

    private class CPFunctionColours
    extends Property.PropertyList<Color> {
        private static final int NUM_COLOURS = 20;

        private CPFunctionColours() {
            super("function.colour", 20);
            for (int i = 0; i < 20; ++i) {
                this.values.add(DEFAULT_COLOURS[i % DEFAULT_COLOURS.length]);
            }
        }

        @Override
        protected void parse(Property.Input input, int n) {
            try {
                this.values.set(n, input.parseColour());
            }
            catch (AppException appException) {
                AppConfig.showWarningMessage(appException);
            }
        }

        @Override
        protected String toString(int n) {
            return ColourUtilities.colourToRgbString((Color)this.values.get(n));
        }
    }

    private class CPFunctionListSize
    extends Property.SimpleProperty<Dimension> {
        private CPFunctionListSize() {
            super("function.listSize");
            this.value = new Dimension(32, 12);
        }

        @Override
        public void parse(Property.Input input) throws AppException {
            IntegerRange[] integerRangeArray = new IntegerRange[]{new IntegerRange(8, 80), new IntegerRange(1, 20)};
            int[] nArray = input.parseIntegers(2, integerRangeArray);
            this.value = new Dimension(nArray[0], nArray[1]);
        }

        @Override
        public String toString() {
            return ((Dimension)this.value).width + ", " + ((Dimension)this.value).height;
        }
    }

    private class CPFunctionPathname
    extends Property.StringProperty {
        private CPFunctionPathname() {
            super("function.directory");
            this.value = "~";
        }
    }

    private class CPPlotColourScale
    extends Property.ColourProperty {
        private CPPlotColourScale() {
            super("plot.colour.scale");
            this.value = Color.BLACK;
        }
    }

    private class CPPlotColourAxis
    extends Property.ColourProperty {
        private CPPlotColourAxis() {
            super("plot.colour.axis");
            this.value = new Color(144, 144, 144);
        }
    }

    private class CPPlotColourGrid
    extends Property.ColourProperty {
        private CPPlotColourGrid() {
            super("plot.colour.grid");
            this.value = new Color(216, 216, 216);
        }
    }

    private class CPPlotColourBackground
    extends Property.ColourProperty {
        private CPPlotColourBackground() {
            super("plot.colour.background");
            this.value = new Color(248, 248, 240);
        }
    }

    private class CPPlotColourImageMargin
    extends Property.ColourProperty {
        private CPPlotColourImageMargin() {
            super("plot.colour.imageMargin");
            this.value = new Color(232, 232, 224);
        }
    }

    private class CPPlotColourFocusedBorder
    extends Property.ColourProperty {
        private CPPlotColourFocusedBorder() {
            super("plot.colour.focusedBorder");
            this.value = new Color(160, 128, 128);
        }
    }

    private class CPTruncateXScaleText
    extends Property.BooleanProperty {
        private CPTruncateXScaleText() {
            super("plot.truncateXScaleText");
            this.value = Boolean.TRUE;
        }
    }

    private class CPNormaliseScientificNotation
    extends Property.BooleanProperty {
        private CPNormaliseScientificNotation() {
            super("plot.normaliseScientificNotation");
            this.value = Boolean.TRUE;
        }
    }

    private class CPFixedPointExponentRange
    extends Property.SimpleProperty<IntegerRange> {
        private CPFixedPointExponentRange() {
            super("plot.fixedPointExponentRange");
            this.value = new IntegerRange(-3, 6);
        }

        @Override
        public void parse(Property.Input input) throws AppException {
            IntegerRange[] integerRangeArray = new IntegerRange[]{new IntegerRange(-12, 12), new IntegerRange(-12, 12)};
            int[] nArray = input.parseIntegers(2, integerRangeArray, Property.Order.GREATER_THAN_OR_EQUAL_TO);
            this.value = new IntegerRange(nArray[0], nArray[1]);
        }

        @Override
        public String toString() {
            return ((IntegerRange)this.value).toString();
        }
    }

    private class CPNumYScaleDigits
    extends Property.IntegerProperty {
        private CPNumYScaleDigits() {
            super("plot.numYScaleDigits", 4, 20);
            this.value = new Integer(8);
        }
    }

    private class CPNumFractionDigits
    extends Property.IntegerProperty {
        private CPNumFractionDigits() {
            super("plot.numFractionDigits", 1, 12);
            this.value = new Integer(5);
        }
    }

    private class CPShowGrid
    extends Property.BooleanProperty {
        private CPShowGrid() {
            super("plot.showGrid");
            this.value = Boolean.TRUE;
        }
    }

    private class CPPlotSize
    extends Property.SimpleProperty<Dimension> {
        private CPPlotSize() {
            super("plot.size");
            this.value = new Dimension(480, 480);
        }

        @Override
        public void parse(Property.Input input) throws AppException {
            IntegerRange[] integerRangeArray = new IntegerRange[]{new IntegerRange(128, 2048), new IntegerRange(128, 2048)};
            int[] nArray = input.parseIntegers(2, integerRangeArray);
            this.value = new Dimension(nArray[0], nArray[1]);
        }

        @Override
        public String toString() {
            return ((Dimension)this.value).width + ", " + ((Dimension)this.value).height;
        }
    }

    private class CPBackgroundColour
    extends Property.SimpleProperty<Color> {
        private static final String PANEL_BACKGROUND_COLOUR_KEY = "Panel.background";

        private CPBackgroundColour() {
            super("appearance.backgroundColour");
        }

        @Override
        public void parse(Property.Input input) throws AppException {
            if (!input.getValue().isEmpty()) {
                this.value = input.parseColour();
            }
        }

        @Override
        public String toString() {
            return this.value == null ? new String() : ColourUtilities.colourToRgbString((Color)this.value);
        }

        private Color getColour() {
            Color color = (Color)this.value;
            if (color == null && (color = UIManager.getColor(PANEL_BACKGROUND_COLOUR_KEY)) == null) {
                color = DEFAULT_BACKGROUND_COLOUR;
            }
            return color;
        }
    }

    private class CPTextAntialiasing
    extends Property.EnumProperty<TextRendering.Antialiasing> {
        private CPTextAntialiasing() {
            super("appearance.textAntialiasing", TextRendering.Antialiasing.class);
            this.value = TextRendering.Antialiasing.DEFAULT;
        }
    }

    private class CPOrientationByLocale
    extends Property.BooleanProperty {
        private CPOrientationByLocale() {
            super("appearance.orientationByLocale");
            this.value = Boolean.FALSE;
        }
    }

    private class CPLookAndFeel
    extends Property.StringProperty {
        private CPLookAndFeel() {
            super("appearance.lookAndFeel");
            this.value = new String();
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!lookAndFeelInfo.getClassName().equals(UIManager.getCrossPlatformLookAndFeelClassName())) continue;
                this.value = lookAndFeelInfo.getName();
                break;
            }
        }
    }

    private class CPMainWindowLocation
    extends Property.SimpleProperty<Point> {
        private CPMainWindowLocation() {
            super("general.mainWindowLocation");
            this.value = new Point();
        }

        @Override
        public void parse(Property.Input input) throws AppException {
            if (!input.getValue().isEmpty()) {
                int[] nArray = input.parseIntegers(2, null);
                this.value = new Point(nArray[0], nArray[1]);
            }
        }

        @Override
        public String toString() {
            return this.value == null ? new String() : ((Point)this.value).x + ", " + ((Point)this.value).y;
        }
    }

    private class CPShowFullPathnames
    extends Property.BooleanProperty {
        private CPShowFullPathnames() {
            super("general.showFullPathnames");
            this.value = Boolean.FALSE;
        }
    }

    private class CPShowUnixPathnames
    extends Property.BooleanProperty {
        private CPShowUnixPathnames() {
            super("general.showUnixPathnames");
            this.value = Boolean.FALSE;
        }
    }

    private class CPSaveFunctionColours
    extends Property.EnumProperty<NoYesAsk> {
        private CPSaveFunctionColours() {
            super("general.saveFunctionColours", NoYesAsk.class);
            this.value = NoYesAsk.YES;
        }
    }

    private class CPNewDocumentOnStartup
    extends Property.BooleanProperty {
        private CPNewDocumentOnStartup() {
            super("general.newDocumentOnStartup");
            this.value = Boolean.FALSE;
        }
    }

    private class CPDefaultFileKind
    extends Property.EnumProperty<FileKind> {
        private CPDefaultFileKind() {
            super("general.defaultFileType", FileKind.class);
            this.value = FileKind.XML;
        }
    }

    private static class ConfigFile
    extends PropertySet {
        private static final String CONFIG_FILE1_STR = "configuration file";
        private static final String CONFIG_FILE2_STR = "Configuration file";

        private ConfigFile() {
        }

        private ConfigFile(String string) throws AppException {
            super("funcPlotterConfiguration", null, string);
        }

        @Override
        public String getSourceName() {
            return CONFIG_FILE2_STR;
        }

        @Override
        protected String getFileKindString() {
            return CONFIG_FILE1_STR;
        }

        public void read(File file) throws AppException {
            this.read(file, "funcPlotterConfiguration");
            try {
                this.validateVersion();
            }
            catch (AppException appException) {
                throw new FileException(appException, file);
            }
        }

        public void read(URL uRL) throws AppException {
            this.read(uRL, "funcPlotterConfiguration");
            try {
                this.validateVersion();
            }
            catch (AppException appException) {
                throw new UrlException(appException, uRL);
            }
        }

        private void validateVersion() throws AppException {
            String string = this.getVersionString();
            if (string == null) {
                throw new AppException(ErrorId.NO_VERSION_NUMBER);
            }
            try {
                int n = Integer.parseInt(string);
                if (n < 0 || n > 0) {
                    String[] stringArray = new String[]{string};
                    throw new AppException((AppException.Id)ErrorId.INCOMPATIBLE_CONFIGURATION_FILE, stringArray);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new AppException(ErrorId.INVALID_VERSION_NUMBER);
            }
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        NO_CONFIGURATION_FILE("No configuration file was found on the configuration path."),
        MALFORMED_URL("The pathname of the configuration file is malformed."),
        NO_VERSION_NUMBER("The configuration file does not have a version number."),
        INVALID_VERSION_NUMBER("The version number of the configuration file is invalid."),
        INCOMPATIBLE_CONFIGURATION_FILE("The version of the configuration file (%1) is incompatible with this version of FuncPlotter."),
        FAILED_TO_CREATE_DIRECTORY("Failed to create the directory for the configuration file.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface Key {
        public static final String APPEARANCE = "appearance";
        public static final String AXIS = "axis";
        public static final String BACKGROUND = "background";
        public static final String BACKGROUND_COLOUR = "backgroundColour";
        public static final String COLOUR = "colour";
        public static final String CONFIGURATION = "funcPlotterConfiguration";
        public static final String DEFAULT_FILE_TYPE = "defaultFileType";
        public static final String DIRECTORY = "directory";
        public static final String FIXED_POINT_EXPONENT_RANGE = "fixedPointExponentRange";
        public static final String FOCUSED_BORDER = "focusedBorder";
        public static final String FONT = "font";
        public static final String FUNCTION = "function";
        public static final String GENERAL = "general";
        public static final String GRID = "grid";
        public static final String IMAGE_MARGIN = "imageMargin";
        public static final String LIST_SIZE = "listSize";
        public static final String LOOK_AND_FEEL = "lookAndFeel";
        public static final String MAIN_WINDOW_LOCATION = "mainWindowLocation";
        public static final String NEW_DOCUMENT_ON_STARTUP = "newDocumentOnStartup";
        public static final String NORMALISE_SCIENTIFIC_NOTATION = "normaliseScientificNotation";
        public static final String NUM_FRACTION_DIGITS = "numFractionDigits";
        public static final String NUM_Y_SCALE_DIGITS = "numYScaleDigits";
        public static final String ORIENTATION_BY_LOCALE = "orientationByLocale";
        public static final String PLOT = "plot";
        public static final String SAVE_FUNCTION_COLOURS = "saveFunctionColours";
        public static final String SCALE = "scale";
        public static final String SHOW_FULL_PATHNAMES = "showFullPathnames";
        public static final String SHOW_GRID = "showGrid";
        public static final String SHOW_UNIX_PATHNAMES = "showUnixPathnames";
        public static final String SIZE = "size";
        public static final String TEXT_ANTIALIASING = "textAntialiasing";
        public static final String TRUNCATE_X_SCALE_TEXT = "truncateXScaleText";
    }
}

