/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.AppCommand;
import functionplotter.AppConfig;
import functionplotter.AppConstants;
import functionplotter.ErrorListDialog;
import functionplotter.FileKind;
import functionplotter.FuncPlotter;
import functionplotter.FunctionDocument;
import functionplotter.FunctionView;
import functionplotter.ListSelectionDialog;
import functionplotter.MainWindow;
import functionplotter.Operation;
import functionplotter.OperationDialog;
import functionplotter.PreferencesDialog;
import functionplotter.Util;
import functionplotter.exception.AppException;
import functionplotter.exception.ExceptionUtilities;
import functionplotter.exception.TerminatedException;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.TextRendering;
import functionplotter.util.CalendarTime;
import functionplotter.util.FilenameSuffixFilter;
import functionplotter.util.NoYes;
import functionplotter.util.PropertiesPathname;
import functionplotter.util.ResourceProperties;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class App {
    public static final String SHORT_NAME = "FuncPlotter";
    public static final String LONG_NAME = "Function Plotter";
    public static final String NAME_KEY = "funcPlotter";
    public static final int MAX_NUM_DOCUMENTS = 64;
    private static final int FILE_CHECK_TIMER_INTERVAL = 500;
    private static final String DEBUG_PROPERTY_KEY = "app.debug";
    private static final String VERSION_PROPERTY_KEY = "version";
    private static final String BUILD_PROPERTY_KEY = "build";
    private static final String RELEASE_PROPERTY_KEY = "release";
    private static final String STARTUP_PARAM_KEY = "app.startup";
    private static final String BUILD_PROPERTIES_PATHNAME = "resources/build.properties";
    private static final String DEBUG_STR = " Debug";
    private static final String DIMENSIONS_ERROR_STR = "The applet dimensions are too small.";
    private static final String CONFIG_ERROR_STR = "Configuration Error";
    private static final String LAF_ERROR1_STR = "Look-and-feel: ";
    private static final String LAF_ERROR2_STR = "\nThe look-and-feel is not installed.";
    private static final String APPLET_STR = "Applet: ";
    private static final String MINIMUM_DIMENSIONS_STR = "The minimum dimensions of the applet are ";
    private static final String WIDTH_STR = "(width)";
    private static final String HEIGHT_STR = "(height)";
    private static final String OPEN_FILE_STR = "Open File";
    private static final String RELOAD_FILE_STR = "Reload File";
    private static final String SAVE_FILE_STR = "Save File";
    private static final String SAVE_FILE_AS_STR = "Save File As";
    private static final String SAVE_CLOSE_FILE_STR = "Save File Before Closing";
    private static final String EXPORT_IMAGE_STR = "Export Image";
    private static final String MODIFIED_FILE_STR = "Modified File";
    private static final String OPEN_FUNCTION_FILE_STR = "Open Function File";
    private static final String SAVE_FUNCTION_FILE_STR = "Save Function File";
    private static final String EXPORT_IMAGE_FILE_STR = "Export Image File";
    private static final String COPY_INTERVALS_STR = "Copy Intervals to Other Documents";
    private static final String DOCUMENTS_STR = "Documents:";
    private static final String ERRORS_STR = "Errors in File";
    private static final String WRITE_IMAGE_STR = "Write Image";
    private static final String READ_DOCUMENT_STR = "Read Document";
    private static final String WRITE_DOCUMENT_STR = "Write Document";
    private static final String UNNAMED_FILE_STR = "The unnamed file";
    private static final String FILE_STR = "\nThe file";
    private static final String MODIFIED_MESSAGE_STR = "\nThe file has been modified externally.\nDo you want to open the modified file?";
    private static final String RELOAD_MESSAGE_STR = "\nDo you want discard the changes to the current document and reload the original file?";
    private static final String CHANGED_MESSAGE_STR = " has changed.\nDo you want to save the changed file?";
    private static final String SAVE_COLOURS_STR = "Do you want to save the colours of the functions?";
    private static final String HAS_COMMENTS_STR = "The document contains comments that will be lost if the document is saved.";
    private static final String[] CC_OPTION_STRS = new String[]{"Continue", "Cancel"};
    private static final String[] LC_OPTION_STRS = new String[]{"Reload", "Cancel"};
    private static final String[] SDC_OPTION_STRS = new String[]{"Save", "Discard", "Cancel"};
    private static App instance;
    private static boolean debug;
    private ResourceProperties buildProperties;
    private boolean isApplet;
    private MainWindow mainWindow;
    private List<DocumentView> documentsViews;
    private JFileChooser openFileChooser;
    private JFileChooser saveFileChooser;
    private JFileChooser exportFileChooser;
    private File exportFile;
    private int newFileIndex;
    private boolean exiting;

    public static void main(String[] stringArray) {
        App.getInstance().init(stringArray, null);
    }

    public static App getInstance() {
        if (instance == null) {
            instance = new App();
        }
        return instance;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static String getPropertiesPathname() {
        String string = PropertiesPathname.getPathname();
        if (string != null) {
            string = string + NAME_KEY.toLowerCase();
        }
        return string;
    }

    public static void applyOrientationByLocale(Component component) {
        if (AppConfig.getInstance().isOrientationByLocale()) {
            component.applyComponentOrientation(ComponentOrientation.getOrientation(component.getLocale()));
        }
    }

    public static boolean isLeftToRight() {
        return !AppConfig.getInstance().isOrientationByLocale() || ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight();
    }

    public static String getPathname(File file) {
        return Util.getPathname(file, AppConfig.getInstance().isShowUnixPathnames());
    }

    public static char getFileSeparatorChar() {
        return AppConfig.getInstance().isShowUnixPathnames() ? (char)'/' : (char)File.separatorChar;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public int getNumDocuments() {
        return this.documentsViews.size();
    }

    public boolean hasDocuments() {
        return !this.documentsViews.isEmpty();
    }

    public boolean isDocumentsFull() {
        return this.documentsViews.size() >= 64;
    }

    public FunctionDocument getDocument() {
        return this.isApplet ? this.getDocument(0) : (this.hasDocuments() ? this.getDocument(this.mainWindow.getTabIndex()) : null);
    }

    public FunctionDocument getDocument(int n) {
        return this.hasDocuments() ? this.documentsViews.get((int)n).document : null;
    }

    public FunctionView getView() {
        return this.isApplet ? this.getView(0) : (this.hasDocuments() ? this.getView(this.mainWindow.getTabIndex()) : null);
    }

    public FunctionView getView(int n) {
        return this.hasDocuments() ? this.documentsViews.get((int)n).view : null;
    }

    public FunctionView getView(FunctionDocument functionDocument) {
        for (DocumentView documentView : this.documentsViews) {
            if (documentView.document != functionDocument) continue;
            return documentView.view;
        }
        return null;
    }

    public String getVersionString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        String string = this.buildProperties.get(VERSION_PROPERTY_KEY);
        if (string != null) {
            stringBuilder.append(string);
        }
        if ((string = this.buildProperties.get(RELEASE_PROPERTY_KEY)) == null) {
            long l = System.currentTimeMillis();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('b');
            stringBuilder.append(CalendarTime.dateToString(l));
            stringBuilder.append('-');
            stringBuilder.append(CalendarTime.hoursMinsToString(l));
        } else {
            NoYes noYes = NoYes.get(string);
            if (!(noYes != null && noYes.toBoolean() || (string = this.buildProperties.get(BUILD_PROPERTY_KEY)) == null)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
            }
        }
        if (debug) {
            stringBuilder.append(DEBUG_STR);
        }
        return stringBuilder.toString();
    }

    public String getTitleString() {
        return "Function Plotter " + this.getVersionString();
    }

    public void init(String[] stringArray, FuncPlotter funcPlotter) {
        this.isApplet = funcPlotter != null;
        this.documentsViews = new ArrayList<DocumentView>();
        debug = this.isApplet ? funcPlotter.getParameter(DEBUG_PROPERTY_KEY) != null : System.getProperty(DEBUG_PROPERTY_KEY) != null;
        this.buildProperties = new ResourceProperties(BUILD_PROPERTIES_PATHNAME, this.getClass());
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.getPermissions();
        ExceptionUtilities.setUnixStyle(appConfig.isShowUnixPathnames());
        TextRendering.setAntialiasing(appConfig.getTextAntialiasing());
        String string = appConfig.getLookAndFeel();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getName().equals(string)) continue;
            try {
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = null;
            break;
        }
        if (string != null) {
            this.showWarningMessage("FuncPlotter | Configuration Error", LAF_ERROR1_STR + string + LAF_ERROR2_STR);
        }
        if (this.isApplet) {
            this.documentsViews.add(new DocumentView(new FunctionDocument()));
            SwingUtilities.invokeLater(new DoAppletInitialisation(funcPlotter));
        } else {
            this.mainWindow = new MainWindow();
            SwingUtilities.invokeLater(new DoAppInitialisation(stringArray));
        }
    }

    public void showWarningMessage(String string, Object object) {
        this.showMessageDialog(string, object, 2);
    }

    public void showErrorMessage(String string, Object object) {
        this.showMessageDialog(string, object, 0);
    }

    public void showMessageDialog(String string, Object object, int n) {
        JDialog jDialog = new JOptionPane(object, n).createDialog(this.mainWindow, string);
        App.applyOrientationByLocale(jDialog);
        jDialog.setVisible(true);
    }

    public boolean confirmWriteFile(File file, String string) {
        return !file.exists() || JOptionPane.showOptionDialog(this.mainWindow, App.getPathname(file) + "\nThe file already exists.\nDo you want to replace it?", string, 2, 2, null, AppConstants.RC_OPTION_STRS, AppConstants.RC_OPTION_STRS[1]) == 0;
    }

    public void updateTabText(FunctionDocument functionDocument) {
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            if (this.getDocument(i) != functionDocument) continue;
            this.mainWindow.setTabText(i, functionDocument.getTitleString(false), functionDocument.getTitleString(true));
            break;
        }
    }

    public void updateCommands() {
        FunctionDocument functionDocument = this.getDocument();
        boolean bl = functionDocument != null;
        boolean bl2 = !this.isDocumentsFull();
        AppCommand.IMPORT_FILES.setEnabled(true);
        AppCommand.CHECK_MODIFIED_FILE.setEnabled(true);
        AppCommand.NEW_FILE.setEnabled(bl2);
        AppCommand.OPEN_FILE.setEnabled(bl2);
        AppCommand.RELOAD_FILE.setEnabled(bl && functionDocument.isChanged() && functionDocument.getFile() != null);
        AppCommand.CLOSE_FILE.setEnabled(bl);
        AppCommand.CLOSE_ALL_FILES.setEnabled(bl);
        AppCommand.SAVE_FILE.setEnabled(bl && functionDocument.isChanged());
        AppCommand.SAVE_FILE_AS.setEnabled(bl);
        AppCommand.EXPORT_IMAGE.setEnabled(bl && FunctionDocument.canWriteImages());
        AppCommand.EXIT.setEnabled(true);
        AppCommand.COPY_INTERVALS.setEnabled(this.getNumDocuments() > 1);
        AppCommand.EDIT_PREFERENCES.setEnabled(true);
        AppCommand.SHOW_FULL_PATHNAMES.setEnabled(true);
        AppCommand.SHOW_FULL_PATHNAMES.setSelected(AppConfig.getInstance().isShowFullPathnames());
    }

    public void executeCommand(AppCommand appCommand) {
        try {
            switch (appCommand) {
                case IMPORT_FILES: {
                    this.doImportFiles();
                    break;
                }
                case CHECK_MODIFIED_FILE: {
                    this.doCheckModifiedFile();
                    break;
                }
                case NEW_FILE: {
                    this.doNewFile();
                    break;
                }
                case OPEN_FILE: {
                    this.doOpenFile();
                    break;
                }
                case RELOAD_FILE: {
                    this.doReloadFile();
                    break;
                }
                case CLOSE_FILE: {
                    this.doCloseFile();
                    break;
                }
                case CLOSE_ALL_FILES: {
                    this.doCloseAllFiles();
                    break;
                }
                case SAVE_FILE: {
                    this.doSaveFile();
                    break;
                }
                case SAVE_FILE_AS: {
                    this.doSaveFileAs();
                    break;
                }
                case EXPORT_IMAGE: {
                    this.doExportImage();
                    break;
                }
                case EXIT: {
                    this.doExit();
                    break;
                }
                case COPY_INTERVALS: {
                    this.doCopyIntervals();
                    break;
                }
                case EDIT_PREFERENCES: {
                    this.doEditPreferences();
                    break;
                }
                case SHOW_FULL_PATHNAMES: {
                    this.doShowFullPathnames();
                }
            }
        }
        catch (AppException appException) {
            this.showErrorMessage(SHORT_NAME, appException);
        }
        if (appCommand != AppCommand.CHECK_MODIFIED_FILE) {
            this.updateTabText(this.getDocument());
            this.mainWindow.updateTitleAndMenus();
        }
    }

    public void closeDocument(int n) {
        if (this.confirmCloseDocument(n)) {
            this.removeDocument(n);
        }
    }

    private void addDocument(FunctionDocument functionDocument) {
        DocumentView documentView = new DocumentView(functionDocument);
        this.documentsViews.add(documentView);
        this.mainWindow.addView(functionDocument.getTitleString(false), functionDocument.getTitleString(true), documentView.view);
    }

    private void removeDocument(int n) {
        this.documentsViews.remove(n);
        this.mainWindow.removeView(n);
    }

    private boolean readDocument(FunctionDocument functionDocument, File file) throws AppException {
        boolean bl = false;
        try {
            Vector<String> vector = new Vector<String>();
            OperationDialog.showDialog(this.mainWindow, READ_DOCUMENT_STR, new Operation.ReadDocument(functionDocument, file, vector));
            if (vector.isEmpty()) {
                bl = true;
            } else {
                ErrorListDialog.showDialog(this.mainWindow, ERRORS_STR, App.getPathname(file), vector);
            }
        }
        catch (TerminatedException terminatedException) {
            // empty catch block
        }
        return bl;
    }

    private void writeDocument(FunctionDocument functionDocument, FunctionDocument.FileEx fileEx, boolean bl) throws AppException {
        OperationDialog.showDialog(this.mainWindow, WRITE_DOCUMENT_STR, new Operation.WriteDocument(functionDocument, fileEx, bl));
    }

    private void openDocument(File file) throws AppException {
        for (int i = 0; i < this.documentsViews.size(); ++i) {
            if (!Util.isSameFile(file, this.getDocument(i).getFile())) continue;
            this.mainWindow.selectView(i);
            return;
        }
        FunctionDocument functionDocument = new FunctionDocument();
        if (this.readDocument(functionDocument, file)) {
            this.addDocument(functionDocument);
            this.warnComments(functionDocument);
        }
    }

    private void reloadDocument(File file) throws AppException {
        FunctionDocument functionDocument = new FunctionDocument();
        if (this.readDocument(functionDocument, file)) {
            int n = this.mainWindow.getTabIndex();
            this.documentsViews.set(n, new DocumentView(functionDocument));
            this.mainWindow.setTabText(n, functionDocument.getTitleString(false), functionDocument.getTitleString(true));
            this.mainWindow.setView(n, this.getView());
            this.warnComments(functionDocument);
        }
    }

    private boolean confirmCloseDocument(int n) {
        FunctionDocument functionDocument = this.getDocument(n);
        if (!functionDocument.isChanged()) {
            return true;
        }
        this.mainWindow.selectView(n);
        FunctionDocument.FileEx fileEx = functionDocument.getFileEx();
        String string = (fileEx.file == null ? UNNAMED_FILE_STR : App.getPathname(fileEx.file) + FILE_STR) + CHANGED_MESSAGE_STR;
        int n2 = JOptionPane.showOptionDialog(this.mainWindow, string, SAVE_CLOSE_FILE_STR, 1, 3, null, SDC_OPTION_STRS, SDC_OPTION_STRS[0]);
        if (n2 == 1) {
            return true;
        }
        if (n2 == 0) {
            if (fileEx.file == null) {
                try {
                    fileEx = this.chooseSave(null, fileEx.fileKind);
                }
                catch (AppException appException) {
                    this.showErrorMessage(SAVE_CLOSE_FILE_STR, appException);
                }
                if (fileEx == null) {
                    return false;
                }
                if (fileEx.file.exists()) {
                    string = App.getPathname(fileEx.file) + "\nThe file already exists.\nDo you want to replace it?";
                    n2 = JOptionPane.showConfirmDialog(this.mainWindow, string, SAVE_CLOSE_FILE_STR, 1, 2);
                    if (n2 == 1) {
                        return true;
                    }
                    if (n2 != 0) {
                        return false;
                    }
                }
            }
            try {
                IncludeColours includeColours = this.confirmIncludeColours(functionDocument, SAVE_CLOSE_FILE_STR);
                if (includeColours == null) {
                    return false;
                }
                this.writeDocument(functionDocument, fileEx, includeColours == IncludeColours.YES);
                return true;
            }
            catch (AppException appException) {
                this.showErrorMessage(SAVE_CLOSE_FILE_STR, appException);
            }
        }
        return false;
    }

    private File chooseOpen() throws AppException {
        if (this.openFileChooser == null) {
            try {
                this.openFileChooser = new JFileChooser(AppConfig.getInstance().getFunctionDirectory());
                this.openFileChooser.setDialogTitle(OPEN_FUNCTION_FILE_STR);
                this.openFileChooser.setFileSelectionMode(0);
                this.openFileChooser.addChoosableFileFilter(FileKind.XML.getFilter());
                this.openFileChooser.addChoosableFileFilter(FileKind.TEXT.getFilter());
                this.openFileChooser.setFileFilter(AppConfig.getInstance().getDefaultFileKind().getFilter());
                App.applyOrientationByLocale(this.openFileChooser);
            }
            catch (SecurityException securityException) {
                throw new AppException(ErrorId.NO_FILE_CHOOSER);
            }
        }
        this.openFileChooser.rescanCurrentDirectory();
        return this.openFileChooser.showOpenDialog(this.mainWindow) == 0 ? this.openFileChooser.getSelectedFile() : null;
    }

    private FunctionDocument.FileEx chooseSave(File file, FileKind fileKind) throws AppException {
        if (this.saveFileChooser == null) {
            try {
                this.saveFileChooser = new JFileChooser(AppConfig.getInstance().getFunctionDirectory());
                this.saveFileChooser.setDialogTitle(SAVE_FUNCTION_FILE_STR);
                this.saveFileChooser.setFileSelectionMode(0);
                this.saveFileChooser.addChoosableFileFilter(FileKind.XML.getFilter());
                this.saveFileChooser.addChoosableFileFilter(FileKind.TEXT.getFilter());
                App.applyOrientationByLocale(this.saveFileChooser);
            }
            catch (SecurityException securityException) {
                throw new AppException(ErrorId.NO_FILE_CHOOSER);
            }
        }
        FunctionDocument.FileEx fileEx = null;
        if (file != null) {
            this.saveFileChooser.setSelectedFile(file.getAbsoluteFile());
        }
        this.saveFileChooser.rescanCurrentDirectory();
        this.saveFileChooser.setFileFilter(fileKind.getFilter());
        if (this.saveFileChooser.showSaveDialog(this.mainWindow) == 0) {
            fileEx = new FunctionDocument.FileEx(this.saveFileChooser.getSelectedFile(), null);
            if (this.saveFileChooser.getFileFilter() instanceof FilenameSuffixFilter) {
                fileEx.fileKind = FileKind.get((FilenameSuffixFilter)this.saveFileChooser.getFileFilter());
                if (fileEx.fileKind != null) {
                    fileEx.file = Util.appendSuffix(fileEx.file, fileEx.fileKind.getFilter().getSuffix(0));
                }
            }
        }
        return fileEx;
    }

    private File chooseExport() throws AppException {
        if (this.exportFileChooser == null) {
            try {
                this.exportFileChooser = new JFileChooser(AppConfig.getInstance().getFunctionDirectory());
                this.exportFileChooser.setDialogTitle(EXPORT_IMAGE_FILE_STR);
                this.exportFileChooser.setFileSelectionMode(0);
                this.exportFileChooser.addChoosableFileFilter(new FilenameSuffixFilter(".png", "Portable Network Graphics Files (*.png)"));
                App.applyOrientationByLocale(this.exportFileChooser);
            }
            catch (SecurityException securityException) {
                throw new AppException(ErrorId.NO_FILE_CHOOSER);
            }
        }
        if (this.exportFile != null) {
            this.exportFileChooser.setSelectedFile(this.exportFile.getAbsoluteFile());
        }
        this.exportFileChooser.rescanCurrentDirectory();
        if (this.exportFileChooser.showSaveDialog(this.mainWindow) == 0) {
            this.exportFile = Util.appendSuffix(this.exportFileChooser.getSelectedFile(), ".png");
            return this.exportFile;
        }
        return null;
    }

    private void warnComments(FunctionDocument functionDocument) {
        if (functionDocument.hasComments()) {
            JOptionPane.showMessageDialog(this.mainWindow, HAS_COMMENTS_STR, OPEN_FILE_STR, 2);
        }
    }

    private IncludeColours confirmIncludeColours(FunctionDocument functionDocument, String string) {
        if (!functionDocument.hasFunctions()) {
            return IncludeColours.NO;
        }
        switch (AppConfig.getInstance().getSaveFunctionColours()) {
            case NO: {
                return IncludeColours.NO;
            }
            case YES: {
                return IncludeColours.YES;
            }
            case ASK: {
                switch (JOptionPane.showConfirmDialog(this.mainWindow, SAVE_COLOURS_STR, string, 1, 3)) {
                    case 0: {
                        return IncludeColours.YES;
                    }
                    case 1: {
                        return IncludeColours.NO;
                    }
                }
            }
        }
        return null;
    }

    private void openFiles(File[] fileArray) {
        for (int i = 0; i < fileArray.length && !this.isDocumentsFull(); ++i) {
            try {
                this.openDocument(fileArray[i]);
                if (!Operation.isTerminated()) continue;
            }
            catch (AppException appException) {
                if (i == fileArray.length - 1) {
                    this.showErrorMessage(OPEN_FILE_STR, appException);
                    continue;
                }
                if (JOptionPane.showOptionDialog(this.mainWindow, appException, OPEN_FILE_STR, 2, 0, null, CC_OPTION_STRS, CC_OPTION_STRS[1]) == 0) continue;
            }
            break;
        }
    }

    private void doImportFiles() {
        this.openFiles((File[])AppCommand.IMPORT_FILES.getValue("files"));
    }

    private void doCheckModifiedFile() throws AppException {
        FunctionDocument functionDocument = this.getDocument();
        if (functionDocument != null && !functionDocument.isExecutingCommand()) {
            long l;
            File file = functionDocument.getFile();
            long l2 = functionDocument.getTimestamp();
            if (file != null && l2 != 0L && (l = file.lastModified()) != 0L && l != l2) {
                String string = App.getPathname(file) + MODIFIED_MESSAGE_STR;
                if (JOptionPane.showConfirmDialog(this.mainWindow, string, MODIFIED_FILE_STR, 0, 3) == 0) {
                    this.reloadDocument(file);
                    this.mainWindow.updateTitleAndMenus();
                } else {
                    functionDocument.setTimestamp(l);
                }
            }
        }
    }

    public void doNewFile() {
        if (!this.isDocumentsFull()) {
            this.addDocument(new FunctionDocument(++this.newFileIndex));
        }
    }

    private void doOpenFile() throws AppException {
        File file;
        if (!this.isDocumentsFull() && (file = this.chooseOpen()) != null) {
            this.openDocument(file);
        }
    }

    private void doReloadFile() throws AppException {
        String string;
        File file;
        FunctionDocument functionDocument = this.getDocument();
        if (functionDocument != null && functionDocument.isChanged() && (file = functionDocument.getFile()) != null && JOptionPane.showOptionDialog(this.mainWindow, string = App.getPathname(file) + RELOAD_MESSAGE_STR, RELOAD_FILE_STR, 2, 3, null, LC_OPTION_STRS, LC_OPTION_STRS[1]) == 0) {
            this.reloadDocument(file);
        }
    }

    private void doCloseFile() {
        if (this.hasDocuments()) {
            this.closeDocument(this.mainWindow.getTabIndex());
        }
    }

    private void doCloseAllFiles() {
        int n;
        while (this.hasDocuments() && this.confirmCloseDocument(n = this.getNumDocuments() - 1)) {
            this.removeDocument(n);
        }
    }

    private void doSaveFile() throws AppException {
        FunctionDocument functionDocument = this.getDocument();
        if (functionDocument != null && functionDocument.isChanged()) {
            if (functionDocument.getFile() == null) {
                this.doSaveFileAs();
            } else {
                IncludeColours includeColours = this.confirmIncludeColours(functionDocument, SAVE_FILE_STR);
                if (includeColours != null) {
                    this.writeDocument(functionDocument, null, includeColours == IncludeColours.YES);
                }
            }
        }
    }

    private void doSaveFileAs() throws AppException {
        FunctionDocument functionDocument = this.getDocument();
        if (functionDocument != null) {
            IncludeColours includeColours;
            FunctionDocument.FileEx fileEx = functionDocument.getFileEx();
            fileEx = this.chooseSave(fileEx.file, fileEx.fileKind);
            if (fileEx != null && this.confirmWriteFile(fileEx.file, SAVE_FILE_AS_STR) && (includeColours = this.confirmIncludeColours(functionDocument, SAVE_FILE_AS_STR)) != null) {
                this.writeDocument(functionDocument, fileEx, includeColours == IncludeColours.YES);
            }
        }
    }

    private void doExportImage() throws AppException {
        File file;
        FunctionDocument functionDocument = this.getDocument();
        if (functionDocument != null && (file = this.chooseExport()) != null && this.confirmWriteFile(file, EXPORT_IMAGE_STR)) {
            OperationDialog.showDialog(this.mainWindow, WRITE_IMAGE_STR, new Operation.WriteImage(functionDocument, file));
        }
    }

    private void doExit() {
        if (!this.exiting) {
            Point point;
            this.exiting = true;
            while (this.hasDocuments()) {
                int n = this.getNumDocuments() - 1;
                if (!this.confirmCloseDocument(n)) {
                    this.exiting = false;
                    return;
                }
                this.removeDocument(n);
            }
            AppConfig appConfig = AppConfig.getInstance();
            if (appConfig.isMainWindowLocation() && (point = GuiUtilities.getFrameLocation(this.mainWindow)) != null) {
                appConfig.setMainWindowLocation(point);
            }
            this.mainWindow.setVisible(false);
            this.mainWindow.dispose();
        }
    }

    private void doCopyIntervals() {
        int n = this.getNumDocuments();
        if (n >= 2) {
            int n2 = this.mainWindow.getTabIndex();
            String[] stringArray = new String[n - 1];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (i == n2) continue;
                stringArray[n3++] = this.getDocument(i).getTitleString(AppConfig.getInstance().isShowFullPathnames());
            }
            int[] nArray = ListSelectionDialog.showDialog(this.mainWindow, COPY_INTERVALS_STR, DOCUMENTS_STR, stringArray);
            if (nArray != null) {
                FunctionDocument functionDocument = this.getDocument();
                for (int n4 : nArray) {
                    if (n4 >= n2) {
                        ++n4;
                    }
                    this.getDocument(n4).setIntervals(functionDocument.getXInterval(), functionDocument.getYInterval());
                    this.getView(n4).updateIntervals();
                }
            }
        }
    }

    private void doEditPreferences() {
        if (PreferencesDialog.showDialog(this.mainWindow).isAccepted()) {
            ExceptionUtilities.setUnixStyle(AppConfig.getInstance().isShowUnixPathnames());
            if (this.getView() != null) {
                this.getView().repaint();
            }
        }
    }

    private void doShowFullPathnames() {
        AppConfig.getInstance().setShowFullPathnames(!AppConfig.getInstance().isShowFullPathnames());
    }

    private class DoAppletInitialisation
    implements Runnable {
        private FuncPlotter applet;

        private DoAppletInitialisation(FuncPlotter funcPlotter) {
            this.applet = funcPlotter;
        }

        @Override
        public void run() {
            FunctionView functionView = App.this.getView();
            this.applet.setContentPane(functionView);
            System.out.println("Applet: FuncPlotter " + App.this.getVersionString());
            String string = "app.startup.xInterval";
            String string2 = this.applet.getParameter(string);
            if (string2 != null) {
                App.this.getDocument().parseStartupParam("xInterval", string2, 0);
            }
            if ((string2 = this.applet.getParameter(string = "app.startup.yInterval")) != null) {
                App.this.getDocument().parseStartupParam("yInterval", string2, 0);
            }
            for (int i = 0; i < 20; ++i) {
                string = "app.startup.function" + i;
                string2 = this.applet.getParameter(string);
                if (string2 == null) continue;
                App.this.getDocument().parseStartupParam("function", string2, i);
            }
            if (App.this.getDocument().hasFunctions()) {
                functionView.updateFunctionList();
                functionView.updatePlot();
            }
            functionView.setDefaultFocus();
            Dimension dimension = this.applet.getPreferredSize();
            String string3 = new String(App.MINIMUM_DIMENSIONS_STR + dimension.width + " " + App.WIDTH_STR + " \u00d7 " + dimension.height + " " + App.HEIGHT_STR + ".");
            if (this.applet.getWidth() < dimension.width || this.applet.getHeight() < dimension.height) {
                System.err.println(App.DIMENSIONS_ERROR_STR);
                App.this.showErrorMessage(App.SHORT_NAME, "The applet dimensions are too small.\n" + string3);
            }
            System.out.println(string3);
        }
    }

    private class DoAppInitialisation
    implements Runnable {
        private String[] arguments;

        private DoAppInitialisation(String[] stringArray) {
            this.arguments = stringArray;
        }

        @Override
        public void run() {
            App.this.mainWindow.updateTitleAndMenus();
        }
    }

    private static class DocumentView {
        FunctionDocument document;
        FunctionView view;

        private DocumentView(FunctionDocument functionDocument) {
            this.document = functionDocument;
            this.view = new FunctionView(functionDocument);
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        NO_FILE_CHOOSER("Security restrictions prevented a file selection dialog box from being displayed.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static enum IncludeColours {
        NO,
        YES;

    }
}

