/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WorldMapGraphDemo
extends JApplet {
    Graph<String, Number> graph;
    VisualizationViewer<String, Number> vv;
    Map<String, String[]> map = new HashMap<String, String[]>();
    List<String> cityList;

    public WorldMapGraphDemo() {
        this.setLayout(new BorderLayout());
        this.map.put("TYO", new String[]{"35 40 N", "139 45 E"});
        this.map.put("PEK", new String[]{"39 55 N", "116 26 E"});
        this.map.put("MOW", new String[]{"55 45 N", "37 42 E"});
        this.map.put("JRS", new String[]{"31 47 N", "35 13 E"});
        this.map.put("CAI", new String[]{"30 03 N", "31 15 E"});
        this.map.put("CPT", new String[]{"33 55 S", "18 22 E"});
        this.map.put("PAR", new String[]{"48 52 N", "2 20 E"});
        this.map.put("LHR", new String[]{"51 30 N", "0 10 W"});
        this.map.put("HNL", new String[]{"21 18 N", "157 51 W"});
        this.map.put("NYC", new String[]{"40 77 N", "73 98 W"});
        this.map.put("SFO", new String[]{"37 62 N", "122 38 W"});
        this.map.put("AKL", new String[]{"36 55 S", "174 47 E"});
        this.map.put("BNE", new String[]{"27 28 S", "153 02 E"});
        this.map.put("HKG", new String[]{"22 15 N", "114 10 E"});
        this.map.put("KTM", new String[]{"27 42 N", "85 19 E"});
        this.map.put("IST", new String[]{"41 01 N", "28 58 E"});
        this.map.put("STO", new String[]{"59 20 N", "18 03 E"});
        this.map.put("RIO", new String[]{"22 54 S", "43 14 W"});
        this.map.put("LIM", new String[]{"12 03 S", "77 03 W"});
        this.map.put("YTO", new String[]{"43 39 N", "79 23 W"});
        this.cityList = new ArrayList<String>(this.map.keySet());
        this.graph = new DirectedSparseMultigraph<String, Number>();
        this.createVertices();
        this.createEdges();
        ImageIcon mapIcon = null;
        String imageLocation = "/images/political_world_map.jpg";
        try {
            mapIcon = new ImageIcon(this.getClass().getResource(imageLocation));
        }
        catch (Exception ex) {
            System.err.println("Can't load \"" + imageLocation + "\"");
        }
        final ImageIcon icon = mapIcon;
        Dimension layoutSize = new Dimension(2000, 1000);
        StaticLayout<String, Number> layout = new StaticLayout<String, Number>(this.graph, Functions.compose((Function)new LatLonPixelTransformer(new Dimension(2000, 1000)), (Function)new CityTransformer(this.map)));
        layout.setSize(layoutSize);
        this.vv = new VisualizationViewer<String, Number>(layout, new Dimension(800, 400));
        if (icon != null) {
            this.vv.addPreRenderPaintable(new VisualizationServer.Paintable(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform oldXform = g2d.getTransform();
                    AffineTransform lat = WorldMapGraphDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).getTransform();
                    AffineTransform vat = WorldMapGraphDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).getTransform();
                    AffineTransform at = new AffineTransform();
                    at.concatenate(g2d.getTransform());
                    at.concatenate(vat);
                    at.concatenate(lat);
                    g2d.setTransform(at);
                    g.drawImage(icon.getImage(), 0, 0, icon.getIconWidth(), icon.getIconHeight(), WorldMapGraphDemo.this.vv);
                    g2d.setTransform(oldXform);
                }

                @Override
                public boolean useTransform() {
                    return false;
                }
            });
        }
        this.vv.getRenderer().setVertexRenderer(new GradientVertexRenderer(Color.white, Color.red, Color.white, Color.blue, this.vv.getPickedVertexState(), false));
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv.setEdgeToolTipTransformer(new Function<Number, String>(){

            public String apply(Number edge) {
                return "E" + WorldMapGraphDemo.this.graph.getEndpoints(edge).toString();
            }
        });
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPositioner(new BasicVertexLabelRenderer.InsidePositioner());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        this.add(panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.vv.setToolTipText("<html><center>Type 'p' for Pick mode<p>Type 't' for Transform mode");
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(WorldMapGraphDemo.this.vv, 1.1f, WorldMapGraphDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(WorldMapGraphDemo.this.vv, 0.9090909f, WorldMapGraphDemo.this.vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapGraphDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                WorldMapGraphDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        this.add((Component)controls, "South");
    }

    private void createVertices() {
        for (String city : this.map.keySet()) {
            this.graph.addVertex(city);
        }
    }

    void createEdges() {
        int i = 0;
        while ((double)i < (double)this.map.keySet().size() * 1.3) {
            this.graph.addEdge(new Double(Math.random()), this.randomCity(), this.randomCity(), EdgeType.DIRECTED);
            ++i;
        }
    }

    private String randomCity() {
        int m = this.cityList.size();
        return this.cityList.get((int)(Math.random() * (double)m));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        content.add(new WorldMapGraphDemo());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static class LatLonPixelTransformer
    implements Function<String[], Point2D> {
        Dimension d;
        int startOffset;

        public LatLonPixelTransformer(Dimension d) {
            this.d = d;
        }

        public Point2D apply(String[] latlon) {
            double latitude = 0.0;
            double longitude = 0.0;
            String[] lat = latlon[0].split(" ");
            String[] lon = latlon[1].split(" ");
            latitude = (float)Integer.parseInt(lat[0]) + (float)Integer.parseInt(lat[1]) / 60.0f;
            latitude *= (double)((float)this.d.height / 180.0f);
            longitude = (float)Integer.parseInt(lon[0]) + (float)Integer.parseInt(lon[1]) / 60.0f;
            longitude *= (double)((float)this.d.width / 360.0f);
            latitude = lat[2].equals("N") ? (double)(this.d.height / 2) - latitude : (double)(this.d.height / 2) + latitude;
            longitude = lon[2].equals("W") ? (double)(this.d.width / 2) - longitude : (double)(this.d.width / 2) + longitude;
            return new Point2D.Double(longitude, latitude);
        }
    }

    static class CityTransformer
    implements Function<String, String[]> {
        Map<String, String[]> map;

        public CityTransformer(Map<String, String[]> map) {
            this.map = map;
        }

        public String[] apply(String city) {
            return this.map.get(city);
        }
    }
}

