/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class AbstractHypergraphTest
extends TestCase {
    protected Supplier<? extends Hypergraph<Integer, Character>> factory;
    protected Hypergraph<Integer, Character> h;

    public AbstractHypergraphTest(Supplier<? extends Hypergraph<Integer, Character>> factory) {
        this.factory = factory;
    }

    public void runTest() throws Exception {
        this.setUp();
        this.testAddVertex();
        this.testAddEdge();
        this.testEdgeEndpoints();
        this.tearDown();
    }

    public void testAddVertex() {
        int count = this.h.getVertexCount();
        AbstractHypergraphTest.assertTrue((boolean)this.h.addVertex(new Integer(1)));
        AbstractHypergraphTest.assertEquals((int)(count + 1), (int)this.h.getVertexCount());
        AbstractHypergraphTest.assertTrue((boolean)this.h.containsVertex(1));
        boolean success = false;
        try {
            success = this.h.addVertex(null);
            AbstractHypergraphTest.fail((String)"Implementation should disallow null vertices");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException npe) {
            AbstractHypergraphTest.fail((String)"Implementation should actively prevent null vertices");
        }
        AbstractHypergraphTest.assertFalse((boolean)success);
        AbstractHypergraphTest.assertFalse((boolean)this.h.addVertex(1));
        AbstractHypergraphTest.assertEquals((int)(count + 1), (int)this.h.getVertexCount());
        AbstractHypergraphTest.assertFalse((boolean)this.h.containsVertex(2));
    }

    public void testAddEdge() {
        int edge_count = this.h.getEdgeCount();
        int vertex_count = this.h.getVertexCount();
        Pair<Integer> p = new Pair<Integer>(2, 3);
        AbstractHypergraphTest.assertTrue((boolean)this.h.addEdge(Character.valueOf('a'), p));
        AbstractHypergraphTest.assertEquals((int)(edge_count + 1), (int)this.h.getEdgeCount());
        AbstractHypergraphTest.assertEquals((int)(vertex_count + 2), (int)this.h.getVertexCount());
        AbstractHypergraphTest.assertTrue((boolean)this.h.containsEdge(Character.valueOf('a')));
        boolean success = false;
        try {
            success = this.h.addEdge(Character.valueOf('b'), null);
            AbstractHypergraphTest.fail((String)"Implementation should disallow null pairs/collections");
            success = this.h.addEdge(null, p);
            AbstractHypergraphTest.fail((String)"Implementation should disallow null edges");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException npe) {
            AbstractHypergraphTest.fail((String)"Implementation should actively prevent null edges, pairs, and collections");
        }
        AbstractHypergraphTest.assertFalse((boolean)success);
        AbstractHypergraphTest.assertFalse((boolean)this.h.addEdge(Character.valueOf('a'), new Pair<Integer>(2, 3)));
        AbstractHypergraphTest.assertFalse((boolean)this.h.addEdge(Character.valueOf('a'), p));
        try {
            success = this.h.addEdge(Character.valueOf('a'), new Pair<Integer>(3, 4));
            AbstractHypergraphTest.fail((String)"Implementation should disallow existing edge objects from connecting new pairs/collections");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AbstractHypergraphTest.assertEquals((int)(edge_count + 1), (int)this.h.getEdgeCount());
        AbstractHypergraphTest.assertFalse((boolean)this.h.containsEdge(Character.valueOf('b')));
    }

    public void testEdgeEndpoints() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            try {
                this.h.addEdge(Character.valueOf((char)i), c);
                c.add(i);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (this.h instanceof Graph) {
                    if (c.size() != 2) continue;
                    AbstractHypergraphTest.fail((String)("improperly rejected incident vertex collection " + c));
                    continue;
                }
                AbstractHypergraphTest.fail((String)"hypergraph implementations should accept any positive number of incident vertices");
            }
        }
    }

    public void testFindEdge() {
    }
}

