/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Supplier;
import com.google.common.collect.BiMap;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.algorithms.util.Indexer;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUnweightedShortestPath
extends TestCase {
    private Supplier<String> vertexFactory = new Supplier<String>(){
        int count = 0;

        public String get() {
            return "V" + this.count++;
        }
    };
    private Supplier<Integer> edgeFactory = new Supplier<Integer>(){
        int count = 0;

        public Integer get() {
            return this.count++;
        }
    };
    BiMap<String, Integer> id;

    protected void setUp() {
    }

    public static Test suite() {
        return new TestSuite(TestUnweightedShortestPath.class);
    }

    public void testUndirected() {
        UndirectedSparseMultigraph<Object, Object> ug = new UndirectedSparseMultigraph<Object, Object>();
        for (int i = 0; i < 5; ++i) {
            ug.addVertex(this.vertexFactory.get());
        }
        this.id = Indexer.create(ug.getVertices());
        ug.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)0), this.id.inverse().get((Object)1));
        ug.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)1), this.id.inverse().get((Object)2));
        ug.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)2), this.id.inverse().get((Object)3));
        ug.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)0), this.id.inverse().get((Object)4));
        ug.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)4), this.id.inverse().get((Object)3));
        UnweightedShortestPath usp = new UnweightedShortestPath(ug);
        Assert.assertEquals((int)usp.getDistance(this.id.inverse().get((Object)0), this.id.inverse().get((Object)3)).intValue(), (int)2);
        Assert.assertEquals((int)usp.getDistanceMap(this.id.inverse().get((Object)0)).get(this.id.inverse().get((Object)3)).intValue(), (int)2);
        Assert.assertNull(usp.getIncomingEdgeMap(this.id.inverse().get((Object)0)).get(this.id.inverse().get((Object)0)));
        Assert.assertNotNull(usp.getIncomingEdgeMap(this.id.inverse().get((Object)0)).get(this.id.inverse().get((Object)3)));
    }

    public void testDirected() {
        DirectedSparseMultigraph<Object, Object> dg = new DirectedSparseMultigraph<Object, Object>();
        for (int i = 0; i < 5; ++i) {
            dg.addVertex(this.vertexFactory.get());
        }
        this.id = Indexer.create(dg.getVertices());
        dg.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)0), this.id.inverse().get((Object)1));
        dg.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)1), this.id.inverse().get((Object)2));
        dg.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)2), this.id.inverse().get((Object)3));
        dg.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)0), this.id.inverse().get((Object)4));
        dg.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)4), this.id.inverse().get((Object)3));
        dg.addEdge(this.edgeFactory.get(), this.id.inverse().get((Object)3), this.id.inverse().get((Object)0));
        UnweightedShortestPath usp = new UnweightedShortestPath(dg);
        Assert.assertEquals((int)usp.getDistance(this.id.inverse().get((Object)0), this.id.inverse().get((Object)3)).intValue(), (int)2);
        Assert.assertEquals((int)usp.getDistanceMap(this.id.inverse().get((Object)0)).get(this.id.inverse().get((Object)3)).intValue(), (int)2);
        Assert.assertNull(usp.getIncomingEdgeMap(this.id.inverse().get((Object)0)).get(this.id.inverse().get((Object)0)));
        Assert.assertNotNull(usp.getIncomingEdgeMap(this.id.inverse().get((Object)0)).get(this.id.inverse().get((Object)3)));
    }
}

