/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.scoring.VoltageScorer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;

public class TestVoltageScore
extends TestCase {
    protected Graph<Number, Number> g;

    public void setUp() {
        this.g = new UndirectedSparseMultigraph<Number, Number>();
        for (int i = 0; i < 7; ++i) {
            this.g.addVertex(i);
        }
        int j = 0;
        this.g.addEdge((Number)j++, 0, 1);
        this.g.addEdge((Number)j++, 0, 2);
        this.g.addEdge((Number)j++, 1, 3);
        this.g.addEdge((Number)j++, 2, 3);
        this.g.addEdge((Number)j++, 3, 4);
        this.g.addEdge((Number)j++, 3, 5);
        this.g.addEdge((Number)j++, 4, 6);
        this.g.addEdge((Number)j++, 5, 6);
    }

    public final void testCalculateVoltagesSourceTarget() {
        VoltageScorer<Integer, Number> vr = new VoltageScorer<Integer, Number>(this.g, Functions.constant((Object)1), 0, 6);
        double[] voltages = new double[]{1.0, 0.75, 0.75, 0.5, 0.25, 0.25, 0.0};
        vr.evaluate();
        for (int i = 0; i < 7; ++i) {
            TestVoltageScore.assertEquals((double)((Double)vr.getVertexScore(i)), (double)voltages[i], (double)0.01);
        }
    }

    public final void testCalculateVoltagesSourcesTargets() {
        HashMap<Integer, Double> sources = new HashMap<Integer, Double>();
        sources.put(0, new Double(1.0));
        sources.put(1, new Double(0.5));
        HashSet<Integer> sinks = new HashSet<Integer>();
        sinks.add(6);
        sinks.add(5);
        VoltageScorer vr = new VoltageScorer(this.g, (Function<Number, Number>)Functions.constant((Object)1), sources, sinks);
        double[] voltages = new double[]{1.0, 0.5, 0.66, 0.33, 0.16, 0.0, 0.0};
        vr.evaluate();
        for (int i = 0; i < 7; ++i) {
            TestVoltageScore.assertEquals((double)((Double)vr.getVertexScore(i)), (double)voltages[i], (double)0.01);
        }
    }
}

