/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.BicomponentClusterer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBicomponentClusterer
extends TestCase {
    public static Test suite() {
        return new TestSuite(TestBicomponentClusterer.class);
    }

    protected void setUp() {
    }

    public void testExtract0() throws Exception {
        UndirectedSparseMultigraph<String, Number> graph = new UndirectedSparseMultigraph<String, Number>();
        String[] v = new String[]{"0"};
        graph.addVertex(v[0]);
        ArrayList<Set<String>> c = new ArrayList<Set<String>>();
        c.add(0, new HashSet());
        ((Set)c.get(0)).add(v[0]);
        this.testComponents(graph, v, c);
    }

    public void testExtractEdge() throws Exception {
        UndirectedSparseMultigraph<String, Number> graph = new UndirectedSparseMultigraph<String, Number>();
        String[] v = new String[]{"0", "1"};
        graph.addVertex(v[0]);
        graph.addVertex(v[1]);
        graph.addEdge(Integer.valueOf(0), v[0], v[1]);
        ArrayList<Set<String>> c = new ArrayList<Set<String>>();
        c.add(0, new HashSet());
        ((Set)c.get(0)).add(v[0]);
        ((Set)c.get(0)).add(v[1]);
        this.testComponents(graph, v, c);
    }

    public void testExtractV() throws Exception {
        UndirectedSparseMultigraph<String, Number> graph = new UndirectedSparseMultigraph<String, Number>();
        String[] v = new String[3];
        for (int i = 0; i < 3; ++i) {
            v[i] = "" + i;
            graph.addVertex(v[i]);
        }
        graph.addEdge(Integer.valueOf(0), v[0], v[1]);
        graph.addEdge(Integer.valueOf(1), v[0], v[2]);
        ArrayList<Set<String>> c = new ArrayList<Set<String>>();
        c.add(0, new HashSet());
        c.add(1, new HashSet());
        ((Set)c.get(0)).add(v[0]);
        ((Set)c.get(0)).add(v[1]);
        ((Set)c.get(1)).add(v[0]);
        ((Set)c.get(1)).add(v[2]);
        this.testComponents(graph, v, c);
    }

    public void createEdges(String[] v, int[][] edge_array, Graph<String, Number> g) {
        for (int k = 0; k < edge_array.length; ++k) {
            int i = edge_array[k][0];
            int j = edge_array[k][1];
            String v1 = this.getVertex(v, i, g);
            String v2 = this.getVertex(v, j, g);
            g.addEdge((Number)k, v1, v2);
        }
    }

    public String getVertex(String[] v_array, int i, Graph<String, Number> g) {
        String v = v_array[i];
        if (v == null) {
            v_array[i] = Character.toString((char)(48 + i));
            g.addVertex(v_array[i]);
            v = v_array[i];
        }
        return v;
    }

    public void testExtract1() {
        String[] v = new String[6];
        int[][] edges1 = new int[][]{{0, 1}, {0, 5}, {0, 3}, {0, 4}, {1, 5}, {3, 4}, {2, 3}};
        UndirectedSparseMultigraph<String, Number> graph = new UndirectedSparseMultigraph<String, Number>();
        this.createEdges(v, edges1, graph);
        ArrayList<Set<String>> c = new ArrayList<Set<String>>();
        for (int i = 0; i < 3; ++i) {
            c.add(i, new HashSet());
        }
        ((Set)c.get(0)).add(v[0]);
        ((Set)c.get(0)).add(v[1]);
        ((Set)c.get(0)).add(v[5]);
        ((Set)c.get(1)).add(v[0]);
        ((Set)c.get(1)).add(v[3]);
        ((Set)c.get(1)).add(v[4]);
        ((Set)c.get(2)).add(v[2]);
        ((Set)c.get(2)).add(v[3]);
        this.testComponents(graph, v, c);
    }

    public void testExtract2() {
        String[] v = new String[9];
        int[][] edges1 = new int[][]{{0, 2}, {0, 4}, {1, 0}, {2, 1}, {3, 0}, {4, 3}, {5, 3}, {6, 7}, {6, 8}, {8, 7}};
        UndirectedSparseMultigraph<String, Number> graph = new UndirectedSparseMultigraph<String, Number>();
        this.createEdges(v, edges1, graph);
        ArrayList<Set<String>> c = new ArrayList<Set<String>>();
        for (int i = 0; i < 4; ++i) {
            c.add(i, new HashSet());
        }
        ((Set)c.get(0)).add(v[0]);
        ((Set)c.get(0)).add(v[1]);
        ((Set)c.get(0)).add(v[2]);
        ((Set)c.get(1)).add(v[0]);
        ((Set)c.get(1)).add(v[3]);
        ((Set)c.get(1)).add(v[4]);
        ((Set)c.get(2)).add(v[5]);
        ((Set)c.get(2)).add(v[3]);
        ((Set)c.get(3)).add(v[6]);
        ((Set)c.get(3)).add(v[7]);
        ((Set)c.get(3)).add(v[8]);
        this.testComponents(graph, v, c);
    }

    public void testComponents(UndirectedGraph<String, Number> graph, String[] vertices, List<Set<String>> c) {
        BicomponentClusterer<String, Number> finder = new BicomponentClusterer<String, Number>();
        Set<Set<String>> bicomponents = finder.apply(graph);
        TestBicomponentClusterer.assertEquals((int)bicomponents.size(), (int)c.size());
        ArrayList<Set<String>> clusterList = new ArrayList<Set<String>>(bicomponents);
        boolean found = false;
        for (int i = 0; i < c.size(); ++i) {
            for (int j = 0; j < bicomponents.size(); ++j) {
                if (!((Set)clusterList.get(j)).equals(c.get(i))) continue;
                found = true;
                break;
            }
            TestBicomponentClusterer.assertTrue((boolean)found);
        }
        HashSet<String> collapsedSet = new HashSet<String>();
        for (Set<String> set : bicomponents) {
            collapsedSet.addAll(set);
        }
        for (String v : graph.getVertices()) {
            TestBicomponentClusterer.assertTrue((boolean)collapsedSet.contains(v));
        }
    }
}

