/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.transform;

import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.transform.Bijection2D;

public class CircleInversion2D
implements Bijection2D {
    protected Point2D center;
    protected double radius;

    public static CircleInversion2D create(Point2D center, double radius) {
        return new CircleInversion2D(center, radius);
    }

    public static CircleInversion2D create(Circle2D circle) {
        return new CircleInversion2D(circle);
    }

    public CircleInversion2D() {
        this.center = new Point2D();
        this.radius = 1.0;
    }

    public CircleInversion2D(Circle2D circle) {
        this.center = circle.center();
        this.radius = circle.radius();
    }

    public CircleInversion2D(Point2D center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public CircleInversion2D(double xc, double yc, double radius) {
        this.center = new Point2D(xc, yc);
        this.radius = radius;
    }

    public Point2D center() {
        return this.center;
    }

    public double radius() {
        return this.radius;
    }

    @Override
    public CircleInversion2D invert() {
        return this;
    }

    @Override
    public Point2D transform(Point2D pt) {
        double r = this.radius;
        double d = r * r / Point2D.distance(pt, this.center);
        double theta = Angle2D.horizontalAngle(this.center, pt);
        return Point2D.createPolar(this.center, d, theta);
    }

    @Override
    public Point2D[] transform(Point2D[] src, Point2D[] dst) {
        int i;
        if (dst == null) {
            dst = new Point2D[src.length];
        }
        if (dst[0] == null) {
            for (i = 0; i < dst.length; ++i) {
                dst[i] = new Point2D();
            }
        }
        double xc = this.center.x();
        double yc = this.center.y();
        double r = this.radius;
        for (i = 0; i < src.length; ++i) {
            double d = Point2D.distance(src[i].x(), src[i].y(), xc, yc);
            d = r * r / d;
            double theta = Math.atan2(src[i].y() - yc, src[i].x() - xc);
            dst[i] = new Point2D(d * Math.cos(theta), d * Math.sin(theta));
        }
        return dst;
    }
}

