/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polygons2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.transform.CircleInversion2D;
import math.utils.EqualUtils;

public class Rectangle2D
implements Polygon2D {
    protected double x0;
    protected double y0;
    protected double w;
    protected double h;

    public Rectangle2D(double x0, double y0, double w, double h) {
        this.x0 = x0;
        this.y0 = y0;
        this.w = w;
        this.h = h;
    }

    public Rectangle2D() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Rectangle2D(java.awt.geom.Rectangle2D rect) {
        this.x0 = rect.getX();
        this.y0 = rect.getY();
        this.w = rect.getWidth();
        this.h = rect.getHeight();
    }

    public Rectangle2D(Point2D p1, Point2D p2) {
        this.x0 = Math.min(p1.x(), p2.x());
        this.y0 = Math.min(p1.y(), p2.y());
        this.w = Math.max(p1.x(), p2.x()) - this.x0;
        this.h = Math.max(p1.y(), p2.y()) - this.y0;
    }

    public double getX() {
        return this.x0;
    }

    public double getY() {
        return this.y0;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    @Override
    public Collection<Point2D> vertices() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(4);
        array.add(new Point2D(this.x0, this.y0));
        array.add(new Point2D(this.x0 + this.w, this.y0));
        array.add(new Point2D(this.x0 + this.w, this.y0 + this.h));
        array.add(new Point2D(this.x0, this.y0 + this.h));
        return array;
    }

    @Override
    public int vertexNumber() {
        return 4;
    }

    @Override
    public Point2D vertex(int i) {
        switch (i) {
            case 0: {
                return new Point2D(this.x0, this.y0);
            }
            case 1: {
                return new Point2D(this.x0 + this.w, this.y0);
            }
            case 2: {
                return new Point2D(this.x0 + this.w, this.y0 + this.h);
            }
            case 3: {
                return new Point2D(this.x0, this.y0 + this.h);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setVertex(int i, Point2D point) {
        throw new UnsupportedOperationException("Vertices of Rectangle objects can not be modified");
    }

    @Override
    public void addVertex(Point2D point) {
        throw new UnsupportedOperationException("Vertices of Rectangle objects can not be modified");
    }

    @Override
    public void insertVertex(int i, Point2D point) {
        throw new UnsupportedOperationException("Vertices of Rectangle objects can not be modified");
    }

    @Override
    public void removeVertex(int i) {
        throw new UnsupportedOperationException("Vertices of Rectangle objects can not be modified");
    }

    @Override
    public int closestVertexIndex(Point2D point) {
        double minDist = Double.POSITIVE_INFINITY;
        int index = -1;
        int i = 0;
        for (Point2D vertex : this.vertices()) {
            double dist = vertex.distance(point);
            if (dist < minDist) {
                index = i;
                minDist = dist;
            }
            ++i;
        }
        return index;
    }

    public Collection<LineSegment2D> edges() {
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(4);
        edges.add(new LineSegment2D(this.x0, this.y0, this.x0 + this.w, this.y0));
        edges.add(new LineSegment2D(this.x0 + this.w, this.y0, this.x0 + this.w, this.y0 + this.h));
        edges.add(new LineSegment2D(this.x0 + this.w, this.y0 + this.h, this.x0, this.y0 + this.h));
        edges.add(new LineSegment2D(this.x0, this.y0 + this.h, this.x0, this.y0));
        return edges;
    }

    @Override
    public int edgeNumber() {
        return 4;
    }

    @Override
    public double area() {
        return this.w * this.h;
    }

    @Override
    public Point2D centroid() {
        double xc = this.x0 + this.w / 2.0;
        double yc = this.y0 + this.h / 2.0;
        return new Point2D(xc, yc);
    }

    @Override
    public Polygon2D asPolygon(int n) {
        return this;
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        return new GenericCirculinearDomain2D(((CirculinearContourArray2D)this.boundary()).transform(inv));
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this.boundary(), dist);
    }

    @Override
    public CirculinearContourArray2D<LinearRing2D> boundary() {
        return new CirculinearContourArray2D<LinearRing2D>(this.asRing());
    }

    public Collection<LinearRing2D> contours() {
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>(1);
        rings.add(this.asRing());
        return rings;
    }

    private LinearRing2D asRing() {
        Point2D[] pts = new Point2D[]{new Point2D(this.x0, this.y0), new Point2D(this.x0 + this.w, this.y0), new Point2D(this.x0 + this.w, this.y0 + this.h), new Point2D(this.x0, this.y0 + this.h)};
        return new LinearRing2D(pts);
    }

    @Override
    public Polygon2D complement() {
        Point2D[] pts = new Point2D[]{new Point2D(this.x0, this.y0), new Point2D(this.x0, this.y0 + this.h), new Point2D(this.x0 + this.w, this.y0 + this.h), new Point2D(this.x0 + this.w, this.y0)};
        return new SimplePolygon2D(pts);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        double dist = ((ContourArray2D)((Object)this.boundary())).signedDistance(x, y);
        return Math.max(dist, 0.0);
    }

    @Override
    public Polygon2D clip(Box2D box) {
        return Polygons2D.clipPolygon(this, box);
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(this.x0, this.x0 + this.w, this.y0, this.y0 + this.h);
    }

    @Override
    public SimplePolygon2D transform(AffineTransform2D trans) {
        int nPoints = 4;
        Point2D[] array = new Point2D[nPoints];
        Point2D[] res = new Point2D[nPoints];
        Iterator<Point2D> iter = this.vertices().iterator();
        for (int i = 0; i < nPoints; ++i) {
            array[i] = iter.next();
            res[i] = new Point2D();
        }
        trans.transform(array, res);
        return new SimplePolygon2D(res);
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.x(), point.y());
    }

    @Override
    public boolean contains(double x, double y) {
        if (x < this.x0) {
            return false;
        }
        if (x > this.x0 + this.w) {
            return false;
        }
        if (y < this.y0) {
            return false;
        }
        return !(y > this.y0 + this.h);
    }

    @Override
    public void draw(Graphics2D g2) {
        this.asRing().draw(g2);
    }

    @Override
    public void fill(Graphics2D g2) {
        this.asRing().fill(g2);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rect = (Rectangle2D)obj;
        for (Point2D point : this.vertices()) {
            boolean ok = false;
            for (Point2D point2 : rect.vertices()) {
                if (!point.almostEquals(point2, eps)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D that = (Rectangle2D)obj;
        if (!EqualUtils.areEqual(this.x0, that.x0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.y0, that.y0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.w, that.w)) {
            return false;
        }
        return EqualUtils.areEqual(this.h, that.h);
    }
}

