/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.AbstractContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.point.PointSets2D;
import math.geom2d.polygon.Polyline2D;

public abstract class LinearCurve2D
extends AbstractContinuousCurve2D
implements CirculinearContinuousCurve2D {
    protected ArrayList<Point2D> vertices;

    protected LinearCurve2D() {
        this.vertices = new ArrayList();
    }

    protected LinearCurve2D(int nVertices) {
        this.vertices = new ArrayList(nVertices);
    }

    protected LinearCurve2D(Point2D ... vertices) {
        this.vertices = new ArrayList(vertices.length);
        for (Point2D vertex : vertices) {
            this.vertices.add(vertex);
        }
    }

    protected LinearCurve2D(Collection<? extends Point2D> vertices) {
        this.vertices = new ArrayList(vertices.size());
        this.vertices.addAll(vertices);
    }

    protected LinearCurve2D(double[] xcoords, double[] ycoords) {
        this.vertices = new ArrayList(xcoords.length);
        int n = xcoords.length;
        this.vertices.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            this.vertices.add(new Point2D(xcoords[i], ycoords[i]));
        }
    }

    public abstract LinearCurve2D simplify(double var1);

    public Iterator<Point2D> vertexIterator() {
        return this.vertices.iterator();
    }

    public Point2D[] vertexArray() {
        return this.vertices.toArray(new Point2D[0]);
    }

    public boolean addVertex(Point2D vertex) {
        return this.vertices.add(vertex);
    }

    public void insertVertex(int index, Point2D vertex) {
        this.vertices.add(index, vertex);
    }

    public boolean removeVertex(Point2D vertex) {
        return this.vertices.remove(vertex);
    }

    public Point2D removeVertex(int index) {
        return this.vertices.remove(index);
    }

    public void setVertex(int index, Point2D position) {
        this.vertices.set(index, position);
    }

    public void clearVertices() {
        this.vertices.clear();
    }

    @Override
    public Collection<Point2D> vertices() {
        return this.vertices;
    }

    public Point2D vertex(int i) {
        return this.vertices.get(i);
    }

    public int vertexNumber() {
        return this.vertices.size();
    }

    public int closestVertexIndex(Point2D point) {
        double minDist = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < this.vertices.size(); ++i) {
            double dist = this.vertices.get(i).distance(point);
            if (!(dist < minDist)) continue;
            index = i;
            minDist = dist;
        }
        return index;
    }

    public abstract LineSegment2D edge(int var1);

    public abstract int edgeNumber();

    public abstract Collection<LineSegment2D> edges();

    public LineSegment2D firstEdge() {
        if (this.vertices.size() < 2) {
            return null;
        }
        return new LineSegment2D(this.vertices.get(0), this.vertices.get(1));
    }

    public abstract LineSegment2D lastEdge();

    @Override
    public double length() {
        double sum = 0.0;
        for (LineSegment2D edge : this.edges()) {
            sum += edge.length();
        }
        return sum;
    }

    @Override
    public double length(double pos) {
        double length = 0.0;
        int index = (int)Math.floor(pos);
        for (int i = 0; i < index; ++i) {
            length += this.edge(i).length();
        }
        if (index < this.vertices.size() - 1) {
            double pos2 = pos - (double)index;
            length += this.edge(index).length(pos2);
        }
        return length;
    }

    @Override
    public double position(double length) {
        double pos = 0.0;
        int index = 0;
        double cumLength = this.length(this.t0());
        for (LineSegment2D edge : this.edges()) {
            double edgeLength = edge.length();
            if (cumLength + edgeLength < length) {
                cumLength += edgeLength;
                ++index;
                continue;
            }
            double pos2 = edge.position(length - cumLength);
            pos = (double)index + pos2;
            break;
        }
        return pos;
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        if (PointSets2D.hasMultipleVertices(this.vertices)) {
            Polyline2D poly2 = Polyline2D.create(PointSets2D.filterMultipleVertices(this.vertices));
            return bc.computeBuffer(poly2, dist);
        }
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearContinuousCurve2D parallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createContinuousParallel(this, d);
    }

    @Override
    public double signedDistance(Point2D point) {
        double dist = this.distance(point.x(), point.y());
        if (this.isInside(point)) {
            return -dist;
        }
        return dist;
    }

    @Override
    public double signedDistance(double x, double y) {
        double dist = this.distance(x, y);
        if (this.isInside(new Point2D(x, y))) {
            return -dist;
        }
        return dist;
    }

    @Override
    public Vector2D leftTangent(double t) {
        int index = (int)Math.floor(t);
        if (Math.abs(t - (double)index) < 1.0E-12) {
            --index;
        }
        return this.edge(index).tangent(0.0);
    }

    @Override
    public Vector2D rightTangent(double t) {
        int index = (int)Math.ceil(t);
        return this.edge(index).tangent(0.0);
    }

    @Override
    public double curvature(double t) {
        double index = Math.round(t);
        if (Math.abs(index - t) > 1.0E-12) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public Collection<? extends LineSegment2D> smoothPieces() {
        return this.edges();
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public Point2D firstPoint() {
        if (this.vertices.size() == 0) {
            return null;
        }
        return this.vertices.get(0);
    }

    @Override
    public Collection<Point2D> singularPoints() {
        return this.vertices;
    }

    @Override
    public boolean isSingular(double pos) {
        return Math.abs(pos - (double)Math.round(pos)) < 1.0E-12;
    }

    @Override
    public double position(Point2D point) {
        int ind = 0;
        double minDist = Double.POSITIVE_INFINITY;
        double x = point.x();
        double y = point.y();
        int i = 0;
        AbstractLine2D closest = null;
        for (LineSegment2D edge : this.edges()) {
            double dist = edge.distance(x, y);
            if (dist < minDist) {
                minDist = dist;
                ind = i;
                closest = edge;
            }
            ++i;
        }
        return closest.position(point) + (double)ind;
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        for (LineSegment2D edge : this.edges()) {
            Point2D point;
            if (edge.isParallel(line) || (point = edge.intersection(line)) == null || list.contains(point)) continue;
            list.add(point);
        }
        return list;
    }

    public Collection<? extends LinearCurve2D> continuousCurves() {
        return LinearCurve2D.wrapCurve(this);
    }

    @Override
    public double project(Point2D point) {
        double minDist = Double.POSITIVE_INFINITY;
        double x = point.x();
        double y = point.y();
        double pos = Double.NaN;
        int i = 0;
        for (LineSegment2D edge : this.edges()) {
            double dist = edge.distance(x, y);
            if (dist < minDist) {
                minDist = dist;
                pos = edge.project(point) + (double)i;
            }
            ++i;
        }
        return pos;
    }

    @Override
    public double distance(double x, double y) {
        double dist = Double.MAX_VALUE;
        for (LineSegment2D edge : this.edges()) {
            if (edge.length() == 0.0) continue;
            dist = Math.min(dist, edge.distance(x, y));
        }
        return dist;
    }

    @Override
    public double distance(Point2D point) {
        return this.distance(point.x(), point.y());
    }

    @Override
    public boolean isEmpty() {
        return this.vertices.size() == 0;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public Box2D boundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Point2D point : this.vertices) {
            double x = point.x();
            double y = point.y();
            xmin = Math.min(xmin, x);
            xmax = Math.max(xmax, x);
            ymin = Math.min(ymin, y);
            ymax = Math.max(ymax, y);
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public boolean contains(double x, double y) {
        for (LineSegment2D edge : this.edges()) {
            if (edge.length() == 0.0 || !edge.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.x(), point.y());
    }

    @Override
    public CurveSet2D<? extends LinearCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        CurveArray2D<LinearCurve2D> result = new CurveArray2D<LinearCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof LinearCurve2D)) continue;
            result.add((LinearCurve2D)curve2D);
        }
        return result;
    }

    public GeneralPath asGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.vertices.size() < 2) {
            return path;
        }
        return this.appendPath(path);
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.asGeneralPath());
    }
}

