/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.point;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearShape2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.point.PointSet2D;
import math.geom2d.transform.CircleInversion2D;

public class PointArray2D
implements PointSet2D,
CirculinearShape2D,
Cloneable {
    protected ArrayList<Point2D> points = new ArrayList();

    public static <T extends Point2D> PointArray2D create(Collection<T> points) {
        return new PointArray2D(points);
    }

    public static <T extends Point2D> PointArray2D create(T ... points) {
        return new PointArray2D((Point2D[])points);
    }

    public static PointArray2D create(int size) {
        return new PointArray2D(size);
    }

    public PointArray2D() {
        this(0);
    }

    public PointArray2D(int n) {
    }

    public PointArray2D(Point2D ... points) {
        this(points.length);
        for (Point2D element : points) {
            this.points.add(element);
        }
    }

    public PointArray2D(PointSet2D set) {
        this(set.size());
        for (Point2D element : set) {
            this.points.add(element);
        }
    }

    public PointArray2D(Collection<? extends Point2D> points) {
        this(points.size());
        for (Point2D point2D : points) {
            this.points.add(point2D);
        }
    }

    @Override
    public boolean add(Point2D point) {
        return this.points.add(point);
    }

    @Override
    public void add(int index, Point2D point) {
        this.points.add(index, point);
    }

    public void addAll(Point2D[] points) {
        for (Point2D element : points) {
            this.add(element);
        }
    }

    @Override
    public void addAll(Collection<? extends Point2D> points) {
        this.points.addAll(points);
    }

    @Override
    public Point2D get(int index) {
        return this.points.get(index);
    }

    @Override
    public boolean remove(Point2D point) {
        return this.points.remove(point);
    }

    @Override
    public Point2D remove(int index) {
        return this.points.remove(index);
    }

    @Override
    public int indexOf(Point2D point) {
        return this.points.indexOf(point);
    }

    @Override
    public Collection<Point2D> points() {
        return Collections.unmodifiableList(this.points);
    }

    @Override
    public void clear() {
        this.points.clear();
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public PointArray2D transform(CircleInversion2D inv) {
        PointArray2D array = new PointArray2D(this.points.size());
        for (Point2D point : this.points) {
            array.add(point.transform(inv));
        }
        return array;
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        if (this.points.isEmpty()) {
            return Double.NaN;
        }
        double dist = Double.MAX_VALUE;
        for (Point2D point : this.points) {
            dist = Math.min(dist, point.distance(x, y));
        }
        return dist;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public PointArray2D clip(Box2D box) {
        PointArray2D res = new PointArray2D(this.points.size());
        for (Point2D point : this.points) {
            if (!box.contains(point)) continue;
            res.add(point);
        }
        res.points.trimToSize();
        return res;
    }

    @Override
    public Box2D boundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Point2D point : this.points) {
            xmin = Math.min(xmin, point.x());
            ymin = Math.min(ymin, point.y());
            xmax = Math.max(xmax, point.x());
            ymax = Math.max(ymax, point.y());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public PointArray2D transform(AffineTransform2D trans) {
        PointArray2D res = new PointArray2D(this.points.size());
        for (Point2D point : this.points) {
            res.add(point.transform(trans));
        }
        return res;
    }

    @Override
    public boolean contains(double x, double y) {
        for (Point2D point : this.points) {
            if (!(point.distance(x, y) < 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.x(), point.y());
    }

    @Override
    public void draw(Graphics2D g2) {
        this.draw(g2, 1.0);
    }

    public void draw(Graphics2D g2, double r) {
        double w = 2.0 * r;
        for (Point2D point : this.points) {
            double x = point.x();
            double y = point.y();
            g2.fill(new Ellipse2D.Double(x - r, y - r, w, w));
        }
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.points.iterator();
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointSet2D)) {
            return false;
        }
        PointSet2D set = (PointSet2D)obj;
        if (this.points.size() != set.size()) {
            return false;
        }
        Iterator iter = set.iterator();
        for (Point2D point : this.points) {
            if (point.almostEquals((GeometricObject2D)iter.next(), eps)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointSet2D)) {
            return false;
        }
        PointSet2D set = (PointSet2D)obj;
        if (this.points.size() != set.size()) {
            return false;
        }
        Iterator iter = set.iterator();
        for (Point2D point : this.points) {
            if (point.equals(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public PointArray2D clone() {
        PointArray2D set = new PointArray2D(this.size());
        for (Point2D point : this) {
            set.add(point);
        }
        return set;
    }
}

