/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.ShapeArray2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.DomainSet2D;
import math.geom2d.polygon.LinearCurve2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.MultiPolygon2D;
import math.geom2d.polygon.Polygon2D;

public class DomainArray2D<T extends Domain2D>
extends ShapeArray2D<T>
implements DomainSet2D<T> {
    public static <D extends Domain2D> DomainArray2D<D> create(D ... array) {
        return new DomainArray2D(array);
    }

    public DomainArray2D() {
    }

    public DomainArray2D(int n) {
        super(n);
    }

    public DomainArray2D(Collection<T> domains) {
        super(domains);
    }

    public DomainArray2D(T ... domains) {
        super(domains);
    }

    @Override
    public Boundary2D boundary() {
        int n = this.shapes.size();
        ArrayList<? extends Contour2D> boundaries = new ArrayList<Contour2D>(n);
        for (Domain2D domain : this) {
            boundaries.addAll(domain.boundary().continuousCurves());
        }
        return new ContourArray2D(boundaries);
    }

    @Override
    public Collection<? extends Contour2D> contours() {
        return this.boundary().continuousCurves();
    }

    @Override
    public DomainSet2D<? extends Domain2D> complement() {
        int n = this.shapes.size();
        ArrayList<Domain2D> complements = new ArrayList<Domain2D>(n);
        for (Domain2D domain : this) {
            complements.add(domain.complement());
        }
        return new DomainArray2D(complements);
    }

    @Override
    public Polygon2D asPolygon(int n) {
        int nContours = 0;
        for (Domain2D domain : this.shapes) {
            nContours += domain.boundary().continuousCurves().size();
        }
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>(nContours);
        for (Domain2D domain : this.shapes) {
            for (Contour2D contour2D : domain.boundary().continuousCurves()) {
                if (!contour2D.isBounded()) {
                    throw new UnboundedShape2DException(this);
                }
                if (!contour2D.isClosed()) {
                    throw new IllegalArgumentException("Can not transform open curve to linear ring");
                }
                LinearCurve2D poly = contour2D.asPolyline(n);
                assert (poly instanceof LinearRing2D) : "expected result as a linear ring";
                rings.add((LinearRing2D)poly);
            }
        }
        return new MultiPolygon2D(rings);
    }

    @Override
    public void fill(Graphics2D g2) {
        for (Domain2D domain : this) {
            domain.fill(g2);
        }
    }

    @Override
    public DomainArray2D<? extends Domain2D> transform(AffineTransform2D trans) {
        DomainArray2D<Domain2D> result = new DomainArray2D<Domain2D>(this.shapes.size());
        for (Domain2D domain : this) {
            result.add(domain.transform(trans));
        }
        return result;
    }

    @Override
    public Domain2D clip(Box2D box) {
        ArrayList<Domain2D> clippedShapes = new ArrayList<Domain2D>();
        for (Domain2D domain : this) {
            clippedShapes.add(domain.clip(box));
        }
        return new DomainArray2D(clippedShapes);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DomainArray2D)) {
            return false;
        }
        return super.equals(obj);
    }
}

