/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.Vector2D;
import math.geom2d.conic.Hyperbola2D;
import math.geom2d.conic.HyperbolaBranchArc2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.domain.SmoothContour2D;
import math.geom2d.line.LinearShape2D;

public class HyperbolaBranch2D
extends AbstractSmoothCurve2D
implements SmoothContour2D,
Cloneable {
    Hyperbola2D hyperbola = null;
    boolean positive = true;

    public static HyperbolaBranch2D create(Hyperbola2D hyperbola, boolean b) {
        return new HyperbolaBranch2D(hyperbola, b);
    }

    public HyperbolaBranch2D(Hyperbola2D hyperbola, boolean b) {
        this.hyperbola = hyperbola;
        this.positive = b;
    }

    public Hyperbola2D getHyperbola() {
        return this.hyperbola;
    }

    public boolean isPositiveBranch() {
        return this.positive;
    }

    @Override
    public double curvature(double t) {
        double a = this.hyperbola.a;
        double b = this.hyperbola.b;
        double asih = a * Math.sinh(t);
        double bcoh = b * Math.cosh(t);
        return a * b / Math.pow(Math.hypot(bcoh, asih), 3.0);
    }

    @Override
    public Vector2D tangent(double t) {
        double dy;
        double dx;
        double a = this.hyperbola.a;
        double b = this.hyperbola.b;
        double theta = this.hyperbola.theta;
        if (this.positive) {
            dx = a * Math.sinh(t);
            dy = b * Math.cosh(t);
        } else {
            dx = -a * Math.sinh(t);
            dy = -b * Math.cosh(t);
        }
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new Vector2D(dx * cot - dy * sit, dx * sit + dy * cot);
    }

    @Override
    public Domain2D domain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public double signedDistance(Point2D point) {
        double dist = this.distance(point);
        return this.isInside(point) ? -dist : dist;
    }

    @Override
    public double signedDistance(double x, double y) {
        return this.signedDistance(new Point2D(x, y));
    }

    @Override
    public double windingAngle(Point2D point) {
        return 0.0;
    }

    @Override
    public boolean isInside(Point2D point) {
        if (this.hyperbola.isDirect()) {
            if (this.hyperbola.isInside(point)) {
                return true;
            }
            double x = this.hyperbola.toLocal(point).x();
            return this.positive ? x < 0.0 : x > 0.0;
        }
        if (!this.hyperbola.isInside(point)) {
            return false;
        }
        double x = this.hyperbola.toLocal(point).x();
        return this.positive ? x > 0.0 : x < 0.0;
    }

    public Collection<? extends HyperbolaBranch2D> continuousCurves() {
        return HyperbolaBranch2D.wrapCurve(this);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Point2D point(double t) {
        double y;
        double x;
        if (Double.isInfinite(t)) {
            throw new UnboundedShape2DException(this);
        }
        if (this.positive) {
            x = Math.cosh(t);
            if (Double.isInfinite(x)) {
                x = Math.abs(t);
            }
            if (Double.isInfinite(y = Math.sinh(t))) {
                y = t;
            }
        } else {
            x = -Math.cosh(t);
            if (Double.isInfinite(x)) {
                x = -Math.abs(t);
            }
            if (Double.isInfinite(y = -Math.sinh(t))) {
                y = -t;
            }
        }
        return this.hyperbola.toGlobal(new Point2D(x, y));
    }

    @Override
    public double position(Point2D point) {
        Point2D pt = this.hyperbola.toLocal(point);
        double y = this.positive ? pt.y() : -pt.y();
        return Math.log(y + Math.hypot(y, 1.0));
    }

    @Override
    public double project(Point2D point) {
        Point2D pt = this.hyperbola.toLocal(point);
        double y = this.positive ? pt.y() : -pt.y();
        return Math.log(y + Math.hypot(y, 1.0));
    }

    @Override
    public HyperbolaBranch2D reverse() {
        Hyperbola2D hyper2 = new Hyperbola2D(this.hyperbola.xc, this.hyperbola.yc, this.hyperbola.a, this.hyperbola.b, this.hyperbola.theta, !this.hyperbola.direct);
        return new HyperbolaBranch2D(hyper2, this.positive);
    }

    @Override
    public HyperbolaBranchArc2D subCurve(double t0, double t1) {
        return new HyperbolaBranchArc2D(this, t0, t1);
    }

    @Override
    public double t0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        Collection<Point2D> inters = this.hyperbola.intersections(line);
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        for (Point2D point : inters) {
            if (this.hyperbola.toLocal(point).x() > 0.0 ^ this.positive) continue;
            result.add(point);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        return Box2D.INFINITE_BOX;
    }

    @Override
    public CurveSet2D<? extends HyperbolaBranchArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<HyperbolaBranchArc2D> result = new CurveArray2D<HyperbolaBranchArc2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof HyperbolaBranchArc2D)) continue;
            result.add((HyperbolaBranchArc2D)curve2D);
        }
        return result;
    }

    @Override
    public double distance(Point2D point) {
        Point2D projected = this.point(this.project(point));
        return projected.distance(point);
    }

    @Override
    public double distance(double x, double y) {
        Point2D projected = this.point(this.project(new Point2D(x, y)));
        return projected.distance(x, y);
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public HyperbolaBranch2D transform(AffineTransform2D trans) {
        double d2;
        Hyperbola2D hyperbola = this.hyperbola.transform(trans);
        Point2D base = this.point(0.0).transform(trans);
        double d1 = hyperbola.positiveBranch().distance(base);
        return new HyperbolaBranch2D(hyperbola, d1 < (d2 = hyperbola.negativeBranch().distance(base)));
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.x(), point.y());
    }

    @Override
    public boolean contains(double x, double y) {
        if (!this.hyperbola.contains(x, y)) {
            return false;
        }
        Point2D point = this.hyperbola.toLocal(new Point2D(x, y));
        return point.x() > 0.0;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HyperbolaBranch2D)) {
            return false;
        }
        HyperbolaBranch2D branch = (HyperbolaBranch2D)obj;
        if (!this.hyperbola.almostEquals(branch.hyperbola, eps)) {
            return false;
        }
        return this.positive == branch.positive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HyperbolaBranch2D)) {
            return false;
        }
        HyperbolaBranch2D branch = (HyperbolaBranch2D)obj;
        if (!this.hyperbola.equals(branch.hyperbola)) {
            return false;
        }
        return this.positive == branch.positive;
    }

    @Override
    @Deprecated
    public HyperbolaBranch2D clone() {
        return new HyperbolaBranch2D(this.hyperbola.clone(), this.positive);
    }
}

