/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.circulinear.BoundaryPolyCirculinearCurve2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearCurves2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;

public class CirculinearDomains2D {
    public static final CirculinearDomain2D computeBuffer(CirculinearDomain2D domain, double dist) {
        ArrayList<CirculinearContour2D> rings = new ArrayList<CirculinearContour2D>();
        for (CirculinearContour2D circulinearContour2D : domain.contours()) {
            for (CirculinearContinuousCurve2D simpleCurve : CirculinearCurves2D.splitContinuousCurve(circulinearContour2D)) {
                BoundaryPolyCirculinearCurve2D<? extends CirculinearElement2D> boundary = new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(simpleCurve.smoothPieces(), circulinearContour2D.isClosed());
                rings.addAll(CirculinearDomains2D.computeBufferSimpleRing(boundary, dist));
            }
        }
        return new GenericCirculinearDomain2D(new CirculinearContourArray2D(rings));
    }

    public static final Collection<CirculinearContour2D> computeBufferSimpleRing(CirculinearContour2D curve, double d) {
        ArrayList<BoundaryPolyCirculinearCurve2D<? extends CirculinearElement2D>> rings = new ArrayList<BoundaryPolyCirculinearCurve2D<? extends CirculinearElement2D>>();
        CirculinearContour2D parallel1 = curve.parallel(d);
        CirculinearCurveArray2D<CirculinearContinuousCurve2D> curves = new CirculinearCurveArray2D<CirculinearContinuousCurve2D>();
        for (CirculinearContinuousCurve2D split : CirculinearCurves2D.splitContinuousCurve(parallel1)) {
            if (CirculinearCurves2D.findIntersections(curve, split).size() != 0) continue;
            curves.add(split);
        }
        for (CirculinearContinuousCurve2D split : curves) {
            rings.add(new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(split.smoothPieces(), split.isClosed()));
        }
        ArrayList<CirculinearContour2D> rings2 = new ArrayList<CirculinearContour2D>();
        for (CirculinearContour2D circulinearContour2D : rings) {
            for (CirculinearContinuousCurve2D split : CirculinearCurves2D.splitContinuousCurve(circulinearContour2D)) {
                double dist = CirculinearCurves2D.getDistanceCurvePoints(curve, split.singularPoints());
                if (dist - d < -1.0E-12) continue;
                rings2.add(new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(split.smoothPieces(), split.isClosed()));
            }
        }
        return rings2;
    }
}

