/*
 * Decompiled with CFR 0.152.
 */
package jhpro.tseries;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import jhpro.tseries.Peak;
import org.apache.commons.math3.util.FastMath;

public class Multiplet
extends Vector<Peak> {
    private static final long serialVersionUID = 1L;

    public Multiplet() {
    }

    public Multiplet(Peak p) {
        this();
        this.addPeak(p);
    }

    public Peak[] getAllPeaks() {
        Object[] arr = this.toArray();
        Peak[] rval = new Peak[arr.length];
        for (int p = 0; p < arr.length; ++p) {
            rval[p] = (Peak)arr[p];
        }
        return rval;
    }

    public double[] getAllCentroids() {
        Peak[] peaks = this.getAllPeaks();
        double[] centroids = new double[peaks.length];
        if (peaks.length > 0) {
            for (int i = 0; i < peaks.length; ++i) {
                centroids[i] = peaks[i].getPosition();
            }
        }
        return centroids;
    }

    public double[] getCentroidErrors() {
        Peak[] peaks = this.getAllPeaks();
        double[] errors = new double[peaks.length];
        for (int i = 0; i < peaks.length; ++i) {
            errors[i] = peaks[i].getPositionError();
        }
        return errors;
    }

    public void addMultiplet(Multiplet madd) {
        this.addAll(madd);
    }

    public int removeAreaLessThan(double min) {
        Multiplet small = new Multiplet();
        for (int p = 0; p < this.size(); ++p) {
            Peak peak = this.getPeak(p);
            if (!(peak.getArea() < min)) continue;
            small.addPeak(peak);
        }
        this.removeAll(small);
        return this.size();
    }

    public int removeAreaGreaterThan(double max) {
        Multiplet large = new Multiplet();
        for (int p = 0; p < this.size(); ++p) {
            Peak peak = this.getPeak(p);
            if (!(peak.getArea() > max)) continue;
            large.addPeak(peak);
        }
        this.removeAll(large);
        return this.size();
    }

    public Peak getPeakNear(double centroid, double tolerance) {
        Peak p1;
        double diff1 = 2.0 * tolerance;
        Iterator<Peak> it = new TreeSet<Peak>(this).iterator();
        if (it.hasNext()) {
            p1 = it.next();
            diff1 = FastMath.abs((double)(p1.getPosition() - centroid));
        } else {
            return null;
        }
        while (it.hasNext()) {
            Peak p2 = it.next();
            double diff2 = FastMath.abs((double)(p2.getPosition() - centroid));
            if (!(diff2 < diff1)) continue;
            p1 = p2;
            diff1 = diff2;
        }
        if (diff1 <= tolerance) {
            return p1;
        }
        return null;
    }

    public Multiplet lastPeaks(int n) {
        Multiplet rval = new Multiplet();
        for (int i = this.size() - n; i < this.size(); ++i) {
            rval.addPeak(this.getPeak(i));
        }
        return rval;
    }

    static Multiplet combineMultiplets(Multiplet[] marray) {
        Multiplet rval = new Multiplet();
        for (int i = 0; i < marray.length; ++i) {
            rval.addMultiplet(marray[i]);
        }
        return rval;
    }

    static Multiplet combineMultiplets(Multiplet m0, Multiplet m1) {
        Multiplet[] temp = new Multiplet[]{m0, m1};
        return Multiplet.combineMultiplets(temp);
    }

    public void addPeak(Peak p) {
        if (p != null) {
            this.addElement(p);
        }
    }

    public Peak getPeak(int index) {
        return (Peak)this.elementAt(index);
    }
}

