/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat.limit;

import java.util.ArrayList;
import java.util.Random;
import jhpro.stat.limit.ExpData;
import org.apache.commons.math3.util.FastMath;

public class StatConfidence {
    static final double EPSILON = 1.0E-4;
    double sensitivity;
    double sigma;
    double limitguess;
    double NMCevents;
    ArrayList<ExpData> expdata;
    private Random rrr;
    private double R1;
    private double R2;
    private double R3;
    private double Q1;
    private double Q2;
    private double Q3;
    private boolean allzero;
    private double pole;
    private double outSWG;
    private double outCH;
    private double outJ;

    public StatConfidence(double sensitivity, double sigma, double limitguess, int NMCevents) {
        this.sensitivity = sensitivity;
        this.sigma = sigma;
        this.limitguess = limitguess;
        this.NMCevents = NMCevents;
        this.rrr = new Random();
        this.expdata = new ArrayList();
        this.R3 = 0.0;
    }

    public StatConfidence(double limitguess, int NMCevents) {
        this(1.0, 0.0, limitguess, NMCevents);
    }

    public void addData(ExpData data) {
        this.expdata.add(data);
    }

    public void getDataSize() {
        this.expdata.size();
    }

    public boolean runUpper() {
        return this.run(true);
    }

    public boolean runLower() {
        return this.run(false);
    }

    public boolean run(boolean isUpper) {
        boolean tmp = true;
        double epsilon = 0.0;
        this.allzero = false;
        epsilon = isUpper ? 1.0E-4 : -1.0E-4;
        this.pole = 1.0;
        for (int i = 0; i < this.expdata.size(); ++i) {
            if (this.expdata.get(i).getNobs() == 0) continue;
            this.allzero = false;
            double p = -this.expdata.get(i).getBack() / this.expdata.get(i).getFraction();
            if (!(p > this.pole) && !(this.pole > 0.0)) continue;
            this.pole = p;
        }
        int NMAX = this.expdata.size();
        int[] nobs = new int[NMAX];
        for (int i = 0; i < NMAX; ++i) {
            nobs[i] = this.expdata.get(i).getNobs();
        }
        double p = this.pole / this.sensitivity;
        this.R1 = 0.0;
        while (true) {
            double d;
            this.Q1 = this.q(this.R1, nobs, this.sensitivity);
            if (!(d < 0.0)) break;
            this.R1 = (p + this.R1) / 2.0;
        }
        this.R2 = 1.0;
        while (true) {
            double d;
            this.Q2 = this.q(this.R2, nobs, this.sensitivity);
            if (!(d > 0.0)) break;
            this.R2 *= 2.0;
        }
        int safetycount = 0;
        do {
            this.R3 = 0.5 * (this.R1 + this.R2);
            this.Q3 = this.q(this.R3, nobs, this.sensitivity);
            if (this.Q1 * this.Q3 > 0.0) {
                this.R1 = this.R3;
                this.Q1 = this.Q3;
                continue;
            }
            this.R2 = this.R3;
            this.Q2 = this.Q3;
        } while (!(FastMath.abs((double)this.Q3) <= (double)1.4E-44f) && ++safetycount <= 100 && !(FastMath.abs((double)(this.R1 - this.R2)) <= (double)1.4E-44f));
        int scoreSWG = 0;
        int scoreCH = 0;
        int scoreJ = 0;
        int[] resultSWG = new int[NMAX];
        int[] resultCH = new int[NMAX];
        int[] resultJ = new int[NMAX];
        int j = 0;
        while ((double)j < this.NMCevents) {
            boolean gotallzeroSWG = true;
            boolean gotallzeroCH = true;
            boolean gotallzeroJ = true;
            double thing = this.sigma * this.rrr.nextGaussian() / this.sensitivity;
            double aCH = this.sensitivity * (1.0 + thing);
            double aSWG = this.sensitivity / (1.0 + thing);
            double aJ = this.sensitivity * FastMath.exp((double)thing);
            for (int i = 0; i < NMAX; ++i) {
                thing = this.expdata.get(i).getErrFraction() * this.rrr.nextGaussian() / this.expdata.get(i).getFraction();
                double cCH = this.expdata.get(i).getFraction() * (1.0 + thing);
                double cSWG = this.expdata.get(i).getFraction() / (1.0 + thing);
                double cJ = this.expdata.get(i).getFraction() * FastMath.exp((double)thing);
                double b = this.expdata.get(i).getBack() + this.expdata.get(i).getErrBack() * this.rrr.nextGaussian();
                resultSWG[i] = this.prand(this.limitguess * aSWG * cSWG + b);
                if (resultSWG[i] != 0) {
                    gotallzeroSWG = false;
                }
                resultCH[i] = this.prand(this.limitguess * aCH * cCH + b);
                if (resultCH[i] != 0) {
                    gotallzeroCH = false;
                }
                resultJ[i] = this.prand(this.limitguess * aJ * cJ + b);
                if (resultJ[i] == 0) continue;
                gotallzeroJ = false;
            }
            if (this.allzero) {
                if (gotallzeroSWG) {
                    ++scoreSWG;
                }
                if (gotallzeroCH) {
                    ++scoreCH;
                }
                if (gotallzeroJ) {
                    ++scoreJ;
                }
            } else {
                if (this.q(this.R3, resultSWG, this.sensitivity) < epsilon) {
                    ++scoreSWG;
                }
                if (this.q(this.R3, resultCH, this.sensitivity) < epsilon) {
                    ++scoreCH;
                }
                if (this.q(this.R3, resultJ, this.sensitivity) < epsilon) {
                    ++scoreJ;
                }
            }
            ++j;
        }
        this.outSWG = (double)scoreSWG / this.NMCevents;
        this.outCH = (double)scoreCH / this.NMCevents;
        this.outJ = (double)scoreJ / this.NMCevents;
        return tmp;
    }

    private double q(double R, int[] n, double c) {
        double result = 0.0;
        for (int i = 0; i < this.expdata.size(); ++i) {
            double cs = c * this.expdata.get(i).getFraction();
            result += (double)n[i] * cs / (R * cs + this.expdata.get(i).getBack()) - cs;
        }
        return result;
    }

    private int prand(double f) {
        if (f < 0.0) {
            return 0;
        }
        double prob = this.rrr.nextDouble();
        int n = 0;
        double probi = FastMath.exp((double)(-f));
        while (n < 1000) {
            if ((prob -= probi) <= 0.0) {
                return n;
            }
            probi *= f / (double)(++n);
        }
        return 0;
    }

    public double getProbabilityCH() {
        return this.outCH;
    }

    public double getProbabilitySWG() {
        return this.outSWG;
    }

    public double getProbabilityJ() {
        return this.outJ;
    }

    public void setLimitGuess(double limitguess) {
        this.limitguess = limitguess;
    }

    public void setNMC(double NMC) {
        this.NMCevents = NMC;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setSensitivityError(double sigma) {
        this.sigma = sigma;
    }

    public double getLimitGuess() {
        return this.limitguess;
    }

    public double getNMC() {
        return this.NMCevents;
    }

    public ArrayList<ExpData> getExpData() {
        return this.expdata;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public double getSensitivityError() {
        return this.sigma;
    }
}

