/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import org.apache.commons.math3.util.FastMath;

public class EEcentricity {
    double varMin = 1.0;
    double varMax = 1.0;
    double Theta = 0.0;
    double[] w;
    double[] x;
    double[] y;

    public EEcentricity(double[] x, double[] y, double[] w) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.eval();
    }

    public EEcentricity(P1D p1d) {
        int size = p1d.size();
        this.w = new double[size];
        for (int i = 0; i < size; ++i) {
            this.w[i] = 1.0;
        }
        this.x = p1d.getArrayX();
        this.y = p1d.getArrayY();
        this.eval();
    }

    private void eval() {
        int j;
        int num = this.x.length;
        double etaSum = 0.0;
        double phiSum = 0.0;
        double eTot = 0.0;
        double[] Dphi = new double[num];
        double[] Deta = new double[num];
        for (j = 0; j < num; ++j) {
            etaSum += this.x[j] * this.w[j];
            phiSum += this.y[j] * this.w[j];
            eTot += this.w[j];
        }
        etaSum /= eTot;
        phiSum /= eTot;
        for (j = 0; j < num; ++j) {
            Deta[j] = this.x[j] - etaSum;
            Dphi[j] = this.y[j] - phiSum;
        }
        double X1 = 0.0;
        double X2 = 0.0;
        for (int i = 0; i < num; ++i) {
            X1 += 2.0 * this.w[i] * Deta[i] * Dphi[i];
            X2 += this.w[i] * (Dphi[i] * Dphi[i] - Deta[i] * Deta[i]);
        }
        this.Theta = 0.5 * FastMath.atan((double)(X1 / X2));
        double sinTheta = FastMath.sin((double)this.Theta);
        double cosTheta = FastMath.cos((double)this.Theta);
        double VarX = 0.0;
        double VarY = 0.0;
        for (int i = 0; i < num; ++i) {
            double X = cosTheta * Deta[i] - sinTheta * Dphi[i];
            double Y = sinTheta * Deta[i] + cosTheta * Dphi[i];
            VarX += this.w[i] * X * X;
            VarY += this.w[i] * Y * Y;
        }
        this.varMax = VarX;
        this.varMin = VarY;
        if (this.varMax < this.varMin) {
            this.varMax = VarY;
            this.varMin = VarX;
        }
    }

    public double getAngle() {
        return this.Theta;
    }

    public double getVarianceMin() {
        return this.varMin;
    }

    public double getVarianceMax() {
        return this.varMax;
    }

    public double getEccentricity() {
        return 1.0 - this.varMin / this.varMax;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

