/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import jhplot.H1D;
import jhplot.gui.HelpBrowser;
import jhplot.math.SortUtils;
import org.apache.commons.math3.util.FastMath;

public class ConfidenceLevel {
    double fgMCLM2S = 0.025;
    double fgMCLM1S = 0.16;
    double fgMCLMED = 0.5;
    double fgMCLP1S = 0.84;
    double fgMCLP2S = 0.975;
    double fgMCL3S1S = 0.0026998;
    double fgMCL5S1S = 5.733E-7;
    double fgMCL3S2S = 0.001349898;
    double fgMCL5S2S = 2.866516E-7;
    double fStot = 0.0;
    double fBtot = 0.0;
    double fDtot = 0.0;
    double fTSD = 0.0;
    int fNMC;
    int fNNMC;
    double fMCL3S;
    double fMCL5S;
    double[] fTSB = null;
    double[] fTSS = null;
    double[] fLRS = null;
    double[] fLRB = null;
    int[] fISS;
    int[] fISB;
    private Comparator cmp = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    public ConfidenceLevel() {
        this.fNMC = 0;
        this.fNNMC = 0;
        this.fISS = new int[1];
        this.fISB = new int[1];
        this.fMCL3S = this.fgMCL3S1S;
        this.fMCL5S = this.fgMCL5S1S;
    }

    public ConfidenceLevel(int mc) {
        this(mc, true);
    }

    public ConfidenceLevel(int mc, boolean onesided) {
        this.fNMC = mc;
        this.fNNMC = mc;
        this.fISS = new int[mc];
        this.fISB = new int[mc];
        this.fMCL3S = onesided ? this.fgMCL3S1S : this.fgMCL3S2S;
        this.fMCL5S = onesided ? this.fgMCL5S1S : this.fgMCL5S2S;
    }

    public double getExpectedStatistic_b(int sigma) {
        switch (sigma) {
            case -2: {
                return -2.0 * (this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP2S))))]] - this.fStot);
            }
            case -1: {
                return -2.0 * (this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP1S))))]] - this.fStot);
            }
            case 0: {
                return -2.0 * (this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLMED))))]] - this.fStot);
            }
            case 1: {
                return -2.0 * (this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM1S))))]] - this.fStot);
            }
            case 2: {
                return -2.0 * (this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM2S))))]] - this.fStot);
            }
        }
        return 0.0;
    }

    public double getExpectedStatistic_sb(int sigma) {
        switch (sigma) {
            case -2: {
                return -2.0 * (this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP2S))))]] - this.fStot);
            }
            case -1: {
                return -2.0 * (this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP1S))))]] - this.fStot);
            }
            case 0: {
                return -2.0 * (this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLMED))))]] - this.fStot);
            }
            case 1: {
                return -2.0 * (this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM1S))))]] - this.fStot);
            }
            case 2: {
                return -2.0 * (this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM2S))))]] - this.fStot);
            }
        }
        return 0.0;
    }

    public double getCLb() {
        return this.getCLb(false);
    }

    public double getCLb(boolean use_sMC) {
        int use = 0;
        if (!use_sMC) {
            use = 1;
        }
        if (use_sMC) {
            use = 2;
        }
        double result = 0.0;
        switch (use) {
            case 1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] < this.fTSD)) continue;
                    result = (double)(i + 1) / (double)this.fNMC;
                }
                return result;
            }
            case 2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] < this.fTSD)) continue;
                    result += 1.0 / (this.fLRS[this.fISS[i]] * (double)this.fNMC);
                }
                return result;
            }
        }
        return result;
    }

    public double getCLsb() {
        return this.getCLsb(false);
    }

    public double getCLsb(boolean use_sMC) {
        int use = 0;
        if (!use_sMC) {
            use = 1;
        }
        if (use_sMC) {
            use = 2;
        }
        double result = 0.0;
        switch (use) {
            case 1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSD)) continue;
                    result += this.fLRB[this.fISB[i]] / (double)this.fNMC;
                }
                return result;
            }
            case 2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] <= this.fTSD)) continue;
                    result = i / this.fNMC;
                }
                return result;
            }
        }
        return result;
    }

    public double getCLs() {
        return this.getCLs(false);
    }

    public double getCLs(boolean use_sMC) {
        double clb = this.getCLb(false);
        double clsb = this.getCLsb(use_sMC);
        if (clb == 0.0) {
            System.out.println("Warning: clb = 0 !");
            return 0.0;
        }
        return clsb / clb;
    }

    public double getExpectedCLsb_b(int sigma) {
        double result = 0.0;
        switch (sigma) {
            case -2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP2S))))]])) continue;
                    result += this.fLRB[this.fISB[i]] / (double)this.fNMC;
                }
                return result;
            }
            case -1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP1S))))]])) continue;
                    result += this.fLRB[this.fISB[i]] / (double)this.fNMC;
                }
                return result;
            }
            case 0: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLMED))))]])) continue;
                    result += this.fLRB[this.fISB[i]] / (double)this.fNMC;
                }
                return result;
            }
            case 1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM1S))))]])) continue;
                    result += this.fLRB[this.fISB[i]] / (double)this.fNMC;
                }
                return result;
            }
            case 2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM2S))))]])) continue;
                    result += this.fLRB[this.fISB[i]] / (double)this.fNMC;
                }
                return result;
            }
        }
        return 0.0;
    }

    public double getExpectedCLb_sb(int sigma) {
        double result = 0.0;
        switch (sigma) {
            case 2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] <= this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP2S))))]])) continue;
                    result += this.fLRS[this.fISS[i]] / (double)this.fNMC;
                }
                return result;
            }
            case 1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] <= this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP1S))))]])) continue;
                    result += this.fLRS[this.fISS[i]] / (double)this.fNMC;
                }
                return result;
            }
            case 0: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] <= this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLMED))))]])) continue;
                    result += this.fLRS[this.fISS[i]] / (double)this.fNMC;
                }
                return result;
            }
            case -1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] <= this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM1S))))]])) continue;
                    result += this.fLRS[this.fISS[i]] / (double)this.fNMC;
                }
                return result;
            }
            case -2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSS[this.fISS[i]] <= this.fTSS[this.fISS[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM2S))))]])) continue;
                    result += this.fLRS[this.fISS[i]] / (double)this.fNMC;
                }
                return result;
            }
        }
        return 0.0;
    }

    public double getExpectedCLb_b(int sigma) {
        double result = 0.0;
        switch (sigma) {
            case 2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM2S))))]])) continue;
                    result = (double)(i + 1) / (double)this.fNMC;
                }
                return result;
            }
            case 1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLM1S))))]])) continue;
                    result = (double)(i + 1) / (double)this.fNMC;
                }
                return result;
            }
            case 0: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLMED))))]])) continue;
                    result = (double)(i + 1) / (double)this.fNMC;
                }
                return result;
            }
            case -1: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP1S))))]])) continue;
                    result = (double)(i + 1) / (double)this.fNMC;
                }
                return result;
            }
            case -2: {
                for (int i = 0; i < this.fNMC; ++i) {
                    if (!(this.fTSB[this.fISB[i]] <= this.fTSB[this.fISB[FastMath.min((int)this.fNMC, (int)FastMath.max((int)1, (int)((int)((double)this.fNMC * this.fgMCLP2S))))]])) continue;
                    result = (double)(i + 1) / (double)this.fNMC;
                }
                return result;
            }
        }
        return result;
    }

    public double getAverageCLsb() {
        double result = 0.0;
        double psumsb = 0.0;
        for (int i = 0; i < this.fNMC; ++i) {
            result += (psumsb += this.fLRB[this.fISB[i]] / (double)this.fNMC) / (double)this.fNMC;
        }
        return result;
    }

    public double getAverageCLs() {
        double result = 0.0;
        double psumsb = 0.0;
        for (int i = 0; i < this.fNMC; ++i) {
            result += (psumsb += this.fLRB[this.fISB[i]] / (double)this.fNMC) / (double)this.fNMC / (double)((i + 1) / this.fNMC);
        }
        return result;
    }

    public double get3sProbability() {
        double result = 0.0;
        double psumbs = 0.0;
        for (int i = 0; i < this.fNMC; ++i) {
            if (!((psumbs += 1.0 / (this.fLRS[this.fISS[this.fNMC - i]] * (double)this.fNMC)) <= this.fMCL3S)) continue;
            result = i / this.fNMC;
        }
        return result;
    }

    public double get5sProbability() {
        double result = 0.0;
        double psumbs = 0.0;
        for (int i = 0; i < this.fNMC; ++i) {
            if (!((psumbs += 1.0 / (this.fLRS[this.fISS[this.fNMC - i]] * (double)this.fNMC)) <= this.fMCL5S)) continue;
            result = i / this.fNMC;
        }
        return result;
    }

    public ArrayList<H1D> getResults(String Option) {
        int i;
        H1D h = new H1D("TConfidenceLevel_Draw", 50, 0.0, 0.0);
        for (i = 0; i < this.fNMC; ++i) {
            h.fill(-2.0 * (this.fTSB[i] - this.fStot));
            h.fill(-2.0 * (this.fTSS[i] - this.fStot));
        }
        H1D b_hist = new H1D("-2lnQ", 50, h.getMin(), h.getMax());
        H1D sb_hist = new H1D("-2lnQ", 50, h.getMin(), h.getMax());
        for (i = 0; i < this.fNMC; ++i) {
            b_hist.fill(-2.0 * (this.fTSB[i] - this.fStot));
            sb_hist.fill(-2.0 * (this.fTSS[i] - this.fStot));
        }
        sb_hist.setColor(Color.red);
        ArrayList<H1D> arr = new ArrayList<H1D>();
        arr.add(b_hist);
        arr.add(sb_hist);
        return arr;
    }

    public void setTSD(double in) {
        this.fTSD = in;
    }

    public void setLRS(double[] in) {
        this.fLRS = in;
    }

    public void setLRB(double[] in) {
        this.fLRB = in;
    }

    public void setBtot(double in) {
        this.fBtot = in;
    }

    public void setStot(double in) {
        this.fStot = in;
    }

    public void setDtot(int in) {
        this.fDtot = in;
    }

    public double getStatistic() {
        return -2.0 * (this.fTSD - this.fStot);
    }

    public void setTSB(double[] in) {
        this.fTSB = in;
        Object[] clone = new Double[in.length];
        for (int i = 0; i < in.length; ++i) {
            clone[i] = new Double(in[i]);
        }
        this.fISB = SortUtils.identity(this.fNNMC);
        SortUtils.sort(this.fISB, clone, this.cmp, true);
    }

    public void setTSS(double[] in) {
        this.fTSS = in;
        Object[] clone = new Double[in.length];
        for (int i = 0; i < in.length; ++i) {
            clone[i] = new Double(in[i]);
        }
        this.fISS = SortUtils.identity(this.fNNMC);
        SortUtils.sort(this.fISS, clone, this.cmp, true);
    }

    public double getExpectedStatistic_b() {
        return this.getExpectedStatistic_b(0);
    }

    public double getExpectedCLb_sb() {
        return this.getExpectedCLb_sb(0);
    }

    public double getExpectedCLs_b(int sigma) {
        return this.getExpectedCLsb_b(sigma) / this.getExpectedCLb_b(sigma);
    }

    public double getExpectedCLs_b() {
        return this.getExpectedCLsb_b(0) / this.getExpectedCLb_b(0);
    }

    public double getExpectedCLb_b() {
        return this.getExpectedCLb_b(0);
    }

    public double getExpectedCLsb_b() {
        return this.getExpectedCLsb_b(0);
    }

    public H1D getLNQb(int bins, double min, double max) {
        H1D tmp = new H1D("-2lnQ(B)", bins, min, max);
        for (int i = 0; i < this.fNMC; ++i) {
            tmp.fill(-2.0 * (this.fTSB[i] - this.fStot));
        }
        return tmp;
    }

    public H1D getLNQsb(int bins, double min, double max) {
        H1D tmp = new H1D("-2lnQ(S+B)", bins, min, max);
        for (int i = 0; i < this.fNMC; ++i) {
            tmp.fill(-2.0 * (this.fTSS[i] - this.fStot));
        }
        return tmp;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

