/*
 * Decompiled with CFR 0.152.
 */
package jhpro.stat;

import java.util.ArrayList;
import java.util.Random;
import jhplot.H1D;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.math.Poisson;
import jhpro.stat.ConfidenceLevel;
import jhpro.stat.DataKeeper;
import jhpro.stat.DataSource;
import org.apache.commons.math3.util.FastMath;

public class CLimits {
    private int nmc;
    private boolean stat;
    private DataSource data;
    private double[] fgTable;
    private Random generator;

    public CLimits(DataSource data, int nmc) {
        this.data = data;
        this.nmc = nmc;
        this.stat = true;
    }

    public CLimits(DataSource data, int nmc, boolean stat) {
        this.data = data;
        this.nmc = nmc;
        this.stat = stat;
    }

    public CLimits(H1D s, H1D b, H1D d, int nmc) {
        this(new DataSource(s, b, d), nmc, true);
    }

    public CLimits(P1D s, P1D b, P1D d, int nmc) {
        this(new DataSource(s, b, d), nmc, true);
    }

    public CLimits(H1D s, H1D b, H1D d, double se, double be, double de, String l, int nmc) {
        this(new DataSource(s, b, d, se, be, de, l), nmc, true);
    }

    public ConfidenceLevel getLimit() {
        return this.getLimit(new Random());
    }

    public ConfidenceLevel getLimit(Random generator) {
        int i;
        this.generator = generator;
        if (generator == null) {
            this.generator = new Random();
        }
        Poisson myrandom = new Poisson(this.generator, 0.0);
        ConfidenceLevel result = new ConfidenceLevel(this.nmc);
        int maxbins = 0;
        double nsig = 0.0;
        double nbg = 0.0;
        int ncand = 0;
        for (i = 0; i < this.data.getSignal().size(); ++i) {
            maxbins = this.data.getSignal().get(i).getSize() > maxbins ? this.data.getSignal().get(i).getSize() : maxbins;
            nsig += this.data.getSignal().get(i).getIntegral();
            nbg += this.data.getBackground().get(i).getIntegral();
            ncand += (int)this.data.getCandidates().get(i).getIntegral();
        }
        result.setBtot(nbg);
        result.setStot(nsig);
        result.setDtot(ncand);
        double buffer = 0.0;
        this.fgTable = new double[maxbins * (this.data.getSignal().size() + 1)];
        for (int channel = 0; channel < this.data.getSignal().size(); ++channel) {
            for (int bin = 0; bin < this.data.getSignal().get(channel).getSize(); ++bin) {
                double s = this.data.getSignal().get(channel).getValue(bin);
                double b = this.data.getBackground().get(channel).getValue(bin);
                double d = this.data.getCandidates().get(channel).getValue(bin);
                if (b == 0.0 && s > 0.0) {
                    System.out.println("WARNING: Ignoring bin " + Integer.toString(bin) + " which has s=" + Double.toString(s) + " and b=" + Double.toString(b));
                    System.out.println(" -> Maybe the MC statistic has to be improved...");
                }
                if (s > 0.0 && b > 0.0) {
                    buffer += this.LogLikelihood(s, b, b, d);
                }
                if (s > 0.0 && b > 0.0) {
                    this.fgTable[channel * maxbins + bin] = this.LogLikelihood(s, b, b, 1.0);
                    continue;
                }
                if (!(s > 0.0) || b != 0.0) continue;
                this.fgTable[channel * maxbins + bin] = 20.0;
            }
        }
        result.setTSD(buffer);
        double[] tss = new double[this.nmc];
        double[] tsb = new double[this.nmc];
        double[] lrs = new double[this.nmc];
        double[] lrb = new double[this.nmc];
        for (i = 0; i < this.nmc; ++i) {
            tss[i] = 0.0;
            tsb[i] = 0.0;
            lrs[i] = 0.0;
            lrb[i] = 0.0;
            DataSource fluctuated = this.fluctuate(this.data, generator, this.stat);
            DataSource fluctuated2 = this.fluctuate(this.data, generator, this.stat);
            for (int channel = 0; channel < fluctuated.getSignal().size(); ++channel) {
                for (int bin = 0; bin < fluctuated.getSignal().get(channel).getSize(); ++bin) {
                    if (fluctuated.getSignal().get(channel).getValue(bin) == 0.0) continue;
                    double rate = fluctuated.getSignal().get(channel).getValue(bin) + fluctuated.getBackground().get(channel).getValue(bin);
                    double rand = myrandom.next(rate);
                    int n = i;
                    tss[n] = tss[n] + rand * this.fgTable[channel * maxbins + bin];
                    double s = fluctuated.getSignal().get(channel).getValue(bin);
                    double s2 = fluctuated2.getSignal().get(channel).getValue(bin);
                    double b = fluctuated.getBackground().get(channel).getValue(bin);
                    double b2 = fluctuated2.getBackground().get(channel).getValue(bin);
                    if (s > 0.0 && b2 > 0.0) {
                        int n2 = i;
                        lrs[n2] = lrs[n2] + (this.LogLikelihood(s, b, b2, rand) - s - b + b2);
                    } else if (s > 0.0 && b2 == 0.0) {
                        int n3 = i;
                        lrs[n3] = lrs[n3] + (20.0 * rand - s);
                    }
                    rate = fluctuated.getBackground().get(channel).getValue(bin);
                    rand = myrandom.next(rate);
                    int n4 = i;
                    tsb[n4] = tsb[n4] + rand * this.fgTable[channel * maxbins + bin];
                    if (s2 > 0.0 && b > 0.0) {
                        int n5 = i;
                        lrb[n5] = lrb[n5] + (this.LogLikelihood(s2, b2, b, rand) - s2 - b2 + b);
                        continue;
                    }
                    if (!(s > 0.0) || b != 0.0) continue;
                    int n6 = i;
                    lrb[n6] = lrb[n6] + (20.0 * rand - s);
                }
            }
            lrs[i] = FastMath.exp((double)(lrs[i] < 710.0 ? lrs[i] : 710.0));
            lrb[i] = FastMath.exp((double)(lrb[i] < 710.0 ? lrb[i] : 710.0));
        }
        result.setTSS(tss);
        result.setTSB(tsb);
        result.setLRS(lrs);
        result.setLRB(lrb);
        return result;
    }

    private DataSource fluctuate(DataSource input, Random generator, boolean stat) {
        ArrayList<Double> fgSysErrorSignal = input.getErrorOnSignal();
        ArrayList<Double> fgSysErrorBackground = input.getErrorOnBackground();
        ArrayList<Double> fgSysErrorData = input.getErrorOnData();
        DataSource output = new DataSource();
        for (int channel = 0; channel < input.getSignal().size(); ++channel) {
            DataKeeper olddata = input.getCandidates().get(channel);
            DataKeeper oldsignal = input.getSignal().get(channel);
            DataKeeper newsignal = new DataKeeper(oldsignal.getSize());
            newsignal.setTitle(oldsignal.getTitle());
            DataKeeper newdata = olddata.copy();
            double sysErrorSignal = fgSysErrorSignal.get(channel);
            double sysErrorBackground = fgSysErrorBackground.get(channel);
            double sysErrorData = fgSysErrorData.get(channel);
            if (stat) {
                for (int i = 0; i < oldsignal.getSize(); ++i) {
                    newsignal.setValue(i, oldsignal.getValue(i) + oldsignal.getError(i) * generator.nextGaussian());
                    newsignal.setError(i, oldsignal.getError(i));
                }
            } else {
                newsignal = oldsignal.copy();
            }
            if (sysErrorSignal != 0.0) {
                newsignal.scale(1.0 + sysErrorSignal);
            }
            DataKeeper oldbackground = input.getBackground().get(channel);
            DataKeeper newbackground = new DataKeeper(oldbackground.getSize());
            newbackground.setTitle(oldbackground.getTitle());
            if (stat) {
                for (int i = 0; i < oldbackground.getSize(); ++i) {
                    newbackground.setValue(i, oldbackground.getValue(i) + oldbackground.getError(i) * generator.nextGaussian());
                    newbackground.setError(i, oldbackground.getError(i));
                }
            } else {
                newbackground = oldbackground.copy();
            }
            if (sysErrorBackground != 0.0) {
                newbackground.scale(1.0 + sysErrorBackground);
            }
            if (sysErrorData != 0.0) {
                newdata.scale(1.0 + sysErrorData);
            }
            output.addChannel(newsignal, newbackground, newdata);
        }
        return output;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    double LogLikelihood(double s, double b, double b2, double d) {
        return d * FastMath.log((double)((s + b) / b2));
    }
}

