/*
 * Decompiled with CFR 0.152.
 */
package jhpro.sregression;

import java.util.HashMap;
import jhpro.sregression.ApplicationData;
import jhpro.sregression.SymRegression;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPFitnessFunction;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class FormulaFitnessFunction
extends GPFitnessFunction {
    private static final long serialVersionUID = 1L;

    @Override
    protected double evaluate(IGPProgram a_subject) {
        return this.computeRawFitness(a_subject);
    }

    public double computeRawFitness(IGPProgram ind) {
        double error = 0.0;
        Object[] noargs = new Object[]{};
        double penalty = 0.0;
        ProgramChromosome chrom = ind.getChromosome(0);
        int numTerms = chrom.numFunctions() + chrom.numTerminals();
        if (SymRegression.minNodes >= 0 && numTerms < SymRegression.minNodes) {
            penalty += (double)Math.abs(numTerms - SymRegression.minNodes) * SymRegression.minNodesPenalty;
        }
        if (SymRegression.alldifferentVariables) {
            CommandGene[] functions = chrom.getFunctions();
            HashMap<String, Integer> countVariables = new HashMap<String, Integer>();
            for (int i = 0; i < functions.length; ++i) {
                CommandGene func = functions[i];
                if (func == null) continue;
                int arity = func.getArity(ind);
                String funcStr = func.toString();
                if (arity != 0) continue;
                Class returnType = func.getReturnType();
                int subReturnType = func.getSubReturnType();
                if (!countVariables.containsKey(funcStr)) {
                    countVariables.put(funcStr, 1);
                    continue;
                }
                penalty += SymRegression.alldifferentVariablesPenalty;
                countVariables.put(funcStr, (Integer)countVariables.get(funcStr) + 1);
            }
        }
        int thisNumHits = 0;
        double[] results = new double[SymRegression.numRows];
        double[] errors = new double[SymRegression.numRows];
        for (int j = 0; j < SymRegression.numRows; ++j) {
            int variableIndex = 0;
            for (int i = 0; i < SymRegression.numInputVariables + 1; ++i) {
                if (i == SymRegression.outputVariable) continue;
                SymRegression.variables[variableIndex].set(SymRegression.data[i][j]);
                ++variableIndex;
            }
            try {
                double diff;
                double result;
                results[j] = result = ind.execute_double(0, noargs);
                double res = SymRegression.data[SymRegression.outputVariable][j];
                errors[j] = diff = Math.abs(result - res) + penalty;
                if (SymRegression.hitsCriteria >= 0.0) {
                    if (Double.isInfinite(result) || Double.isNaN(result) || Double.isInfinite(diff) || Double.isNaN(diff) || diff > SymRegression.hitsCriteria) {
                        error += 1.0 + penalty;
                    }
                } else {
                    error += diff;
                }
                if (diff <= SymRegression.hitsCriteria) {
                    ++thisNumHits;
                }
                if (!Double.isInfinite(error) && !Double.isNaN(error)) continue;
                return Double.MAX_VALUE;
            }
            catch (ArithmeticException ex) {
                System.out.println(ind);
                throw ex;
            }
        }
        double[] errs = SymRegression.calcAllErrors(error, errors);
        if (SymRegression.hitsCriteria < 0.0) {
            error = errs[0];
        }
        double totalError = errs[1];
        double minError = errs[2];
        double maxError = errs[3];
        double meanError = errs[4];
        double medianError = errs[5];
        double correlation = SymRegression.correlation(SymRegression.data[SymRegression.outputVariable], results, results.length);
        ApplicationData appData = SymRegression.showResults ? new ApplicationData(error, correlation, thisNumHits, minError, maxError, meanError, medianError, totalError, results) : new ApplicationData(error, correlation, thisNumHits, minError, maxError, meanError, medianError, totalError);
        ind.setApplicationData(appData);
        if (SymRegression.scaleError > 0.0) {
            return error * SymRegression.scaleError;
        }
        return error;
    }
}

