/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import java.util.Random;
import jhpro.nnet.jknnl.ActivationFunctionModel;
import jhpro.nnet.jknnl.MetricModel;
import jhpro.nnet.jknnl.NeuronModel;

public class KohonenNeuron
implements NeuronModel {
    private double[] weight;
    private ActivationFunctionModel activationFunction;
    private MetricModel distanceFunction;

    public KohonenNeuron(int weightNumber, double[] maxWeight, ActivationFunctionModel activationFunction) {
        if (weightNumber == maxWeight.length) {
            Random rand = new Random();
            this.weight = new double[weightNumber];
            for (int i = 0; i < weightNumber; ++i) {
                this.weight[i] = rand.nextDouble() * maxWeight[i];
            }
        }
        this.activationFunction = activationFunction;
    }

    public KohonenNeuron(double[] weightArray, ActivationFunctionModel activationFunction) {
        int weightSize = weightArray.length;
        this.weight = new double[weightSize];
        for (int i = 0; i < weightSize; ++i) {
            this.weight[i] = weightArray[i];
        }
        this.activationFunction = activationFunction;
    }

    @Override
    public double[] getWeight() {
        return (double[])this.weight.clone();
    }

    @Override
    public double getValue(double[] inputVector) {
        double value = 0.0;
        int inputSize = inputVector.length;
        if (this.distanceFunction != null) {
            value = this.distanceFunction.getDistance(this.weight, inputVector);
        } else {
            for (int i = 0; i < inputSize; ++i) {
                value += inputVector[i] * this.weight[i];
            }
        }
        if (this.activationFunction != null) {
            return this.activationFunction.getValue(value);
        }
        return value;
    }

    @Override
    public void setWeight(double[] weight) {
        for (int i = 0; i < weight.length; ++i) {
            this.weight[i] = weight[i];
        }
    }

    public String toString() {
        String text = "";
        text = text + "[ ";
        int weightSize = this.weight.length;
        for (int i = 0; i < weightSize; ++i) {
            text = text + this.weight[i];
            if (i >= weightSize - 1) continue;
            text = text + ", ";
        }
        text = text + " ]";
        return text;
    }

    public MetricModel getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(MetricModel distanceFunction) {
        this.distanceFunction = distanceFunction;
    }
}

