/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import java.util.Random;
import jhpro.nnet.jknnl.ActivationFunctionModel;
import jhpro.nnet.jknnl.NeuronModel;

public class DefaultNeuron
implements NeuronModel {
    private double[] weight;
    private ActivationFunctionModel activationFunction;

    public DefaultNeuron(int weightNumber, double[] maxWeight, ActivationFunctionModel activationFunction) {
        if (weightNumber == maxWeight.length) {
            Random rand = new Random();
            this.weight = new double[weightNumber];
            for (int i = 0; i < weightNumber; ++i) {
                this.weight[i] = rand.nextDouble() * maxWeight[i];
            }
        }
        this.activationFunction = activationFunction;
    }

    public DefaultNeuron(double[] weightArray, ActivationFunctionModel activationFunction) {
        int weightSize = weightArray.length;
        this.weight = new double[weightSize];
        for (int i = 0; i < weightSize; ++i) {
            this.weight[i] = weightArray[i];
        }
        this.activationFunction = activationFunction;
    }

    @Override
    public double[] getWeight() {
        return (double[])this.weight.clone();
    }

    @Override
    public void setWeight(double[] weight) {
        for (int i = 0; i < weight.length; ++i) {
            this.weight[i] = weight[i];
        }
    }

    @Override
    public double getValue(double[] inputVector) {
        double value = 0.0;
        int inputSize = inputVector.length;
        for (int i = 0; i < inputSize; ++i) {
            value += inputVector[i] * this.weight[i];
        }
        if (this.activationFunction != null) {
            return this.activationFunction.getValue(value);
        }
        return value;
    }

    public ActivationFunctionModel getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(ActivationFunctionModel activationFunction) {
        this.activationFunction = activationFunction;
    }
}

