/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet.jknnl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import jhplot.PND;
import jhpro.nnet.jknnl.KohonenNeuron;
import jhpro.nnet.jknnl.NetworkModel;
import jhpro.nnet.jknnl.NeuronModel;
import jhpro.nnet.jknnl.TopologyModel;

public class DefaultNetwork
implements NetworkModel {
    private NeuronModel[] neuronList;
    private TopologyModel topology;

    public DefaultNetwork(int weightNumber, double[] maxWeight, TopologyModel topology) {
        this.topology = topology;
        int numberOfNeurons = topology.getNumbersOfNeurons();
        this.neuronList = new KohonenNeuron[numberOfNeurons];
        for (int i = 0; i < numberOfNeurons; ++i) {
            this.neuronList[i] = new KohonenNeuron(weightNumber, maxWeight, null);
        }
    }

    public DefaultNetwork(String fileName, TopologyModel topology) {
        File file = new File(fileName);
        int neuronNumber = topology.getNumbersOfNeurons();
        this.neuronList = new KohonenNeuron[neuronNumber];
        int rows = 0;
        try {
            String line;
            FileReader fr = new FileReader(file);
            BufferedReader input = new BufferedReader(fr);
            System.out.println("Data from: \"" + fileName + "\" are importing...");
            while ((line = input.readLine()) != null) {
                String[] tempTable = line.split("\t");
                int tableLenght = tempTable.length;
                double[] tempList = new double[tableLenght];
                for (int i = 0; i < tableLenght; ++i) {
                    tempList[i] = Double.valueOf(tempTable[i]);
                }
                this.neuronList[rows] = new KohonenNeuron(tempList, null);
                ++rows;
            }
            fr.close();
            System.out.println(rows + " rows was imported");
        }
        catch (IOException e) {
            System.out.println("File can not be read!. Error: " + e);
        }
        this.topology = topology;
    }

    @Override
    public NeuronModel getNeuron(int neuronNumber) {
        return this.neuronList[neuronNumber];
    }

    @Override
    public int getNumbersOfNeurons() {
        return this.neuronList.length;
    }

    @Override
    public TopologyModel getTopology() {
        return this.topology;
    }

    @Override
    public void setTopology(TopologyModel topology) {
        this.topology = topology;
    }

    public String toString() {
        String text = "";
        int networkSize = this.neuronList.length;
        for (int i = 0; i < networkSize; ++i) {
            text = text + "Neuron number " + (i + 1) + ": " + this.neuronList[i];
            if (i >= networkSize - 1) continue;
            text = text + "\n";
        }
        return text;
    }

    public ArrayList<double[]> getWeightsAsArray() {
        ArrayList<double[]> data = new ArrayList<double[]>();
        for (int i = 0; i < this.neuronList.length; ++i) {
            double[] weight = this.neuronList[i].getWeight();
            data.add(weight);
        }
        return data;
    }

    public PND getWeights() {
        PND data = new PND("weights");
        for (int i = 0; i < this.neuronList.length; ++i) {
            double[] weight = this.neuronList[i].getWeight();
            data.add(weight);
        }
        return data;
    }

    public void networkToFile(String fileName) {
        File outFile = new File(fileName);
        try {
            FileWriter fw = new FileWriter(outFile);
            PrintWriter pw = new PrintWriter(fw);
            int networkSize = this.neuronList.length;
            for (int i = 0; i < networkSize; ++i) {
                String weightList = "";
                double[] weight = this.neuronList[i].getWeight();
                for (int j = 0; j < weight.length; ++j) {
                    weightList = weightList + weight[j];
                    if (j >= weight.length - 1) continue;
                    weightList = weightList + "\t";
                }
                pw.println(weightList);
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("File can not be read!. Error: " + e);
        }
    }
}

