/*
 * Decompiled with CFR 0.152.
 */
package jhpro.nnet;

import jhpro.nnet.InputValue;
import jhpro.nnet.MapNeuron;
import jhpro.nnet.NeuronLayer;
import jhpro.nnet.WeightMatrix;

public class NeuronMatrix {
    MapNeuron[] mapNeuron;
    int nr;
    int xSize;
    int ySize;

    public NeuronMatrix(int i) {
        this.xSize = i;
        this.ySize = 1;
        this.mapNeuron = new MapNeuron[this.xSize * this.ySize];
        for (int j = 0; j < i; ++j) {
            this.mapNeuron[j] = new MapNeuron();
        }
    }

    public NeuronMatrix(int i, int j) {
        this.xSize = i;
        this.ySize = j;
        this.mapNeuron = new MapNeuron[i * j];
        int k = 0;
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                this.mapNeuron[k++] = new MapNeuron();
            }
        }
    }

    public void init(InputValue[] ainputvalue) {
        int i = 0;
        for (int j = 0; j < this.xSize; ++j) {
            for (int k = 0; k < this.ySize; ++k) {
                this.mapNeuron[i].init(j, k);
                ++i;
            }
        }
    }

    public int size() {
        return this.mapNeuron.length;
    }

    public int xSize() {
        return this.xSize;
    }

    public int ySize() {
        return this.ySize;
    }

    public MapNeuron[] getMapNeurons() {
        return this.mapNeuron;
    }

    public MapNeuron computeActivationCenter(NeuronLayer neuronlayer, WeightMatrix weightmatrix) {
        float f = 1.0E20f;
        int i = 0;
        float[] af = new float[weightmatrix.size()];
        float[] af2 = new float[neuronlayer.size()];
        af2 = neuronlayer.getOutput();
        for (int j = 0; j < this.mapNeuron.length; ++j) {
            float[] af1 = weightmatrix.getInputWeights(j);
            float f1 = 0.0f;
            for (int k = 0; k < af2.length; ++k) {
                if (af2[k] == af1[k]) continue;
                f1 += (af2[k] - af1[k]) * (af2[k] - af1[k]);
            }
            if (!(f1 < f)) continue;
            f = f1;
            i = j;
        }
        return this.mapNeuron[i];
    }

    public float[] getFeedback(MapNeuron mapneuron, double d) {
        float[] af = new float[this.mapNeuron.length];
        float f = (float)(2.0 * d * d);
        for (int i = 0; i < this.mapNeuron.length; ++i) {
            af[i] = this.mapNeuron[i].computeFeedback(mapneuron, f);
        }
        return af;
    }
}

