/*
 * Decompiled with CFR 0.152.
 */
package jhpro.interpolator;

import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathArrays;

public class ConstrainedSplineInterpolator
implements UnivariateInterpolator {
    public PolynomialSplineFunction interpolate(double[] x, double[] y) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        if (x.length != y.length) {
            throw new DimensionMismatchException(x.length, y.length);
        }
        if (x.length < 3) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x.length, (Number)3, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder((double[])x);
        double[] dx = new double[n];
        double[] dy = new double[n];
        for (int i = 0; i < n; ++i) {
            dx[i] = x[i + 1] - x[i];
            dy[i] = y[i + 1] - y[i];
        }
        double[] f1 = new double[n + 1];
        for (int i = 1; i < n; ++i) {
            double slope = dy[i - 1] * dy[i];
            if (slope > 0.0) {
                f1[i] = 2.0 / (dx[i] / dy[i] + dx[i - 1] / dy[i - 1]);
                continue;
            }
            if (!(slope <= 0.0)) continue;
            f1[i] = 0.0;
        }
        f1[0] = 3.0 * dy[0] / (2.0 * dx[0]) - f1[1] / 2.0;
        f1[n] = 3.0 * dy[n - 1] / (2.0 * dx[n - 1]) - f1[n - 1] / 2.0;
        double[] a = new double[n + 1];
        double[] b = new double[n + 1];
        double[] c = new double[n + 1];
        double[] d = new double[n + 1];
        for (int i = 1; i <= n; ++i) {
            double f2a = -2.0 * (f1[i] + 2.0 * f1[i - 1]) / dx[i - 1] + 6.0 * dy[i - 1] / (dx[i - 1] * dx[i - 1]);
            double f2b = 2.0 * (2.0 * f1[i] + f1[i - 1]) / dx[i - 1] - 6.0 * dy[i - 1] / (dx[i - 1] * dx[i - 1]);
            d[i] = (f2b - f2a) / (6.0 * dx[i - 1]);
            c[i] = (x[i] * f2a - x[i - 1] * f2b) / (2.0 * dx[i - 1]);
            b[i] = (dy[i - 1] - c[i] * (x[i] * x[i] - x[i - 1] * x[i - 1]) - d[i] * (x[i] * x[i] * x[i] - x[i - 1] * x[i - 1] * x[i - 1])) / dx[i - 1];
            a[i] = y[i - 1] - b[i] * x[i - 1] - c[i] * x[i - 1] * x[i - 1] - d[i] * x[i - 1] * x[i - 1] * x[i - 1];
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        for (int i = 1; i <= n; ++i) {
            coefficients[0] = a[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            final double x0 = x[i - 1];
            polynomials[i - 1] = new PolynomialFunction(coefficients){

                public double value(double x) {
                    return super.value(x + x0);
                }
            };
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

