/*
 * Decompiled with CFR 0.152.
 */
package jhpro.fit;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.awt.Color;
import java.awt.geom.Point2D;
import jhplot.HPlot;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.shapes.Ellipse;
import jhplot.shapes.Text;
import math.geom2d.conic.Ellipse2D;

public class FitEllipse2D {
    private static final Matrix C1 = new Matrix((double[][])new double[][]{{0.0, 0.0, 2.0}, {0.0, -1.0, 0.0}, {2.0, 0.0, 0.0}});
    private static final Matrix C1inv = new Matrix((double[][])new double[][]{{0.0, 0.0, 0.5}, {0.0, -1.0, 0.0}, {0.5, 0.0, 0.0}});
    private static final double EPSILON = 1.0E-15;
    protected double[] coeffs = new double[6];
    protected double A;
    protected double B;
    protected double C;
    protected double D;
    protected double E;
    protected double F;
    protected double distance;
    protected Point2D.Double center;
    protected Double angle;
    protected Double major;
    protected Double minor;

    public FitEllipse2D(double[] x, double[] y) {
        this.fit(x, y);
        this.computeCharacteristics();
    }

    public FitEllipse2D(P1D p) {
        this(p.getArrayX(), p.getArrayY());
    }

    protected FitEllipse2D() {
    }

    public double getAngle() {
        if (this.angle == null) {
            this.computeCharacteristics();
        }
        return this.angle;
    }

    public Point2D.Double getCenter() {
        if (this.center == null) {
            this.computeCharacteristics();
        }
        return this.center;
    }

    public double getCenterX() {
        if (this.center == null) {
            this.computeCharacteristics();
        }
        return this.center.getX();
    }

    public double getCenterY() {
        if (this.center == null) {
            this.computeCharacteristics();
        }
        return this.center.getY();
    }

    public Ellipse2D getEllipse2D() {
        return new Ellipse2D(this.center.getX(), this.center.getY(), this.major, this.minor, this.angle);
    }

    public Ellipse getEllipse() {
        Ellipse ele = new Ellipse(this.center.getX(), this.center.getY(), this.major, this.minor);
        ele.setRotation(this.angle);
        return ele;
    }

    public double[] getCoefficients() {
        return this.coeffs;
    }

    public double getDistance() {
        return this.distance;
    }

    public Double getMajor() {
        if (this.major == null) {
            this.computeCharacteristics();
        }
        return this.major;
    }

    public Double getMinor() {
        if (this.minor == null) {
            this.computeCharacteristics();
        }
        return this.minor;
    }

    protected static void print(Matrix m, String title) {
        StringBuilder sb = new StringBuilder();
        if (title != null) {
            sb.append(String.format("%s%n", title));
        } else {
            sb.append(String.format("%n", new Object[0]));
        }
        for (int row = 0; row < m.getRowDimension(); ++row) {
            sb.append("    ");
            for (int col = 0; col < m.getColumnDimension(); ++col) {
                sb.append(String.format("%15g  ", m.get(row, col)));
            }
            sb.append(String.format("%n", new Object[0]));
        }
        sb.append(String.format("%n", new Object[0]));
    }

    protected void computeAngleAndAxes() {
        if (Math.abs(this.B) < 1.0E-15) {
            if (this.A <= this.C) {
                this.angle = 0.0;
                this.major = Math.sqrt(1.0 / this.A);
                this.minor = Math.sqrt(1.0 / this.C);
            } else {
                this.angle = 1.5707963267948966;
                this.major = Math.sqrt(1.0 / this.C);
                this.minor = Math.sqrt(1.0 / this.A);
            }
        } else {
            double R = (this.C - this.A) / this.B;
            double tg = R - Math.sqrt(R * R + 1.0);
            this.angle = Math.atan(tg);
            double P = 2.0 * tg / (1.0 + tg * tg);
            if (this.B / P <= -this.B / P) {
                this.major = Math.sqrt(2.0 / (this.A + this.C + this.B / P));
                this.minor = Math.sqrt(2.0 / (this.A + this.C - this.B / P));
            } else {
                this.major = Math.sqrt(2.0 / (this.A + this.C - this.B / P));
                this.minor = Math.sqrt(2.0 / (this.A + this.C + this.B / P));
                this.angle = this.angle < 0.0 ? Double.valueOf(this.angle + 1.5707963267948966) : Double.valueOf(this.angle - 1.5707963267948966);
            }
        }
    }

    protected Point2D.Double computeCenter() {
        double den = this.B * this.B - 4.0 * this.A * this.C;
        double x = (2.0 * this.C * this.D - this.B * this.E) / den;
        double y = (2.0 * this.A * this.E - this.B * this.D) / den;
        return new Point2D.Double(x, y);
    }

    protected void computeCenterTranslation() {
        double x = this.center.x;
        double y = this.center.y;
        this.F += this.A * x * x + this.B * x * y + this.C * y * y + this.D * x + this.E * y;
        this.D = 0.0;
        this.E = 0.0;
        this.A /= -this.F;
        this.B /= -this.F;
        this.C /= -this.F;
        this.F = -1.0;
        this.coeffs[0] = this.A;
        this.coeffs[1] = this.B;
        this.coeffs[2] = this.C;
        this.coeffs[3] = this.D;
        this.coeffs[4] = this.E;
        this.coeffs[5] = this.F;
    }

    protected void computeCharacteristics() {
        this.center = this.computeCenter();
        this.computeCenterTranslation();
        this.computeAngleAndAxes();
    }

    protected void fit(double[] x, double[] y) {
        Matrix A1;
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException("x & y arrays have different lengths");
        }
        if (x.length < 6) {
            throw new IllegalArgumentException("Less than 6 defining points");
        }
        int nbPoints = x.length;
        Matrix D1 = new Matrix(nbPoints, 3);
        Matrix D2 = new Matrix(nbPoints, 3);
        for (int i2 = 0; i2 < nbPoints; ++i2) {
            double tx = x[i2];
            double ty = y[i2];
            D1.set(i2, 0, tx * tx);
            D1.set(i2, 1, tx * ty);
            D1.set(i2, 2, ty * ty);
            D2.set(i2, 0, tx);
            D2.set(i2, 1, ty);
            D2.set(i2, 2, 1.0);
        }
        Matrix S1 = D1.transpose().times(D1);
        Matrix S2 = D1.transpose().times(D2);
        Matrix S3 = D2.transpose().times(D2);
        Matrix M = C1inv.times(S1.minus(S2.times(S3.inverse()).times(S2.transpose())));
        EigenvalueDecomposition ed = new EigenvalueDecomposition(M);
        Matrix eigenVectors = ed.getV();
        double[] eigenValues = ed.getRealEigenvalues();
        double lambda = 0.0;
        int index = 0;
        for (i = 0; i < 3; ++i) {
            A1 = eigenVectors.getMatrix(0, 2, i, i);
            Matrix R = A1.transpose().times(C1).times(A1);
            if (!(R.get(0, 0) > 0.0)) continue;
            lambda = eigenValues[i];
            index = i;
        }
        A1 = eigenVectors.getMatrix(0, 2, index, index);
        FitEllipse2D.print(A1, "A1");
        for (i = 0; i < 3; ++i) {
            this.coeffs[i] = A1.get(i, 0);
        }
        Matrix A2 = S3.inverse().times(S2.transpose()).times(A1).uminus();
        FitEllipse2D.print(A2, "A2");
        for (int i3 = 0; i3 < 3; ++i3) {
            this.coeffs[i3 + 3] = A2.get(i3, 0);
        }
        this.A = this.coeffs[0];
        this.B = this.coeffs[1];
        this.C = this.coeffs[2];
        this.D = this.coeffs[3];
        this.E = this.coeffs[4];
        this.F = this.coeffs[5];
        this.distance = lambda > 0.0 ? Math.sqrt(lambda / (double)nbPoints) : 0.0;
        Matrix D = new Matrix(nbPoints, 6);
        D.setMatrix(0, nbPoints - 1, 0, 2, D1);
        D.setMatrix(0, nbPoints - 1, 3, 5, D2);
        Matrix A = new Matrix(6, 1);
        A.setMatrix(0, 2, 0, 0, A1);
        A.setMatrix(3, 5, 0, 0, A2);
        Matrix DA = D.times(A);
        double s = 0.0;
        for (int i4 = 0; i4 < nbPoints; ++i4) {
            double val = DA.get(i4, 0);
            s += val * val;
        }
        this.distance = Math.sqrt(s /= (double)nbPoints);
    }

    public static void main(String[] args) {
        P1D p = new P1D("data");
        p.add(10.0, 20.0);
        p.add(20.0, 40.0);
        p.add(30.0, 30.0);
        p.add(29.0, 30.0);
        p.add(25.0, 44.0);
        p.add(28.0, 40.0);
        p.add(22.0, 12.0);
        FitEllipse2D e = new FitEllipse2D(p.getArrayX(), p.getArrayY());
        System.out.println("Center x=" + Double.toString(e.getCenterX()) + " y=" + Double.toString(e.getCenterX()));
        System.out.println("major=" + Double.toString(e.getMajor()) + " minor=" + Double.toString(e.getMinor()) + " theta=" + Double.toString(e.getAngle()));
        System.out.println("Average=" + Double.toString(e.getDistance()));
        HPlot c1 = new HPlot();
        c1.setRange(0.0, 50.0, 0.0, 60.0);
        c1.visible(true);
        Ellipse ele = new Ellipse(e.getCenterX(), e.getCenterX(), e.getMajor(), e.getMinor());
        ele.setRotation(e.getAngle());
        ele.setFill(true);
        ele.setColor(Color.green);
        ele.setTransparency(0.8);
        c1.add(ele);
        Text tex = new Text("Average Distance=" + Integer.toString((int)e.getDistance()), 20.4, 50.0);
        c1.add(tex);
        c1.draw(p);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

