/*
 * Decompiled with CFR 0.152.
 */
package ellifit;

import ellifit.ControlPoint;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Vector;
import math.geom2d.conic.Ellipse2D;
import org.apache.commons.math3.util.FastMath;

class CurvePanel
extends Panel {
    public static final int BOOKSTEIN = 0;
    public static final int TAUBIN = 1;
    public static final int FPF = 2;
    private int mode = 2;
    public static final int ADD = 0;
    public static final int MOVE = 1;
    public static final int DELETE = 2;
    private int action = 0;
    private int i;
    public String warn_taub_str = "Sorry! Taubin method not yet implemented.";
    private Vector points = new Vector(16, 4);
    private int moving_point;
    private int precision;
    private static double[][] BooksteinConstraint = new double[7][7];
    private static double[][] FPFConstraint = new double[7][7];
    private static double[][] TaubinConstraint = new double[7][7];

    public CurvePanel() {
        this.setBackground(Color.white);
        this.points.addElement(new ControlPoint(10, 10));
        this.points.addElement(new ControlPoint(10, 15));
        this.points.addElement(new ControlPoint(15, 15));
        this.points.addElement(new ControlPoint(20, 55));
        this.points.addElement(new ControlPoint(45, 45));
        this.points.addElement(new ControlPoint(40, 45));
    }

    private void initConstraint() {
    }

    public void setAction(int action) {
        switch (action) {
            case 0: 
            case 1: 
            case 2: {
                this.action = action;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setCurveType(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void clearPoints() {
        this.points.removeAllElements();
    }

    private int findPoint(int a, int b) {
        int max = this.points.size();
        for (int i = 0; i < max; ++i) {
            ControlPoint pnt = (ControlPoint)this.points.elementAt(i);
            if (!pnt.within(a, b)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean handleEvent(Event e) {
        switch (e.id) {
            case 501: {
                switch (this.action) {
                    case 0: {
                        ControlPoint pnt = new ControlPoint(e.x, e.y);
                        this.points.addElement(pnt);
                        this.repaint();
                        break;
                    }
                    case 1: {
                        this.moving_point = this.findPoint(e.x, e.y);
                        break;
                    }
                    case 2: {
                        int delete_pt = this.findPoint(e.x, e.y);
                        if (delete_pt < 0) break;
                        this.points.removeElementAt(delete_pt);
                        this.repaint();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return true;
            }
            case 502: {
                if (this.moving_point >= 0) {
                    this.moving_point = -1;
                    this.repaint();
                }
                return true;
            }
            case 506: {
                if (this.moving_point >= 0) {
                    ControlPoint pnt = (ControlPoint)this.points.elementAt(this.moving_point);
                    pnt.x = e.x;
                    pnt.y = e.y;
                    this.repaint();
                }
                return true;
            }
            case 201: {
                System.exit(0);
                return true;
            }
        }
        return false;
    }

    private void multMatrix(double[][] m, double[][] g, double[][] mg) {
        int j;
        int i;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 2; ++j) {
                mg[i][j] = 0.0;
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 2; ++j) {
                for (int k = 0; k < 4; ++k) {
                    mg[i][j] = mg[i][j] + m[i][k] * g[k][j];
                }
            }
        }
    }

    private void ROTATE(double[][] a, int i, int j, int k, int l, double tau, double s) {
        double g = a[i][j];
        double h = a[k][l];
        a[i][j] = g - s * (h + g * tau);
        a[k][l] = h + s * (g - h * tau);
    }

    private void jacobi(double[][] a, int n, double[] d, double[][] v, int nrot) {
        int iq;
        int ip;
        double[] b = new double[n + 1];
        double[] z = new double[n + 1];
        for (ip = 1; ip <= n; ++ip) {
            for (iq = 1; iq <= n; ++iq) {
                v[ip][iq] = 0.0;
            }
            v[ip][ip] = 1.0;
        }
        for (ip = 1; ip <= n; ++ip) {
            b[ip] = d[ip] = a[ip][ip];
            z[ip] = 0.0;
        }
        nrot = 0;
        for (int i = 1; i <= 50; ++i) {
            double sm = 0.0;
            for (ip = 1; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq <= n; ++iq) {
                    sm += FastMath.abs((double)a[ip][iq]);
                }
            }
            if (sm == 0.0) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 1; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq <= n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * FastMath.abs((double)a[ip][iq]);
                    if (i > 4 && FastMath.abs((double)d[ip]) + g == FastMath.abs((double)d[ip]) && FastMath.abs((double)d[iq]) + g == FastMath.abs((double)d[iq])) {
                        a[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(FastMath.abs((double)a[ip][iq]) > tresh)) continue;
                    double h = d[iq] - d[ip];
                    if (FastMath.abs((double)h) + g == FastMath.abs((double)h)) {
                        t = a[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / a[ip][iq];
                        t = 1.0 / (FastMath.abs((double)theta) + FastMath.sqrt((double)(1.0 + theta * theta)));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / FastMath.sqrt((double)(1.0 + t * t));
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * a[ip][iq];
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    int n4 = ip;
                    d[n4] = d[n4] - h;
                    int n5 = iq;
                    d[n5] = d[n5] + h;
                    a[ip][iq] = 0.0;
                    for (j = 1; j <= ip - 1; ++j) {
                        this.ROTATE(a, j, ip, j, iq, tau, s);
                    }
                    for (j = ip + 1; j <= iq - 1; ++j) {
                        this.ROTATE(a, ip, j, j, iq, tau, s);
                    }
                    for (j = iq + 1; j <= n; ++j) {
                        this.ROTATE(a, ip, j, iq, j, tau, s);
                    }
                    for (j = 1; j <= n; ++j) {
                        this.ROTATE(v, j, ip, j, iq, tau, s);
                    }
                    ++nrot;
                }
            }
            for (ip = 1; ip <= n; ++ip) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d[ip] = b[ip];
                z[ip] = 0.0;
            }
        }
    }

    private void choldc(double[][] a, int n, double[][] l) {
        int j;
        int i;
        double[] p = new double[n + 1];
        for (i = 1; i <= n; ++i) {
            for (j = i; j <= n; ++j) {
                double sum = a[i][j];
                for (int k = i - 1; k >= 1; --k) {
                    sum -= a[i][k] * a[j][k];
                }
                if (i == j) {
                    if (sum <= 0.0) continue;
                    p[i] = FastMath.sqrt((double)sum);
                    continue;
                }
                a[j][i] = sum / p[i];
            }
        }
        for (i = 1; i <= n; ++i) {
            for (j = i; j <= n; ++j) {
                if (i == j) {
                    l[i][i] = p[i];
                    continue;
                }
                l[j][i] = a[j][i];
                l[i][j] = 0.0;
            }
        }
    }

    int inverse(double[][] TB, double[][] InvB, int N) {
        int j;
        int k;
        double[][] B = new double[N + 1][N + 2];
        double[][] A = new double[N + 1][2 * N + 2];
        double[][] C = new double[N + 1][N + 1];
        double eps = 1.0E-19;
        for (k = 1; k <= N; ++k) {
            for (j = 1; j <= N; ++j) {
                B[k][j] = TB[k][j];
            }
        }
        for (k = 1; k <= N; ++k) {
            for (j = 1; j <= N + 1; ++j) {
                A[k][j] = B[k][j];
            }
            for (j = N + 2; j <= 2 * N + 1; ++j) {
                A[k][j] = 0.0;
            }
            A[k][k - 1 + N + 2] = 1.0;
        }
        for (k = 1; k <= N; ++k) {
            int i;
            double maxpivot = FastMath.abs((double)A[k][k]);
            int npivot = k;
            for (i = k; i <= N; ++i) {
                if (!(maxpivot < FastMath.abs((double)A[i][k]))) continue;
                maxpivot = FastMath.abs((double)A[i][k]);
                npivot = i;
            }
            if (maxpivot >= eps) {
                if (npivot != k) {
                    for (j = k; j <= 2 * N + 1; ++j) {
                        double temp = A[npivot][j];
                        A[npivot][j] = A[k][j];
                        A[k][j] = temp;
                    }
                }
                double D = A[k][k];
                for (j = 2 * N + 1; j >= k; --j) {
                    A[k][j] = A[k][j] / D;
                }
                for (i = 1; i <= N; ++i) {
                    if (i == k) continue;
                    double mult = A[i][k];
                    for (j = 2 * N + 1; j >= k; --j) {
                        A[i][j] = A[i][j] - mult * A[k][j];
                    }
                }
                continue;
            }
            return -1;
        }
        k = 1;
        int p = 1;
        while (k <= N) {
            j = N + 2;
            int q = 1;
            while (j <= 2 * N + 1) {
                InvB[p][q] = A[k][j];
                ++j;
                ++q;
            }
            ++k;
            ++p;
        }
        return 0;
    }

    private void AperB(double[][] _A, double[][] _B, double[][] _res, int _righA, int _colA, int _righB, int _colB) {
        for (int p = 1; p <= _righA; ++p) {
            for (int q = 1; q <= _colB; ++q) {
                _res[p][q] = 0.0;
                for (int l = 1; l <= _colA; ++l) {
                    _res[p][q] = _res[p][q] + _A[p][l] * _B[l][q];
                }
            }
        }
    }

    private void A_TperB(double[][] _A, double[][] _B, double[][] _res, int _righA, int _colA, int _righB, int _colB) {
        for (int p = 1; p <= _colA; ++p) {
            for (int q = 1; q <= _colB; ++q) {
                _res[p][q] = 0.0;
                for (int l = 1; l <= _righA; ++l) {
                    _res[p][q] = _res[p][q] + _A[l][p] * _B[l][q];
                }
            }
        }
    }

    private void AperB_T(double[][] _A, double[][] _B, double[][] _res, int _righA, int _colA, int _righB, int _colB) {
        for (int p = 1; p <= _colA; ++p) {
            for (int q = 1; q <= _colB; ++q) {
                _res[p][q] = 0.0;
                for (int l = 1; l <= _righA; ++l) {
                    _res[p][q] = _res[p][q] + _A[p][l] * _B[q][l];
                }
            }
        }
    }

    public void pv(double[] v, String str) {
        System.out.println("------------" + str + "--------------");
        System.out.println(" " + v[1] + " " + v[2] + " " + v[3] + " " + v[4] + " " + v[5] + " " + v[6]);
        System.out.println("------------------------------------------");
    }

    public void pm(double[][] S, String str) {
        System.out.println("------------" + str + "--------------");
        System.out.println(" " + S[1][1] + " " + S[1][2] + " " + S[1][3] + " " + S[1][4] + " " + S[1][5] + " " + S[1][6]);
        System.out.println(" " + S[2][1] + " " + S[2][2] + " " + S[2][3] + " " + S[2][4] + " " + S[2][5] + " " + S[2][6]);
        System.out.println(" " + S[3][1] + " " + S[3][2] + " " + S[3][3] + " " + S[3][4] + " " + S[3][5] + " " + S[3][6]);
        System.out.println(" " + S[4][1] + " " + S[4][2] + " " + S[4][3] + " " + S[4][4] + " " + S[4][5] + " " + S[4][6]);
        System.out.println(" " + S[5][1] + " " + S[5][2] + " " + S[5][3] + " " + S[5][4] + " " + S[5][5] + " " + S[5][6]);
        System.out.println(" " + S[6][1] + " " + S[6][2] + " " + S[6][3] + " " + S[6][4] + " " + S[6][5] + " " + S[6][6]);
        System.out.println("------------------------------------------");
    }

    public void draw_conic(double[] pvec, int nptsk, double[][] points) {
        int j;
        int npts = nptsk / 2;
        double[][] u = new double[3][npts + 1];
        double[][] Aiu = new double[3][npts + 1];
        double[][] L = new double[3][npts + 1];
        double[][] B = new double[3][npts + 1];
        double[][] Xpos = new double[3][npts + 1];
        double[][] Xneg = new double[3][npts + 1];
        double[][] ss1 = new double[3][npts + 1];
        double[][] ss2 = new double[3][npts + 1];
        double[] lambda = new double[npts + 1];
        double[][] uAiu = new double[3][npts + 1];
        double[][] A = new double[3][3];
        double[][] Ai = new double[3][3];
        double[][] Aib = new double[3][2];
        double[][] b = new double[3][2];
        double[][] r1 = new double[2][2];
        double pi = 3.14781;
        double Ao = pvec[6];
        double Ax = pvec[4];
        double Ay = pvec[5];
        double Axx = pvec[1];
        double Ayy = pvec[3];
        double Axy = pvec[2];
        A[1][1] = Axx;
        A[1][2] = Axy / 2.0;
        A[2][1] = Axy / 2.0;
        A[2][2] = Ayy;
        b[1][1] = Ax;
        b[2][1] = Ay;
        int i = 1;
        double theta = 0.0;
        while (i <= npts) {
            u[1][i] = FastMath.cos((double)theta);
            u[2][i] = FastMath.sin((double)theta);
            ++i;
            theta += pi / (double)npts;
        }
        this.inverse(A, Ai, 2);
        this.AperB(Ai, b, Aib, 2, 2, 2, 1);
        this.A_TperB(b, Aib, r1, 2, 1, 2, 1);
        r1[1][1] = r1[1][1] - 4.0 * Ao;
        this.AperB(Ai, u, Aiu, 2, 2, 2, npts);
        for (i = 1; i <= 2; ++i) {
            for (j = 1; j <= npts; ++j) {
                uAiu[i][j] = u[i][j] * Aiu[i][j];
            }
        }
        for (j = 1; j <= npts; ++j) {
            double d;
            double kk = r1[1][1] / (uAiu[1][j] + uAiu[2][j]);
            lambda[j] = d >= 0.0 ? FastMath.sqrt((double)kk) : -1.0;
        }
        for (j = 1; j <= npts; ++j) {
            double d = lambda[j];
            L[2][j] = d;
            L[1][j] = d;
        }
        for (j = 1; j <= npts; ++j) {
            B[1][j] = b[1][1];
            B[2][j] = b[2][1];
        }
        for (j = 1; j <= npts; ++j) {
            ss1[1][j] = 0.5 * (L[1][j] * u[1][j] - B[1][j]);
            ss1[2][j] = 0.5 * (L[2][j] * u[2][j] - B[2][j]);
            ss2[1][j] = 0.5 * (-L[1][j] * u[1][j] - B[1][j]);
            ss2[2][j] = 0.5 * (-L[2][j] * u[2][j] - B[2][j]);
        }
        this.AperB(Ai, ss1, Xpos, 2, 2, 2, npts);
        this.AperB(Ai, ss2, Xneg, 2, 2, 2, npts);
        for (j = 1; j <= npts; ++j) {
            if (lambda[j] == -1.0) {
                points[1][j] = -1.0;
                points[2][j] = -1.0;
                points[1][j + npts] = -1.0;
                points[2][j + npts] = -1.0;
                continue;
            }
            points[1][j] = Xpos[1][j];
            points[2][j] = Xpos[2][j];
            points[1][j + npts] = Xneg[1][j];
            points[2][j + npts] = Xneg[2][j];
        }
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int np = this.points.size();
        double[][] D = new double[np + 1][7];
        double[][] S = new double[7][7];
        double[][] Const = new double[7][7];
        double[][] temp = new double[7][7];
        double[][] L = new double[7][7];
        double[][] C = new double[7][7];
        double[][] invL = new double[7][7];
        double[] d = new double[7];
        double[][] V = new double[7][7];
        double[][] sol = new double[7][7];
        int nrot = 0;
        int npts = 50;
        double[][] XY = new double[3][npts + 1];
        double[] pvec = new double[7];
        g.setColor(this.getForeground());
        g.setPaintMode();
        g.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        for (i = 0; i < np; ++i) {
            ControlPoint p = (ControlPoint)this.points.elementAt(i);
            g.drawOval(p.x - 2, p.y - 2, 2 * 2, 2 * 2);
        }
        switch (this.mode) {
            case 2: {
                Const[1][3] = -2.0;
                Const[2][2] = 1.0;
                Const[3][1] = -2.0;
                break;
            }
            case 1: {
                g.drawString(this.warn_taub_str, this.size().width / 18, this.size().height / 18);
                break;
            }
            case 0: {
                Const[1][1] = 2.0;
                Const[2][2] = 1.0;
                Const[3][3] = 2.0;
            }
        }
        if (np < 6) {
            return;
        }
        for (i = 1; i <= np; ++i) {
            double tx = ((ControlPoint)this.points.elementAt((int)(i - 1))).x;
            double ty = ((ControlPoint)this.points.elementAt((int)(i - 1))).y;
            D[i][1] = tx * tx;
            D[i][2] = tx * ty;
            D[i][3] = ty * ty;
            D[i][4] = tx;
            D[i][5] = ty;
            D[i][6] = 1.0;
        }
        this.A_TperB(D, D, S, np, 6, np, 6);
        this.choldc(S, 6, L);
        this.inverse(L, invL, 6);
        this.AperB_T(Const, invL, temp, 6, 6, 6, 6);
        this.AperB(invL, temp, C, 6, 6, 6, 6);
        this.jacobi(C, 6, d, V, nrot);
        this.A_TperB(invL, V, sol, 6, 6, 6, 6);
        for (int j = 1; j <= 6; ++j) {
            int i2;
            double mod = 0.0;
            for (i2 = 1; i2 <= 6; ++i2) {
                mod += sol[i2][j] * sol[i2][j];
            }
            for (i2 = 1; i2 <= 6; ++i2) {
                double[] dArray = sol[i2];
                int n = j;
                dArray[n] = dArray[n] / FastMath.sqrt((double)mod);
            }
        }
        double zero = 1.0E-19;
        double minev = 1.0E21;
        int solind = 0;
        switch (this.mode) {
            case 0: {
                this.i = 1;
                while (this.i <= 6) {
                    if (d[this.i] < minev && FastMath.abs((double)d[this.i]) > zero) {
                        solind = this.i;
                    }
                    ++this.i;
                }
                break;
            }
            case 2: {
                this.i = 1;
                while (this.i <= 6) {
                    if (d[this.i] < 0.0 && FastMath.abs((double)d[this.i]) > zero) {
                        solind = this.i;
                    }
                    ++this.i;
                }
                break;
            }
        }
        for (int j = 1; j <= 6; ++j) {
            pvec[j] = sol[j][solind];
        }
        this.pv(pvec, "the solution.");
        double A0 = pvec[6];
        double Ax = pvec[4];
        double Ay = pvec[5];
        double Axx = pvec[1];
        double Ayy = pvec[3];
        double Axy = pvec[2];
        double aC = Axx;
        double bC = Axy / 2.0;
        double cC = Ayy;
        double dC = Ax / 2.0;
        double fC = Ay / 2.0;
        double gC = A0;
        double num = bC * bC - aC * cC;
        double x0 = (cC * dC - bC * fC) / num;
        double y0 = (aC * fC - bC * dC) / num;
        System.out.println("Center x=" + Double.toString(x0) + " y=" + Double.toString(y0));
        for (int i3 = 0; i3 < np; ++i3) {
            ControlPoint controlPoint = (ControlPoint)this.points.elementAt(i3);
        }
        double angle = 0.5 * FastMath.atan((double)(2.0 * bC / (aC - cC)));
        System.out.println("Angle of rotation=" + Double.toString(angle));
        double up = 2.0 * (aC * fC * fC + cC * dC * dC + gC * bC * bC - 2.0 * bC * dC * fC - aC * cC * gC);
        double xx = bC * bC - aC * cC;
        double down1 = xx * ((cC - aC) * FastMath.sqrt((double)(1.0 + 4.0 * bC * bC / ((aC - cC) * (aC - cC)))) - (cC + aC));
        double down2 = xx * ((aC - cC) * FastMath.sqrt((double)(1.0 + 4.0 * bC * bC / ((aC - cC) * (aC - cC)))) - (cC + aC));
        double res1 = FastMath.sqrt((double)(up / down1));
        double res2 = FastMath.sqrt((double)(up / down2));
        double major = res1;
        double minor = res2;
        if (major < minor) {
            major = res2;
            minor = res1;
        }
        System.out.println("Length major=" + Double.toString(major) + " minor=" + Double.toString(minor));
        double average = 0.0;
        double rms = 0.0;
        Ellipse2D elip = new Ellipse2D(x0, y0, major, minor, angle);
        for (int i4 = 0; i4 < np; ++i4) {
            ControlPoint p = (ControlPoint)this.points.elementAt(i4);
            double dist = elip.signedDistance(p.x, p.y);
            System.out.println("Distance=" + Double.toString(dist));
            double delta = FastMath.abs((double)dist);
            average += delta;
            rms += delta * delta;
        }
        double drms = FastMath.sqrt((double)(rms / (double)np));
        System.out.println("average deviation=" + Double.toString(average /= (double)np) + " RMS=" + Double.toString(drms));
        this.draw_conic(pvec, npts, XY);
        for (int i5 = 1; i5 < npts; ++i5) {
            if (XY[1][i5] == -1.0 || XY[1][i5 + 1] == -1.0) continue;
            if (i5 < npts) {
                g.drawLine((int)XY[1][i5], (int)XY[2][i5], (int)XY[1][i5 + 1], (int)XY[2][i5 + 1]);
                continue;
            }
            g.drawLine((int)XY[1][i5], (int)XY[2][i5], (int)XY[1][1], (int)XY[2][1]);
        }
    }
}

