/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.decision;

import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.learning.bagging.Bagging;
import edu.uci.jforests.learning.trees.decision.DecisionPredictions;
import edu.uci.jforests.learning.trees.decision.DecisionTreeLearner;
import edu.uci.jforests.sample.Predictions;
import edu.uci.jforests.util.ConfigHolder;

public class RandomForest
extends Bagging {
    protected int numClasses;
    protected DecisionTreeLearner treeLearner = new DecisionTreeLearner();

    public RandomForest() throws Exception {
        this.setSubModule(this.treeLearner);
    }

    public void init(Dataset dataset, ConfigHolder configHolder, int maxNumTrainInstances, int maxNumValidInstances, EvaluationMetric evaluationMetric) throws Exception {
        double maxTarget = 0.0;
        for (int i = 0; i < dataset.numInstances; ++i) {
            if (!(dataset.targets[i] > maxTarget)) continue;
            maxTarget = dataset.targets[i];
        }
        this.numClasses = (int)maxTarget + 1;
        super.init(configHolder, maxNumTrainInstances, maxNumValidInstances, evaluationMetric);
        this.treeLearner.init(this.numClasses, dataset, configHolder, maxNumTrainInstances);
    }

    @Override
    protected Predictions getNewPredictions() {
        return new DecisionPredictions(this.numClasses);
    }
}

