/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.decision;

import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.dataset.Histogram;
import edu.uci.jforests.learning.trees.CandidateSplitsForLeaf;
import edu.uci.jforests.learning.trees.decision.DecisionCandidateSplitsForLeaf;
import edu.uci.jforests.util.MathUtil;

public class DecisionHistogram
extends Histogram {
    public double[] targetDist;
    public double[][] perValueTargetDist;
    private int numClasses;

    public DecisionHistogram(Feature feature, int numClasses) {
        super(feature);
        this.numClasses = numClasses;
        this.targetDist = new double[numClasses];
        this.perValueTargetDist = new double[this.numValues][numClasses];
        for (int i = 0; i < this.numValues; ++i) {
            this.perValueTargetDist[i] = new double[numClasses];
        }
    }

    @Override
    protected void initCustomData(CandidateSplitsForLeaf leafSplitCandidates, int[] instances) {
        DecisionCandidateSplitsForLeaf dLeafSplitCandidates = (DecisionCandidateSplitsForLeaf)leafSplitCandidates;
        System.arraycopy(dLeafSplitCandidates.getTargetDist(), 0, this.targetDist, 0, this.numClasses);
        MathUtil.clearDoubleMatrix(this.perValueTargetDist);
        this.feature.bins.initHistogram(this, this.totalCount, leafSplitCandidates.getTargets(), leafSplitCandidates.getWeights(), leafSplitCandidates.getIndices(), instances);
    }

    @Override
    protected void subtractCustomData(Histogram child) {
        DecisionHistogram dChild = (DecisionHistogram)child;
        for (int c = 0; c < this.numClasses; ++c) {
            int n = c;
            this.targetDist[n] = this.targetDist[n] - dChild.targetDist[c];
            for (int i = 0; i < this.numValues; ++i) {
                double[] dArray = this.perValueTargetDist[i];
                int n2 = c;
                dArray[n2] = dArray[n2] - dChild.perValueTargetDist[i][c];
            }
        }
    }
}

