/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.decision;

import edu.uci.jforests.learning.trees.CandidateSplitsForLeaf;
import edu.uci.jforests.learning.trees.LeafInstances;
import edu.uci.jforests.learning.trees.TreeLeafInstances;
import edu.uci.jforests.learning.trees.decision.DecisionTreeSplit;
import edu.uci.jforests.sample.Sample;
import java.util.Arrays;

public class DecisionCandidateSplitsForLeaf
extends CandidateSplitsForLeaf {
    protected double[] targetDist;

    public DecisionCandidateSplitsForLeaf(int numFeatures, int numInstances, int numClasses) {
        super(numFeatures, numInstances);
        this.targetDist = new double[numClasses];
        this.bestSplitPerFeature = new DecisionTreeSplit[numFeatures];
        for (int f = 0; f < numFeatures; ++f) {
            this.bestSplitPerFeature[f] = new DecisionTreeSplit(this.targetDist.length);
        }
    }

    public double[] getTargetDist() {
        return this.targetDist;
    }

    @Override
    public void init(int curLeafIndex, TreeLeafInstances treeLeafInstances, Sample trainSet) {
        this.init(curLeafIndex);
        this.totalWeightedCount = 0.0;
        LeafInstances leafInstances = treeLeafInstances.getLeafInstances(curLeafIndex);
        this.numInstancesInLeaf = leafInstances.end - leafInstances.begin;
        Arrays.fill(this.targetDist, 0.0);
        for (int i = 0; i < this.numInstancesInLeaf; ++i) {
            this.indices[i] = leafInstances.indices[leafInstances.begin + i];
            double target = trainSet.targets[this.indices[i]];
            double weight = trainSet.weights[this.indices[i]];
            this.targets[i] = target;
            this.weights[i] = weight;
            int n = (int)target;
            this.targetDist[n] = this.targetDist[n] + weight;
            this.totalWeightedCount += weight;
        }
    }
}

