/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees;

import edu.uci.jforests.learning.trees.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class Ensemble {
    private List<Tree> trees = new ArrayList<Tree>();
    private List<Double> weights = new ArrayList<Double>();

    public List<Tree> getTrees() {
        return this.trees;
    }

    public void addTree(Tree tree, double weight) {
        this.trees.add(tree);
        this.weights.add(weight);
    }

    public void addTreeAt(Tree tree, double weight, int index) {
        this.trees.add(index, tree);
        this.weights.add(weight);
    }

    public void removeTree(int index) {
        this.trees.remove(index);
        this.weights.remove(index);
    }

    public void removeLastTrees(int k) {
        for (int i = 0; i < k; ++i) {
            this.removeTree(this.trees.size() - 1);
        }
    }

    public Tree getTreeAt(int index) {
        return this.trees.get(index);
    }

    public double getWeightAt(int index) {
        return this.weights.get(index);
    }

    public int getNumTrees() {
        return this.trees.size();
    }

    public List<Double> getWeights() {
        return this.weights;
    }

    public void setWeights(List<Double> weights) {
        this.weights = weights;
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int prefix) {
        if (prefix > this.trees.size() || prefix < 0) {
            prefix = this.trees.size();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<Ensemble>");
        for (int i = 0; i < prefix; ++i) {
            sb.append(this.trees.get(i).toString(this.weights.get(i), 1));
        }
        sb.append("\n</Ensemble>");
        return sb.toString();
    }

    private String getXmlAttribute(String line, String attr) {
        int idx = line.indexOf(attr + "=\"");
        if (idx < 0) {
            return null;
        }
        int endIdx = line.indexOf(34, idx + attr.length() + 2);
        return line.substring(idx + attr.length() + 2, endIdx);
    }

    public <T extends Tree> void loadFromFile(Class<T> _c, File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while ((line = reader.readLine()) != null && !(line = line.trim()).equals("</Ensemble>")) {
            String header = line;
            int leaves = Integer.parseInt(this.getXmlAttribute(header, "leaves"));
            double weight = Double.parseDouble(this.getXmlAttribute(header, "weight"));
            String featuresLine = reader.readLine();
            String leftChildrenLine = reader.readLine();
            String rightChildrenLine = reader.readLine();
            String thresholds = reader.readLine();
            String originalThresholds = reader.readLine();
            Tree tree = (Tree)_c.newInstance();
            tree.loadFromString(leaves, featuresLine, leftChildrenLine, rightChildrenLine, thresholds, originalThresholds);
            tree.loadCustomData(reader.readLine());
            reader.readLine();
            this.addTree(tree, weight);
        }
    }
}

